/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Enumeradores.NivelEnum;
import Modelos.Dao.AmbitoDestrezaDao;
import Modelos.Dao.AmbitoDestrezaDaoImpl;
import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Entidades.AmbitoDestreza;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Vistas.FuncionesAuxiliar;
import Vistas.model.CalificacionInicialTableJbroModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VistaNotaInicial
extends JPanel {
    private Integer codigoParaleloSeleccionado;
    private AmbitoDestreza ambitoSeleccionado;
    private List<AmbitoDestreza> ambitos;
    private List<Asignacion> asignacion = new ArrayList<Asignacion>();
    private Instructor instructor = new Instructor();
    private final JComboBox<AmbitoDestreza> comboAmbitos = new JComboBox();
    private final AsistenciaBachilleratoDaoImpl asistenciaBachilleratoDaoImpl = new AsistenciaBachilleratoDaoImpl();
    private final AmbitoDestrezaDao ambitoDestrezaDao = new AmbitoDestrezaDaoImpl();
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private Panel panel1;
    private JPanel panelCombo;
    private JPanel panelTablaAsistencia;

    public VistaNotaInicial() {
        this.initComponents();
        this.comboAmbitos.setPreferredSize(new Dimension(350, 25));
        JPanel panelAgrupadoComboLabel = new JPanel();
        JLabel etiquetaMes = new JLabel(" * Seleccione un \u00e1mbito: ");
        panelAgrupadoComboLabel.add(etiquetaMes);
        panelAgrupadoComboLabel.add(this.comboAmbitos);
        panelAgrupadoComboLabel.setBorder(new EmptyBorder(15, 15, 15, 15));
        panelAgrupadoComboLabel.setBackground(new Color(245, 245, 245));
        this.panelCombo.setLayout(new BorderLayout());
        this.panelCombo.setBackground(new Color(245, 245, 245));
        this.panelCombo.add((Component)panelAgrupadoComboLabel, "Before");
        this.panelTablaAsistencia.setLayout(new BorderLayout());
        JPanel panelInformacion = new JPanel();
        JPanel panelAuxiliar = new JPanel();
        JLabel informacionInicial = new JLabel("Estimado docente, seleccione un \u00e1mbito. ");
        informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
        panelInformacion.add((Component)informacionInicial, "Center");
        panelInformacion.setBackground(new Color(252, 248, 227));
        panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
        panelAuxiliar.add(panelInformacion);
        panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCombo, "First");
        this.add((Component)this.panelTablaAsistencia, "Center");
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.panelTablaAsistencia = new JPanel();
        this.panelCombo = new JPanel();
        this.setPreferredSize(new Dimension(452, 402));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTablaAsistencia, "Center");
        this.add((Component)this.panelCombo, "First");
    }

    private void cargarAmbitos() {
        AmbitoDestreza ambitoSeleccione = new AmbitoDestreza();
        ambitoSeleccione.setDescripcion("Seleccione...");
        this.comboAmbitos.addItem(ambitoSeleccione);
        String nemonico = this.instructor.getNemTipoNivel().equals(NivelEnum.INICIAL1.getNemonico()) ? "1IN" : (this.instructor.getNemTipoNivel().equals(NivelEnum.INICIAL2.getNemonico()) ? "2IN" : "1EGB");
        this.ambitos = this.instructor.getIdTipoCultura() == 1 ? this.ambitoDestrezaDao.listarAmbitos(nemonico, this.instructor.getIdMateria()) : this.ambitoDestrezaDao.listarAmbitosBilingue(nemonico, this.instructor.getIdMateria());
        for (AmbitoDestreza item : this.ambitos) {
            this.comboAmbitos.addItem(item);
        }
        this.comboAmbitos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VistaNotaInicial.this.getMesSeleccionado();
                VistaNotaInicial.this.panelTablaAsistencia.updateUI();
                VistaNotaInicial.this.updateUI();
            }
        });
    }

    public void iniciarCarga(Integer codigoParalelo, Instructor instructor) {
        this.codigoParaleloSeleccionado = codigoParalelo;
        this.instructor = instructor;
        if (this.asistenciaBachilleratoDaoImpl.buscarAsistenciaPorParalelo(this.codigoParaleloSeleccionado).isEmpty()) {
            this.panelCombo.removeAll();
            this.panelTablaAsistencia.removeAll();
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("El paralelo no presenta estudiantes. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece el paralelo.");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelCombo.add((Component)panelAuxiliar, "First");
        } else {
            this.cargarAmbitos();
        }
    }

    public void getMesSeleccionado() {
        this.ambitoSeleccionado = (AmbitoDestreza)this.comboAmbitos.getSelectedItem();
        this.asignacion = this.asistenciaBachilleratoDaoImpl.buscarAsistenciaPorParalelo(this.codigoParaleloSeleccionado);
        this.panelTablaAsistencia.removeAll();
        if (this.ambitoSeleccionado.getNemonicoGrado() == null) {
            this.panelTablaAsistencia.removeAll();
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("Estimado docente, seleccione un \u00e1mbito.");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        } else {
            List<AmbitoDestreza> destrezas = this.ambitoDestrezaDao.listarAmbitosDestrezasPorIdPadreJornada(this.ambitoSeleccionado.getIdAplicacion(), this.ambitoSeleccionado.getIdJornada());
            if (destrezas.isEmpty()) {
                this.panelTablaAsistencia.removeAll();
                JPanel panelInformacion = new JPanel();
                JPanel panelAuxiliar = new JPanel();
                JLabel informacionInicial = new JLabel("Estimado docente, no existen destrezas.");
                informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
                panelInformacion.add((Component)informacionInicial, "Center");
                panelInformacion.setBackground(new Color(252, 248, 227));
                panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
                panelAuxiliar.add(panelInformacion);
                panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
                this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
            } else if (this.asignacion.isEmpty()) {
                JLabel informacion = new JLabel("El paralelo no presenta estudiantes. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece el paralelo.");
                this.panelTablaAsistencia.add((Component)informacion, "Center");
            } else {
                this.panelTablaAsistencia.add((Component)new CalificacionInicialTableJbroModel(this.codigoParaleloSeleccionado, this.asignacion, this.ambitoSeleccionado, this.instructor).getScroll(), "Center");
            }
        }
    }

    public Integer getCodigoParaleloSeleccionado() {
        return this.codigoParaleloSeleccionado;
    }

    public void setCodigoParaleloSeleccionado(Integer codigoParaleloSeleccionado) {
        this.codigoParaleloSeleccionado = codigoParaleloSeleccionado;
    }
}

