/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Enumeradores.EstadoEnum;
import Enumeradores.MaximoCaracteres;
import Modelos.Dao.DetalleUnidadPcaDao;
import Modelos.Dao.DetalleUnidadPcaDaoImpl;
import Modelos.Dao.InstructorDao;
import Modelos.Dao.InstructorDaoImpl;
import Modelos.Dao.ObjetivoPcaDao;
import Modelos.Dao.ObjetivoPcaDaoImpl;
import Modelos.Dao.PcaDao;
import Modelos.Dao.PcaDaoImpl;
import Modelos.Dao.UnidadPcaDao;
import Modelos.Dao.UnidadPcaDaoImpl;
import Modelos.Entidades.DestrezaPca;
import Modelos.Entidades.ObjetivoPca;
import Modelos.Entidades.Pca;
import Modelos.Entidades.UnidadPca;
import Modelos.Entidades.UnidadPcaDTO;
import Servicios.Sincronizacion.SincronizarPca;
import Util.Constantes;
import Util.DestrezaPcaUtil;
import Util.FileUtil;
import Util.Util;
import Vistas.FuncionesAuxiliar;
import Vistas.PanelUnidadesPCA;
import Vistas.VistaPrincipal;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.ArrayUtils;

public class VistaPcaPlantilla
extends JPanel {
    private JTabbedPane tabUnidades;
    private VistaPrincipal jfrParent;
    private JEditorPane pnObjetivos;
    private JEditorPane jepEjesTransversales;
    private JEditorPane jepObjetivosGrado;
    private Pca pca;
    private JSpinner jspSemanaTrabajo;
    private JSpinner jspCargaHoraria;
    private JLabel jspSemanaEvaluacion;
    private JLabel jlTotalPeriodos;
    private final Integer totalSemanas = 40;
    private JTextArea bibliografia;
    private JTextArea observaciones;
    private Integer idUsuarioCreacion;
    private JButton btnGuardar;
    private List<UnidadPcaDTO> listaUnidadImprimir;
    private final PcaDao pcaDao = new PcaDaoImpl();
    private final InstructorDao instructorDao = new InstructorDaoImpl();
    private final UnidadPcaDao unidadPcaDao = new UnidadPcaDaoImpl();
    private final DetalleUnidadPcaDao detalleUnidadPcaDao = new DetalleUnidadPcaDaoImpl();
    private final ObjetivoPcaDao objetivoPcaDao = new ObjetivoPcaDaoImpl();

    public void iniciarPcaPlantilla(final VistaPrincipal jfrParent, Pca pca) {
        this.setLayout(new BorderLayout());
        this.tabUnidades = new JTabbedPane();
        Dimension dPanelesMitad = new Dimension(50, 50);
        Dimension dPanelTextos = new Dimension(100, 50);
        GridLayout grid1 = new GridLayout(1, 0);
        this.jfrParent = jfrParent;
        this.pca = pca;
        try {
            this.idUsuarioCreacion = this.instructorDao.obtenerIdUsuario();
        }
        catch (Exception ex) {
            Logger.getLogger(VistaPcaPlantilla.class.getName()).log(Level.SEVERE, null, ex);
        }
        JPanel cuerpo = new JPanel();
        cuerpo.setLayout(new BoxLayout(cuerpo, 1));
        cuerpo.setBorder(new EmptyBorder(10, 10, 10, 10));
        cuerpo.setBackground(new Color(245, 245, 245));
        JPanel linea1 = new JPanel();
        FuncionesAuxiliar fAuxiliar = new FuncionesAuxiliar();
        Font font2 = fAuxiliar.establecerFont(2);
        Font font3 = fAuxiliar.establecerFont(3);
        linea1.setLayout(grid1);
        linea1.setBackground(new Color(12, 98, 184));
        linea1.setAlignmentX(0.5f);
        JLabel titulo = new JLabel("PLANIFICACI\u00d3N CURRICULAR ANUAL");
        titulo.setForeground(Color.WHITE);
        titulo.setFont(font2);
        titulo.setHorizontalAlignment(0);
        linea1.add(titulo);
        this.add((Component)linea1, "First");
        JPanel linea2 = new JPanel();
        linea2.setLayout(new GridLayout(2, 5));
        TitledBorder titulo2 = BorderFactory.createTitledBorder("TIEMPO");
        titulo2.setTitleFont(font3);
        linea2.setBorder(titulo2);
        linea2.add(new JLabel("<html>Carga horaria semanal</html>"));
        linea2.add(new JLabel("<html>No. Semanas de trabajo</html>"));
        linea2.add(new JLabel("<html>Evaluaci\u00f3n del aprendizaje<br/> e imprevistos</html>"));
        linea2.add(new JLabel("<html>Total de semanas clases</html>"));
        linea2.add(new JLabel("<html>Total de periodos</html>"));
        SpinnerNumberModel sm = new SpinnerNumberModel(1, 1, 37, 1);
        this.jspSemanaTrabajo = new JSpinner(sm);
        this.jspSemanaEvaluacion = new JLabel("0");
        this.jspSemanaEvaluacion.setHorizontalAlignment(0);
        this.jspSemanaTrabajo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VistaPcaPlantilla.this.jlTotalPeriodos.setText(VistaPcaPlantilla.this.calcularTotalPeriodos());
                VistaPcaPlantilla.this.jspSemanaEvaluacion.setText(VistaPcaPlantilla.this.calcularSemanaEvaluacion());
            }
        });
        SpinnerNumberModel smCh = new SpinnerNumberModel(1, 1, 40, 1);
        this.jspCargaHoraria = new JSpinner(smCh);
        this.jspCargaHoraria.setValue(pca.getCargaHorariaSemanal());
        if (null != pca.getModificaCargaHorariaSemanal() && EstadoEnum.ESTADO_ACTIVO.ordinal() != pca.getModificaCargaHorariaSemanal().shortValue()) {
            this.jspCargaHoraria.setEnabled(false);
        } else {
            this.jspCargaHoraria.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    VistaPcaPlantilla.this.jlTotalPeriodos.setText(VistaPcaPlantilla.this.calcularTotalPeriodos());
                }
            });
        }
        this.jlTotalPeriodos = new JLabel(this.calcularTotalPeriodos());
        this.jlTotalPeriodos.setHorizontalAlignment(0);
        JLabel totalHoras = new JLabel(this.totalSemanas.toString() + " semanas");
        totalHoras.setHorizontalAlignment(0);
        linea2.add(this.jspCargaHoraria);
        linea2.add(this.jspSemanaTrabajo);
        linea2.add(this.jspSemanaEvaluacion);
        linea2.add(totalHoras);
        linea2.add(this.jlTotalPeriodos);
        cuerpo.add(linea2);
        cuerpo.add(Box.createVerticalStrut(10));
        JPanel linea3 = new JPanel();
        linea3.setLayout(new GridLayout(1, 2));
        JPanel linea31 = new JPanel(grid1);
        JPanel linea32 = new JPanel(grid1);
        String labelObjetivosGrado = "OBJETIVOS DEL GRADO/CURSO";
        String labelObjetivosArea = "OBJETIVOS DEL SUBNIVEL";
        String labelDesarrollo = "DESARROLLO DE UNIDADES DE PLANIFICACI\u00d3N";
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)pca.getNemonicoNivelEducativo())) {
            labelObjetivosArea = "OBJETIVOS DE \u00c1MBITOS Y DESARROLLO DE APRENDIZAJE";
            labelDesarrollo = "DESARROLLO DE EXPERIENCIAS DE APRENDIZAJE";
        }
        TitledBorder titulo31 = BorderFactory.createTitledBorder(labelObjetivosArea);
        titulo31.setTitleFont(font3);
        linea31.setBorder(titulo31);
        TitledBorder titulo32 = BorderFactory.createTitledBorder(labelObjetivosGrado);
        titulo32.setTitleFont(font3);
        linea32.setBorder(titulo32);
        this.pnObjetivos = new JEditorPane();
        this.pnObjetivos.setEditable(false);
        this.pnObjetivos.setContentType("text/html");
        this.jepObjetivosGrado = new JEditorPane();
        this.jepObjetivosGrado.setContentType("text/html");
        Util.setMaxCaracteres(this.jepObjetivosGrado, MaximoCaracteres.MAX_5000.getValor());
        linea31.add(Util.obtenerScrollPaneTextos(this.pnObjetivos, dPanelesMitad, 22, 30));
        linea32.add(Util.obtenerScrollPaneTextos(this.jepObjetivosGrado, dPanelesMitad, 22, 30));
        linea3.add(linea31);
        linea3.add(linea32);
        cuerpo.add(linea3);
        cuerpo.add(Box.createVerticalStrut(10));
        JPanel linea4 = new JPanel();
        linea4.setLayout(grid1);
        TitledBorder titulo4 = BorderFactory.createTitledBorder("EJES TRANSVERSALES");
        titulo4.setTitleFont(font3);
        linea4.setBorder(titulo4);
        this.jepEjesTransversales = new JEditorPane();
        this.jepEjesTransversales.setEditable(true);
        this.jepEjesTransversales.setContentType("text/html");
        Util.setMaxCaracteres(this.jepEjesTransversales, MaximoCaracteres.MAX_5000.getValor());
        linea4.add(Util.obtenerScrollPaneTextos(this.jepEjesTransversales, dPanelTextos, 22, 30));
        cuerpo.add(linea4);
        cuerpo.add(Box.createVerticalStrut(10));
        JPanel linea5 = new JPanel();
        linea5.setLayout(grid1);
        TitledBorder titulo5 = BorderFactory.createTitledBorder(labelDesarrollo);
        titulo5.setTitleFont(font3);
        linea5.setBorder(titulo5);
        linea5.add(this.tabUnidades);
        cuerpo.add(linea5);
        cuerpo.add(Box.createVerticalStrut(5));
        JPanel linea11 = new JPanel();
        linea11.setLayout(new GridLayout(2, 2));
        this.bibliografia = new JTextArea();
        this.observaciones = new JTextArea();
        Util.setMaxCaracteres(this.bibliografia, MaximoCaracteres.MAX_2000.getValor());
        Util.setMaxCaracteres(this.observaciones, MaximoCaracteres.MAX_2000.getValor());
        linea11.add(new JLabel("BIBLIOGRAF\u00cdA/WEBGRAF\u00cdA"));
        linea11.add(new JLabel("OBSERVACIONES"));
        linea11.add(Util.obtenerScrollPaneTextos(this.bibliografia, dPanelesMitad, 22, 30));
        linea11.add(Util.obtenerScrollPaneTextos(this.observaciones, dPanelesMitad, 22, 30));
        cuerpo.add(linea11);
        cuerpo.add(Box.createVerticalStrut(20));
        this.btnGuardar = new JButton();
        this.btnGuardar.setText("Guardar");
        this.btnGuardar.setAlignmentX(0.5f);
        this.btnGuardar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jfrParent.setCursor(Cursor.getPredefinedCursor(3));
                VistaPcaPlantilla.this.guardar();
                jfrParent.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JPanel jpnGuardar = new JPanel(new FlowLayout());
        jpnGuardar.add(this.btnGuardar);
        cuerpo.add(jpnGuardar);
        JScrollPane scrollPca = new JScrollPane(cuerpo);
        scrollPca.setHorizontalScrollBarPolicy(31);
        scrollPca.setVerticalScrollBarPolicy(22);
        scrollPca.setViewportBorder(null);
        scrollPca.getViewport().setBorder(null);
        scrollPca.setBorder(null);
        this.add((Component)scrollPca, "Center");
        this.setearComponentes();
        if (EstadoEnum.ESTADO_ACTIVO.getEstado().equals(pca.getEstado())) {
            this.setearModoEdicionDocente();
        }
    }

    private void addBotonTab(UnidadPca u) {
        JButton addTab = new JButton("+");
        addTab.setOpaque(false);
        addTab.setBorder(null);
        addTab.setContentAreaFilled(false);
        addTab.setFocusPainted(false);
        addTab.setFocusable(false);
        addTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String txtUnidades = "unidades";
                if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)VistaPcaPlantilla.this.pca.getNemonicoNivelEducativo())) {
                    txtUnidades = "experiencias";
                }
                if (Constantes.MAXIMO_UNIDADES_PCA == VistaPcaPlantilla.this.tabUnidades.getTabCount() - 1) {
                    JOptionPane.showMessageDialog(null, "Ha llegado al m\u00e1ximo de " + txtUnidades, "Error", 2);
                } else {
                    VistaPcaPlantilla.this.jfrParent.setCursor(Cursor.getPredefinedCursor(3));
                    Component c = VistaPcaPlantilla.this.tabUnidades.getTabComponentAt(VistaPcaPlantilla.this.tabUnidades.getTabCount() - 1);
                    VistaPcaPlantilla.this.addTabUnidad(c);
                    VistaPcaPlantilla.this.jfrParent.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        JPanel pnlAddTab = new JPanel(new GridLayout(1, 1));
        pnlAddTab.setOpaque(false);
        pnlAddTab.add(addTab);
        this.tabUnidades.add("boton", null);
        this.addTabUnidad(pnlAddTab, u);
    }

    private void setearComponentes() {
        this.bibliografia.setText(this.pca.getBibliografia());
        this.observaciones.setText(this.pca.getObservacion());
        this.jepEjesTransversales.setText(this.pca.getEjeTransversal());
        this.jepObjetivosGrado.setText(this.pca.getObjetivoGrado());
        if (null != this.pca.getSemanaTrabajo()) {
            this.jspSemanaTrabajo.setValue(this.pca.getSemanaTrabajo());
        }
        if (null != this.pca.getSemanaEvaluacion()) {
            this.jspSemanaEvaluacion.setText(this.pca.getSemanaEvaluacion().toString());
        }
        this.pca.setListaUnidades(this.unidadPcaDao.obtenerListaUnidadesPca(this.pca.getIdAplicacion()));
        if (null != this.pca.getListaUnidades() && !this.pca.getListaUnidades().isEmpty()) {
            for (int i = 0; i < this.pca.getListaUnidades().size(); ++i) {
                UnidadPca u = this.pca.getListaUnidades().get(i);
                if (i > 0) {
                    Component c = this.tabUnidades.getTabComponentAt(this.tabUnidades.getTabCount() - 1);
                    this.addTabUnidad(c, u);
                } else {
                    this.addBotonTab(u);
                }
                PanelUnidadesPCA p = (PanelUnidadesPCA)this.tabUnidades.getComponentAt(i);
                p.getUnidadPca().setIdAplicacion(u.getIdAplicacion());
                p.getUnidadPca().setId(u.getId());
                p.getUnidadPca().setIdUsuarioCreacion(u.getIdUsuarioCreacion());
                p.getJtfDuracion().setValue(u.getDuracionSemana());
                p.getJepObjetivos().setText(u.getObjetivosEspecificos());
                p.getJepOrientaciones().setText(u.getOrientacionMetodologica());
                p.getJtfTituloUnidad().setText(u.getNombre());
                List<DestrezaPca> listaDestrezasUnidad = this.detalleUnidadPcaDao.obtenerListaDestrezasDetalleUnidadPorIdUnidad(u.getIdAplicacion());
                if (null == listaDestrezasUnidad || listaDestrezasUnidad.isEmpty()) continue;
                if (null == this.pca.getIdDocente()) {
                    ArrayList<DestrezaPcaUtil> listaDestrezasSeleccionadas = new ArrayList<DestrezaPcaUtil>();
                    block1: for (DestrezaPca ds : listaDestrezasUnidad) {
                        for (DestrezaPcaUtil d : p.getListaDestrezas()) {
                            if (!ds.getId().equals(d.getId())) continue;
                            listaDestrezasSeleccionadas.add(d);
                            continue block1;
                        }
                    }
                    p.setListaDestrezasSeleccionadas(listaDestrezasSeleccionadas);
                } else {
                    p.setListaDestrezasSeleccionadas(Util.obtenerDestrezaPcaUtil(listaDestrezasUnidad));
                }
                p.setearPanelDestrezas();
            }
            this.setearObjetivos();
        } else {
            this.addBotonTab(null);
        }
    }

    private void imprimir() {
        JFileChooser file = new JFileChooser();
        if (file.showSaveDialog(this.jfrParent) == 0) {
            String rutaArchivo = file.getSelectedFile().getAbsolutePath() + ".pdf";
            StringBuilder rutaPlantilla = new StringBuilder();
            rutaPlantilla.append(FileUtil.rutaApp());
            rutaPlantilla.append("/config/templates/");
            if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)this.pca.getNemonicoNivelEducativo())) {
                rutaPlantilla.append("formato_pca_pre.docx");
            } else {
                rutaPlantilla.append("formato_pca.docx");
            }
            HashMap<String, Object> mapParametrosArchivo = new HashMap<String, Object>();
            HashMap<String, Object> mapMetadata = new HashMap<String, Object>();
            mapParametrosArchivo.put("nombre_institucion", this.pca.getNombreInstitucion());
            mapParametrosArchivo.put("anio_lectivo", Util.concatena(this.pca.getAnioLectivoInicio(), "-", this.pca.getAnioLectivoFin()));
            mapParametrosArchivo.put("nombre_area", null == this.pca.getNombreArea() ? "" : this.pca.getNombreArea());
            mapParametrosArchivo.put("nombre_asignatura", this.pca.getNombreMateria());
            mapParametrosArchivo.put("nombre_grado", this.pca.getNombreCurso());
            mapParametrosArchivo.put("carta_horaria", this.jspCargaHoraria.getValue().toString() + " horas");
            mapParametrosArchivo.put("semana_trabajo", this.jspSemanaTrabajo.getValue());
            mapParametrosArchivo.put("imprevistos", this.jspSemanaEvaluacion.getText());
            mapParametrosArchivo.put("total_semanas", this.totalSemanas.toString() + " semanas");
            mapParametrosArchivo.put("total_periodos", this.jlTotalPeriodos.getText());
            mapParametrosArchivo.put("objetivos_subnivel", this.getPnObjetivos().getText());
            mapParametrosArchivo.put("objetivos_curso", this.jepObjetivosGrado.getText());
            mapParametrosArchivo.put("ejes_transversales", this.jepEjesTransversales.getText());
            mapParametrosArchivo.put("bibliografia", this.bibliografia.getText());
            mapParametrosArchivo.put("observaciones", this.observaciones.getText());
            mapParametrosArchivo.put("nivel_educativo", this.pca.getNombreNivelEducativo());
            this.cacularTotalDuracionUnidades();
            mapParametrosArchivo.put("unidad", this.listaUnidadImprimir);
            mapMetadata.put("html", new String[]{"objetivos_curso", "ejes_transversales", "objetivos_subnivel", "unidad"});
            mapMetadata.put("unidad", new UnidadPcaDTO());
            if (FileUtil.generarDocumento(rutaPlantilla.toString(), rutaArchivo, mapParametrosArchivo, mapMetadata).booleanValue()) {
                JOptionPane.showMessageDialog(this, "Se genero el archivo pdf correctamente.", "Informaci\u00f3n", 1);
                FileUtil.abrirArchivoDesktop(rutaArchivo);
            } else {
                JOptionPane.showMessageDialog(this, "Lo sentimos no se pudo generar el archivo, por favor intente en unos minutos.", "Informaci\u00f3n", 0);
            }
        }
    }

    private void addTabUnidad(Component c) {
        this.addTabUnidad(c, null);
    }

    private void addTabUnidad(Component c, UnidadPca unidad) {
        this.tabUnidades.remove(this.tabUnidades.getTabCount() - 1);
        if (null == unidad) {
            unidad = new UnidadPca(this.tabUnidades.getTabCount() + 1);
        }
        final PanelUnidadesPCA panelUnidad = new PanelUnidadesPCA(unidad, this.jfrParent, this.pca);
        panelUnidad.jbtEliminarUnidad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String txtUnidad = "Unidad";
                if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)VistaPcaPlantilla.this.pca.getNemonicoNivelEducativo())) {
                    txtUnidad = "Experiencia";
                }
                Integer numeroUnidad = panelUnidad.getUnidadPca().getOrden();
                int input = JOptionPane.showConfirmDialog(null, Util.concatena("\u00bfEst\u00e1 seguro de eliminar la ", txtUnidad, " ", numeroUnidad.toString(), "?"), "Confirmaci\u00f3n", 0);
                if (input == 0) {
                    if (null != panelUnidad.getUnidadPca().getIdAplicacion()) {
                        VistaPcaPlantilla.this.unidadPcaDao.eliminarUnidadPca(panelUnidad.getUnidadPca().getIdAplicacion());
                    }
                    for (int i = numeroUnidad.intValue(); i < VistaPcaPlantilla.this.tabUnidades.getTabCount() - 1; ++i) {
                        VistaPcaPlantilla.this.tabUnidades.setTitleAt(i, Util.concatena(txtUnidad, " ", String.valueOf(i)));
                        PanelUnidadesPCA p = (PanelUnidadesPCA)VistaPcaPlantilla.this.tabUnidades.getComponentAt(i);
                        p.getUnidadPca().setOrden(i);
                        p.setJlbTituloDText();
                    }
                    VistaPcaPlantilla.this.tabUnidades.remove(numeroUnidad - 1);
                    VistaPcaPlantilla.this.tabUnidades.setSelectedIndex(VistaPcaPlantilla.this.tabUnidades.getTabCount() - 2);
                }
            }
        });
        String txtUnidad = "Unidad";
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)this.pca.getNemonicoNivelEducativo())) {
            txtUnidad = "Experiencia";
        }
        this.tabUnidades.add(Util.concatena(txtUnidad, " ", String.valueOf(this.tabUnidades.getTabCount() + 1)), panelUnidad);
        this.tabUnidades.add("boton", null);
        this.tabUnidades.setTabComponentAt(this.tabUnidades.getTabCount() - 1, c);
        this.tabUnidades.setSelectedIndex(this.tabUnidades.getTabCount() - 2);
    }

    private String calcularTotalPeriodos() {
        return String.valueOf((Integer)this.jspCargaHoraria.getValue() * (Integer)this.jspSemanaTrabajo.getValue());
    }

    private String calcularSemanaEvaluacion() {
        return String.valueOf(this.totalSemanas - (Integer)this.jspSemanaTrabajo.getValue());
    }

    private void guardar() {
        String txtUnidades = "unidades";
        if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)this.pca.getNemonicoNivelEducativo())) {
            txtUnidades = "experiencias";
        }
        this.pca.setSemanaEvaluacion(Integer.parseInt(this.jspSemanaEvaluacion.getText()));
        this.pca.setSemanaTrabajo((Integer)this.jspSemanaTrabajo.getValue());
        this.pca.setCargaHorariaSemanal((Integer)this.jspCargaHoraria.getValue());
        if (this.pca.getSemanaTrabajo() + this.pca.getSemanaEvaluacion() != this.totalSemanas) {
            JOptionPane.showMessageDialog(this, "La suma del n\u00famero de semanas de trabajo y evaluaci\u00f3n o imprevistos debe ser igual a " + this.totalSemanas.toString() + ", por favor corregir", "Advertencia", 2);
        } else if (this.cacularTotalDuracionUnidades() > this.pca.getSemanaTrabajo()) {
            JOptionPane.showMessageDialog(this, Util.concatena("La suma de la duraci\u00f3n de las ", txtUnidades, " debe ser igual a ", this.pca.getSemanaTrabajo().toString(), ", por favor corregir"), "Advertencia", 2);
        } else if (MaximoCaracteres.MAX_5000.getValor() < this.jepObjetivosGrado.getText().length()) {
            JOptionPane.showMessageDialog(this, "Ha superado el l\u00edmite de caract\u00e9res para los Objetivos de Grado/Curso, por favor reducir el texto", "Advertencia", 2);
        } else if (MaximoCaracteres.MAX_5000.getValor() < this.jepEjesTransversales.getText().length()) {
            JOptionPane.showMessageDialog(this, "Ha superado el l\u00edmite de caract\u00e9res para los Ejes transversales, por favor reducir el texto", "Advertencia", 2);
        } else if (MaximoCaracteres.MAX_2000.getValor() < this.bibliografia.getText().length()) {
            JOptionPane.showMessageDialog(this, "Ha superado el l\u00edmite de caract\u00e9res para la Bibliograf\u00eda, por favor reducir el texto", "Advertencia", 2);
        } else if (MaximoCaracteres.MAX_2000.getValor() < this.observaciones.getText().length()) {
            JOptionPane.showMessageDialog(this, "Ha superado el l\u00edmite de caract\u00e9res para las Observaciones, por favor reducir el texto", "Advertencia", 2);
        } else {
            int input = JOptionPane.showConfirmDialog(null, "\u00bfEst\u00e1 seguro de guardar los datos?", "Confirmaci\u00f3n", 0);
            if (input == 0) {
                try {
                    this.pca.setTotalPeriodo(this.pca.getCargaHorariaSemanal() * this.pca.getSemanaTrabajo());
                    this.pca.setIdUsuarioCreacion(this.idUsuarioCreacion);
                    this.pca.setObservacion(this.observaciones.getText());
                    this.pca.setBibliografia(this.bibliografia.getText());
                    this.pca.setEjeTransversal(this.jepEjesTransversales.getText());
                    this.pca.setObjetivoGrado(this.jepObjetivosGrado.getText());
                    this.pca.setEditable(EstadoEnum.ESTADO_ACTIVO.getEstado());
                    if (null == this.pca.getEstado() || !EstadoEnum.ESTADO_ACTIVO.getEstado().equals(this.pca.getEstado())) {
                        this.pca.setEstado(EstadoEnum.ESTADO_BORRADOR.getEstado());
                    }
                    this.pcaDao.actualizarPca(this.pca);
                    this.unidadPcaDao.guardarListaUnidadPca(this.pca.getListaUnidades());
                    JOptionPane.showMessageDialog(this, "Se guardaron los datos correctamente.", "Informaci\u00f3n", 1);
                }
                catch (Exception e) {
                    Logger.getLogger(VistaPcaPlantilla.class.getName()).log(Level.SEVERE, null, e);
                    JOptionPane.showMessageDialog(this, "Lo sentimos no se pudieron guardar los datos, por favor intente en unos minutos.", "Error", 0);
                }
            }
        }
    }

    public void enviar(Boolean finalizar) {
        block11: {
            Boolean enviado = false;
            if (finalizar.booleanValue()) {
                String txtUnidades = "unidades";
                if (ArrayUtils.contains((Object[])Constantes.NEMONICOS_PCA_PREPARATORIA, (Object)this.pca.getNemonicoNivelEducativo())) {
                    txtUnidades = "experiencias";
                }
                if (this.cacularTotalDuracionUnidades() > this.pca.getSemanaTrabajo()) {
                    JOptionPane.showMessageDialog(this, Util.concatena("La suma de la duraci\u00f3n de las ", txtUnidades, " debe ser igual a ", this.pca.getSemanaTrabajo().toString(), ", por favor corregir"), "Advertencia", 2);
                    return;
                }
                if (null == this.pca.getSemanaEvaluacion() || null == this.pca.getSemanaTrabajo() || null == this.pca.getBibliografia() || this.pca.getBibliografia().isEmpty() || null == this.pca.getListaUnidades() || this.pca.getListaUnidades().isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Debe completar los datos del PCA para continuar", "Advertencia", 2);
                    return;
                }
                for (UnidadPca u : this.pca.getListaUnidades()) {
                    if (null != u.getNombre() && !u.getNombre().isEmpty() && null != u.getObjetivosEspecificos() && !Util.htmlIsEmpty(u.getObjetivosEspecificos()).booleanValue() && null != u.getOrientacionMetodologica() && !Util.htmlIsEmpty(u.getOrientacionMetodologica()).booleanValue() && null != u.getListaDestrezas() && !u.getListaDestrezas().isEmpty()) continue;
                    JOptionPane.showMessageDialog(this, Util.concatena("Debe completar todos los datos de las ", txtUnidades, " para continuar"), "Advertencia", 2);
                    return;
                }
                try {
                    this.pca.setEstado(EstadoEnum.ESTADO_ACTIVO.getEstado());
                    this.pca.setEditable(EstadoEnum.ESTADO_INACTIVO.getEstado());
                    this.pcaDao.actualizarPca(this.pca);
                    enviado = new SincronizarPca().enviarInformacion(this.pca, Boolean.TRUE);
                    if (enviado.booleanValue()) {
                        this.pcaDao.actualizarPcaDocente(this.pca);
                        JOptionPane.showMessageDialog(this, "El PCA se ha enviado exitosamente", "Informaci\u00f3n", 1);
                        this.jfrParent.regresarPCA();
                        break block11;
                    }
                    this.pca.setEstado(EstadoEnum.ESTADO_BORRADOR.getEstado());
                    this.pca.setEditable(EstadoEnum.ESTADO_ACTIVO.getEstado());
                    this.pcaDao.actualizarPca(this.pca);
                    JOptionPane.showMessageDialog(this, "Lo sentimos no se pudo enviar el PCA, por favor intentar en unos minutos", "Informaci\u00f3n", 1);
                }
                catch (Exception ex) {
                    this.pca.setEstado(EstadoEnum.ESTADO_BORRADOR.getEstado());
                    this.pca.setEditable(EstadoEnum.ESTADO_ACTIVO.getEstado());
                    this.pcaDao.actualizarPca(this.pca);
                    JOptionPane.showMessageDialog(this, "Lo sentimos no se pudo enviar el PCA, por favor intentar en unos minutos", "Informaci\u00f3n", 1);
                    Logger.getLogger(VistaPcaPlantilla.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                enviado = new SincronizarPca().enviarInformacion(this.pca);
                if (enviado.booleanValue()) {
                    this.pca.setEditable(EstadoEnum.ESTADO_INACTIVO.getEstado());
                    this.pcaDao.actualizarPca(this.pca);
                    JOptionPane.showMessageDialog(this, "El PCA se ha enviado exitosamente", "Informaci\u00f3n", 1);
                    this.jfrParent.regresarPCA();
                } else {
                    JOptionPane.showMessageDialog(this, "Lo sentimos no se pudo enviar el PCA, por favor intentar en unos minutos", "Informaci\u00f3n", 1);
                }
            }
        }
    }

    private void setearModoEdicionDocente() {
        for (int i = 0; i < this.tabUnidades.getTabCount() - 1; ++i) {
            PanelUnidadesPCA p = (PanelUnidadesPCA)this.tabUnidades.getComponentAt(i);
            p.jbtEliminarUnidad.setVisible(false);
            p.getJbtEditarT1().setVisible(false);
            p.getJbtEditarT2().setVisible(false);
            p.getJtfTituloUnidad().setEditable(false);
            p.getJtfDuracion().setEnabled(false);
        }
        this.tabUnidades.remove(this.tabUnidades.getTabCount() - 1);
        this.jspSemanaTrabajo.setEnabled(false);
        this.jspSemanaEvaluacion.setEnabled(false);
        this.jspCargaHoraria.setEnabled(false);
    }

    private Integer cacularTotalDuracionUnidades() {
        Integer outTotal = 0;
        this.pca.setListaUnidades(new ArrayList<UnidadPca>());
        this.listaUnidadImprimir = new ArrayList<UnidadPcaDTO>();
        int totalUnidades = this.tabUnidades.getTabCount() - 1;
        if (null != this.pca.getEstado() && EstadoEnum.ESTADO_ACTIVO.getEstado().equals(this.pca.getEstado())) {
            totalUnidades = this.tabUnidades.getTabCount();
        }
        for (int i = 0; i < totalUnidades; ++i) {
            PanelUnidadesPCA p = (PanelUnidadesPCA)this.tabUnidades.getComponentAt(i);
            p.getUnidadPca().setDuracionSemana((Integer)p.getJtfDuracion().getValue());
            p.getUnidadPca().setNombre(p.getJtfTituloUnidad().getText());
            p.getUnidadPca().setListaDestrezas(p.getListaDestrezasSeleccionadas());
            p.getUnidadPca().setObjetivosEspecificos(p.getJepObjetivos().getText());
            p.getUnidadPca().setOrientacionMetodologica(p.getJepOrientaciones().getText());
            p.getUnidadPca().setIdPca(this.pca.getIdAplicacion());
            p.getUnidadPca().setIdUsuarioCreacion(this.idUsuarioCreacion);
            p.getUnidadPca().setEstado(EstadoEnum.ESTADO_ACTIVO.getEstado());
            UnidadPcaDTO uImprimir = new UnidadPcaDTO();
            uImprimir.setDestrezas(p.getJepDestrezas().getText().replace("<br>", "<br/>").replace("<hr>", ""));
            uImprimir.setEvaluacion(p.getJepEvaluacion().getText().replace("<br>", "<br/>").replace("<hr>", ""));
            uImprimir.setOrientacionMetodologica(p.getJepOrientaciones().getText().replace("<br>", "<br/>").replace("<hr>", ""));
            uImprimir.setDuracion(p.getJtfDuracion().getValue().toString());
            uImprimir.setNumeroString(p.getUnidadPca().getOrden().toString());
            uImprimir.setNombre(p.getUnidadPca().getNombre());
            uImprimir.setObjetivosEspecificos(p.getJepObjetivos().getText());
            this.listaUnidadImprimir.add(uImprimir);
            this.pca.getListaUnidades().add(p.getUnidadPca());
            outTotal = outTotal + p.getUnidadPca().getDuracionSemana();
        }
        return outTotal;
    }

    public void setearObjetivos() {
        LinkedHashMap<String, ObjetivoPca> mapObjetivosGrado = new LinkedHashMap<String, ObjetivoPca>();
        for (int i = 0; i < this.tabUnidades.getTabCount() - 1; ++i) {
            PanelUnidadesPCA p = (PanelUnidadesPCA)this.tabUnidades.getComponentAt(i);
            for (DestrezaPcaUtil destreza : p.getListaDestrezasSeleccionadas()) {
                List<ObjetivoPca> listaObjetivos = this.objetivoPcaDao.obtenerListaObjetivoPcaPorIdDestreza(destreza.getId());
                for (ObjetivoPca o : listaObjetivos) {
                    if (mapObjetivosGrado.containsKey(o.getNombre())) continue;
                    if (null == o.getColor()) {
                        int indexColor = destreza.getJepDetalle().getText().indexOf("color=\"");
                        o.setColor(destreza.getJepDetalle().getText().substring(indexColor + 8, indexColor + 14));
                    }
                    mapObjetivosGrado.put(o.getNombre(), o);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html style=\"text-align: justify; text-justify: inter-word;\">");
        for (String nombreObj : mapObjetivosGrado.keySet()) {
            ObjetivoPca o = (ObjetivoPca)mapObjetivosGrado.get(nombreObj);
            sb.append("<p align=\"justify\"><font color=#\"");
            sb.append(o.getColor());
            sb.append("\">");
            sb.append(o.getNombre());
            sb.append("</font>&nbsp;");
            sb.append(o.getDescripcion());
            sb.append("</p>");
        }
        sb.append("</html>");
        this.getPnObjetivos().setText(sb.toString());
    }

    public JEditorPane getPnObjetivos() {
        return this.pnObjetivos;
    }

    public void setPnObjetivos(JEditorPane pnObjetivos) {
        this.pnObjetivos = pnObjetivos;
    }

    public Pca getPca() {
        return this.pca;
    }

    public void setPca(Pca pca) {
        this.pca = pca;
    }

    public JEditorPane getJepEjesTransversales() {
        return this.jepEjesTransversales;
    }

    public void setJepEjesTransversales(JEditorPane jepEjesTransversales) {
        this.jepEjesTransversales = jepEjesTransversales;
    }
}

