/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Enumeradores.EscalaEvaluacionComportamiento;
import Enumeradores.ModeloEnum;
import Modelos.Dao.AsignacionDao;
import Modelos.Dao.AsignacionDaoImpl;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Dao.NotaCualitativaDao;
import Modelos.Dao.NotaCualitativaDaoImpl;
import Modelos.Dao.PeriodoAnioLectivoDao;
import Modelos.Dao.PeriodoAnioLectivoDaoImpl;
import Modelos.Entidades.Calificacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.NotaCualitativa;
import Modelos.Entidades.PeriodoAnioLectivo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.view.JBroTable;
import vo.ComportamientoVO;
import vo.FechasVO;

public class JBroTableDataComportamiento
extends JBroTable {
    private final List<ComportamientoVO> asistenciaEstudiantes;
    private final ModelField[] fields;
    private final Instructor instructor;
    private Calificacion calificacion = null;
    private ComportamientoVO comportamientoVO = new ComportamientoVO();
    private final NotaCualitativaDao notaCualitativaDao = new NotaCualitativaDaoImpl();
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private final AsignacionDao asignacionDao = new AsignacionDaoImpl();
    private final PeriodoAnioLectivoDao periodoAnioLectivoDao = new PeriodoAnioLectivoDaoImpl();
    private BigDecimal notaParcial3 = new BigDecimal(0);
    private Date fechaBloqueop1q1 = null;
    private Date fechaBloqueop1q1Inicio = null;
    private Date fechaBloqueop2q1 = null;
    private Date fechaBloqueop2q1Inicio = null;
    private Date fechaBloqueop3q1 = null;
    private Date fechaBloqueop3q1Inicio = null;
    private Date fechaBloqueop1q2 = null;
    private Date fechaBloqueop1q2Inicio = null;
    private Date fechaBloqueop2q2 = null;
    private Date fechaBloqueop2q2Inicio = null;
    private Date fechaBloqueop3q2 = null;
    private Date fechaBloqueop3q2Inicio = null;
    private Date fechaBloqueoExQ1 = null;
    private Date fechaBloqueoExQ1Inicio = null;
    private Date fechaBloqueoExQ2 = null;
    private Date fechaBloqueoExQ2Inicio = null;
    private Date fechaBloqueoMej = null;
    private Date fechaBloqueoMejInicio = null;
    private Date fechaBloqueoSUP = null;
    private Date fechaBloqueoSUPInicio = null;
    private Date fechaBloqueoSUP2 = null;
    private Date fechaBloqueoSUP2Inicio = null;
    private Date fechaBloqueoRem = null;
    private Date fechaBloqueoRemInicio = null;
    private Date fechaBloqueoGra = null;
    private Date fechaBloqueoGraInicio = null;
    private Date fechaBloqueoQ1Q1 = null;
    private Date fechaBloqueoQ1Q1Inicio = null;
    private Date fechaBloqueoQ2Q2 = null;
    private Date fechaBloqueoQ2Q2Inicio = null;
    private Date fechaBloqueoQTCF = null;
    private Date fechaBloqueoQTCFInicio = null;
    private Date fecha = null;
    private FechasVO fe;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private String fechaSistema = this.format.format(new Date());

    public void obtenerFechasBloqueo() throws ParseException {
        ArrayList<FechasVO> fechasVO = new ArrayList<FechasVO>();
        List<Object> listaFechas = new ArrayList();
        listaFechas = this.periodoAnioLectivoDao.obtenerFechasNotas(this.instructor.getIdRegistroAnioLectivo());
        for (PeriodoAnioLectivo periodoAnioLectivo : listaFechas) {
            String[] fec = periodoAnioLectivo.getFechaInicio().split(" ");
            Date inicio = this.format.parse(fec[0]);
            Date fin = this.format.parse(periodoAnioLectivo.getFechaFin());
            this.fe = new FechasVO();
            this.fe.setNemonico(fec[1]);
            this.fe.setInicio(inicio);
            this.fe.setFin(fin);
            fechasVO.add(this.fe);
        }
        try {
            for (FechasVO fechasVO2 : fechasVO) {
                if (fechasVO2.getNemonico().contains("Q1P1")) {
                    this.fechaBloqueop1q1 = fechasVO2.getFin();
                    this.fechaBloqueop1q1Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q1P2")) {
                    this.fechaBloqueop2q1 = fechasVO2.getFin();
                    this.fechaBloqueop2q1Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q1P3")) {
                    this.fechaBloqueop3q1 = fechasVO2.getFin();
                    this.fechaBloqueop3q1Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q2P1")) {
                    this.fechaBloqueop1q2 = fechasVO2.getFin();
                    this.fechaBloqueop1q2Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q2P2")) {
                    this.fechaBloqueop2q2 = fechasVO2.getFin();
                    this.fechaBloqueop2q2Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q2P3")) {
                    this.fechaBloqueop3q2 = fechasVO2.getFin();
                    this.fechaBloqueop3q2Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q1EX")) {
                    this.fechaBloqueoExQ1 = fechasVO2.getFin();
                    this.fechaBloqueoExQ1Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("Q2EX")) {
                    this.fechaBloqueoExQ2 = fechasVO2.getFin();
                    this.fechaBloqueoExQ2Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QSUP")) {
                    this.fechaBloqueoSUP = fechasVO2.getFin();
                    this.fechaBloqueoSUPInicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QSS")) {
                    this.fechaBloqueoSUP2 = fechasVO2.getFin();
                    this.fechaBloqueoSUP2Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QSR")) {
                    this.fechaBloqueoRem = fechasVO2.getFin();
                    this.fechaBloqueoRemInicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QEM")) {
                    this.fechaBloqueoMej = fechasVO2.getFin();
                    this.fechaBloqueoMejInicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QSG")) {
                    this.fechaBloqueoGra = fechasVO2.getFin();
                    this.fechaBloqueoGraInicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QUIM1")) {
                    this.fechaBloqueoQ1Q1 = fechasVO2.getFin();
                    this.fechaBloqueoQ1Q1Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (fechasVO2.getNemonico().contains("QUIM2")) {
                    this.fechaBloqueoQ2Q2 = fechasVO2.getFin();
                    this.fechaBloqueoQ2Q2Inicio = fechasVO2.getInicio();
                    continue;
                }
                if (!fechasVO2.getNemonico().contains("QTCF")) continue;
                this.fechaBloqueoQTCF = fechasVO2.getFin();
                this.fechaBloqueoQTCFInicio = fechasVO2.getInicio();
            }
            this.fecha = this.format.parse(this.fechaSistema);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JBroTableDataComportamiento(ModelData data, List<ComportamientoVO> asistenciaEstudiantes, ModelField[] fields, Instructor instructor) {
        super(data);
        this.asistenciaEstudiantes = asistenciaEstudiantes;
        this.fields = fields;
        this.instructor = instructor;
        try {
            this.obtenerFechasBloqueo();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public int getRowCount() {
        return this.asistenciaEstudiantes.size();
    }

    public Class<?> getColumnClass(int i) {
        return this.getValueAt(this.getRowCount() - 1, i).getClass();
    }

    public boolean isCellEditable(int fila, int col) {
        boolean isEditable = false;
        boolean columBloquea = false;
        try {
            String opcion;
            switch (opcion = this.fields[col].getIdentifier()) {
                case "Q1P1": {
                    if (this.fecha.compareTo(this.fechaBloqueop1q1Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop1q1) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q1P2": {
                    if (this.fecha.compareTo(this.fechaBloqueop2q1Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop2q1) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q1P3": {
                    if (this.fecha.compareTo(this.fechaBloqueop3q1Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop3q1) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q1EX": {
                    if (this.fecha.compareTo(this.fechaBloqueoExQ1Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueoExQ1) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q2P1": {
                    if (this.fecha.compareTo(this.fechaBloqueop1q2Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop1q2) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q2P2": {
                    if (this.fecha.compareTo(this.fechaBloqueop2q2Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop2q2) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q2P3": {
                    if (this.fecha.compareTo(this.fechaBloqueop3q2Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop3q2) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q2EX": {
                    if (this.fecha.compareTo(this.fechaBloqueoExQ2Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueoExQ2) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q1Q1": {
                    if (this.fecha.compareTo(this.fechaBloqueop2q1Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop2q1) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "Q2Q2": {
                    if (this.fecha.compareTo(this.fechaBloqueop2q2Inicio) >= 0 && this.fecha.compareTo(this.fechaBloqueop2q2) <= 0) {
                        columBloquea = true;
                        break;
                    }
                    columBloquea = false;
                    break;
                }
                case "QTCF": {
                    Object valueq2 = this.getValueAt(fila, col - 1);
                    Object valueq1 = this.getValueAt(fila, col - 4);
                    if (valueq1 == null && valueq2 == null) {
                        columBloquea = false;
                        break;
                    }
                    String q1 = valueq1.toString();
                    String q2 = valueq2.toString();
                    columBloquea = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isEditable || columBloquea;
    }

    public Object getValueAt(int fila, int col) {
        this.comportamientoVO = this.asistenciaEstudiantes.get(fila);
        String valor = null;
        try {
            switch (this.fields[col].getIdentifier()) {
                case "Q1P1": {
                    valor = this.comportamientoVO.getNota1Nota1();
                    break;
                }
                case "Q1P2": {
                    valor = this.comportamientoVO.getNota2Nota1();
                    break;
                }
                case "Q1P3": {
                    valor = this.comportamientoVO.getNota3Nota1();
                    break;
                }
                case "Q1Q1": {
                    valor = this.comportamientoVO.getNotaQuimestreNota1();
                    break;
                }
                case "Q2P1": {
                    valor = this.comportamientoVO.getNota1Nota2();
                    break;
                }
                case "Q2P2": {
                    valor = this.comportamientoVO.getNota2Nota2();
                    break;
                }
                case "Q2P3": {
                    valor = this.comportamientoVO.getNota3Nota2();
                    break;
                }
                case "Q2Q2": {
                    valor = this.comportamientoVO.getNotaQuimestreNota2();
                    break;
                }
                case "QTCF": {
                    valor = this.comportamientoVO.getNotaCualitativa();
                    break;
                }
                default: {
                    valor = "";
                    break;
                }
            }
        }
        catch (Exception e) {
            valor = "";
        }
        return valor;
    }

    public void setValueAt(Object o, int fila, int col) {
        this.comportamientoVO = this.asistenciaEstudiantes.get(fila);
        String f = o.toString();
        if (f.equals("") || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionComportamiento.MUY_SATISFACTORIO.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionComportamiento.SATISFACTORIO.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionComportamiento.POCO_SATISFACTORIO.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionComportamiento.MEJORABLE.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionComportamiento.INSATISFACTORIO.getNemonico())) {
            String opcion;
            boolean updateNota1 = true;
            boolean updateNota2 = true;
            boolean createNota1 = false;
            boolean createNota2 = false;
            NotaCualitativa notaCualitativa1 = null;
            NotaCualitativa notaCualitativa2 = null;
            try {
                this.calificacion = this.calificacionDao.buscarCalificacionPorAsignacionInstructorComportamiento(this.comportamientoVO.getIdAsignacion());
            }
            catch (Exception ex) {
                Logger.getLogger(JBroTableDataComportamiento.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.calificacion.getIdAplicacion() == null) {
                this.calificacion = new Calificacion();
                this.calificacion.setAsignacion(this.asignacionDao.buscarPorId(this.comportamientoVO.getIdAsignacion()));
                this.calificacion.setInstrucutor(this.instructor);
                this.calificacion.setIdEsquema(this.instructor.getIdEsquema());
                this.calificacion.setIdPeriodo(this.instructor.getIdPeriodo());
                this.calificacion.setNombreEsquema("QUIMESTRAL");
                this.calificacion.setTipoPromedio("C");
                this.calificacion.setPromedioAnual(BigDecimal.ZERO);
                this.calificacion.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                this.calificacion.setIdEscenario(this.instructor.getIdEscenario());
                if (this.instructor.getIdEscenarioDiscrecion().equals(0)) {
                    this.calificacion.setIdEscenarioDiscrecion(null);
                } else {
                    this.calificacion.setIdEscenarioDiscrecion(this.instructor.getIdEscenarioDiscrecion());
                }
                this.calificacionDao.guardarCalificacion(this.calificacion);
            }
            try {
                this.calificacion = this.calificacionDao.buscarCalificacionPorAsignacionInstructorComportamiento(this.comportamientoVO.getIdAsignacion());
            }
            catch (Exception ex) {
                Logger.getLogger(JBroTableDataComportamiento.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.calificacion.getIdAplicacion() != null) {
                notaCualitativa1 = this.notaCualitativaDao.obtenerPorCalificacionModelo(this.calificacion.getIdAplicacion(), 2);
                notaCualitativa2 = this.notaCualitativaDao.obtenerPorCalificacionModelo(this.calificacion.getIdAplicacion(), 3);
            }
            if (notaCualitativa1 == null) {
                updateNota1 = false;
                notaCualitativa1 = new NotaCualitativa();
            }
            if (notaCualitativa2 == null) {
                updateNota2 = false;
                notaCualitativa2 = new NotaCualitativa();
            }
            switch (opcion = this.fields[col].getIdentifier()) {
                case "Q1P1": {
                    createNota1 = !f.equals("") || notaCualitativa1.getNota1() != null;
                    notaCualitativa1.setNota1(f.toUpperCase());
                    this.comportamientoVO.setNota1Nota1(f.toUpperCase());
                    break;
                }
                case "Q1P2": {
                    createNota1 = !f.equals("") || notaCualitativa1.getNota2() != null;
                    notaCualitativa1.setNota2(f.toUpperCase());
                    this.comportamientoVO.setNota2Nota1(f.toUpperCase());
                    break;
                }
                case "Q1P3": {
                    createNota1 = !f.equals("") || notaCualitativa1.getNota3() != null;
                    notaCualitativa1.setNota3(f.toUpperCase());
                    this.comportamientoVO.setNota3Nota1(f.toUpperCase());
                    break;
                }
                case "Q1Q1": {
                    createNota1 = !f.equals("") || notaCualitativa1.getNotaQuimestres() != null;
                    notaCualitativa1.setNotaQuimestres(f.toUpperCase());
                    this.comportamientoVO.setNotaQuimestreNota1(f.toUpperCase());
                    break;
                }
                case "Q2P1": {
                    createNota2 = !f.equals("") || notaCualitativa2.getNota1() != null;
                    notaCualitativa2.setNota1(f.toUpperCase());
                    this.comportamientoVO.setNota1Nota2(f.toUpperCase());
                    break;
                }
                case "Q2P2": {
                    createNota2 = !f.equals("") || notaCualitativa2.getNota2() != null;
                    notaCualitativa2.setNota2(f.toUpperCase());
                    this.comportamientoVO.setNota2Nota2(f.toUpperCase());
                    break;
                }
                case "Q2P3": {
                    createNota2 = !f.equals("") || notaCualitativa2.getNota3() != null;
                    notaCualitativa2.setNota3(f.toUpperCase());
                    this.comportamientoVO.setNota3Nota2(f.toUpperCase());
                    break;
                }
                case "Q2Q2": {
                    createNota2 = !f.equals("") || notaCualitativa2.getNotaQuimestres() != null;
                    notaCualitativa2.setNotaQuimestres(f.toUpperCase());
                    this.comportamientoVO.setNotaQuimestreNota2(f.toUpperCase());
                    break;
                }
                case "QTCF": {
                    this.comportamientoVO.setNotaCualitativa(f.toUpperCase());
                    this.calificacion.setNotaAnualCualitativa(f.toUpperCase());
                    break;
                }
            }
            if (createNota1) {
                if (updateNota1) {
                    notaCualitativa1.setIdCalificacion(this.calificacion.getIdAplicacion());
                    notaCualitativa1.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                    notaCualitativa1.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                    this.notaCualitativaDao.actualizarNota(notaCualitativa1);
                } else {
                    notaCualitativa1.setIdCalificacion(this.calificacion.getIdAplicacion());
                    notaCualitativa1.setIdModelo(2);
                    notaCualitativa1.setNombreModelo(ModeloEnum.Q1.getCodigo());
                    notaCualitativa1.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                    notaCualitativa1.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                    this.notaCualitativaDao.guardarNota(notaCualitativa1);
                }
            }
            if (createNota2) {
                if (updateNota2) {
                    notaCualitativa2.setIdCalificacion(this.calificacion.getIdAplicacion());
                    notaCualitativa2.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                    notaCualitativa2.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                    this.notaCualitativaDao.actualizarNota(notaCualitativa2);
                } else {
                    notaCualitativa2.setIdCalificacion(this.calificacion.getIdAplicacion());
                    notaCualitativa2.setIdModelo(3);
                    notaCualitativa2.setNombreModelo(ModeloEnum.Q2.getCodigo());
                    notaCualitativa2.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
                    notaCualitativa2.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                    this.notaCualitativaDao.guardarNota(notaCualitativa2);
                }
            }
            this.calificacion.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
            this.calificacion.setIdUsuarioCreacion(this.instructor.getIdUsuario());
            this.calificacion.setTipoPromedio("C");
            this.calificacionDao.actualizarCualitativa(this.calificacion);
        } else {
            if (!f.equals("")) {
                JOptionPane.showMessageDialog(null, "Escala de Evaluacion.\n\nA - Muy satisfactorio.\nB - Satisfactorio.\nC - Poco satisfactorio.\nD - Mejorable.\nE - Insatisfactorio\n");
            }
            f = "";
        }
        this.updateUI();
    }
}

