/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Enumeradores.EscalaEvaluacionDestreza;
import Enumeradores.ModeloEnum;
import Modelos.Dao.NotaInicialDao;
import Modelos.Dao.NotaInicialDaoImpl;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.NotaInicial;
import java.util.List;
import javax.swing.JOptionPane;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.view.JBroTable;

public class JBroTableDataInicial
extends JBroTable {
    private List<Asignacion> asistenciaEstudiantes;
    private ModelField[] fields;
    private Instructor instructor;
    private NotaInicialDao notaInicialDao = new NotaInicialDaoImpl();

    public JBroTableDataInicial(ModelData data, List<Asignacion> asistenciaEstudiantes, ModelField[] fields, Instructor instructor) {
        super(data);
        this.asistenciaEstudiantes = asistenciaEstudiantes;
        this.fields = fields;
        this.instructor = instructor;
    }

    public int getRowCount() {
        return this.asistenciaEstudiantes.size();
    }

    public Class<?> getColumnClass(int i) {
        return this.getValueAt(this.getRowCount() - 1, i).getClass();
    }

    public boolean isCellEditable(int fila, int col) {
        return true;
    }

    public Object getValueAt(int fila, int col) {
        Asignacion asignacion = this.asistenciaEstudiantes.get(fila);
        String valor = null;
        String[] codigo = this.fields[col].getIdentifier().split("-");
        NotaInicial notaInicial = this.notaInicialDao.obtenerPorDestrezaAsignacion(Integer.valueOf(codigo[0]), asignacion.getId());
        valor = notaInicial == null ? EscalaEvaluacionDestreza.NO_EVUALUADO.getNemonico() : (codigo[1].equals(ModeloEnum.Q1.getCodigo()) ? (notaInicial.getNota1() == null ? EscalaEvaluacionDestreza.NO_EVUALUADO.getNemonico() : notaInicial.getNota1()) : (notaInicial.getNota2() == null ? EscalaEvaluacionDestreza.NO_EVUALUADO.getNemonico() : notaInicial.getNota2()));
        return valor;
    }

    public void setValueAt(Object o, int fila, int col) {
        String f = o.toString();
        if (f.equals("")) {
            f = EscalaEvaluacionDestreza.NO_EVUALUADO.getNemonico();
        }
        if (f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionDestreza.INICIA.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionDestreza.EN_PROCESO.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionDestreza.ADQUIRIDA.getNemonico()) || f.toUpperCase().equalsIgnoreCase(EscalaEvaluacionDestreza.NO_EVUALUADO.getNemonico())) {
            boolean update = true;
            Asignacion asignacion = this.asistenciaEstudiantes.get(fila);
            String[] codigo = this.fields[col].getIdentifier().split("-");
            NotaInicial notaInicial = this.notaInicialDao.obtenerPorDestrezaAsignacion(Integer.valueOf(codigo[0]), asignacion.getId());
            if (notaInicial == null) {
                update = false;
                notaInicial = new NotaInicial();
            }
            notaInicial.setIdDestreza(Integer.valueOf(codigo[0]));
            notaInicial.setIdAsignacion(asignacion.getId());
            notaInicial.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
            notaInicial.setIdUsuarioCreacion(this.instructor.getIdUsuario());
            if (codigo[1].equals(ModeloEnum.Q1.getCodigo())) {
                notaInicial.setNota1(f.toUpperCase());
            } else {
                notaInicial.setNota2(f.toUpperCase());
            }
            if (update) {
                this.notaInicialDao.actualizarNota(notaInicial);
            } else {
                this.notaInicialDao.guardarNota(notaInicial);
            }
        } else {
            if (!f.equals("")) {
                JOptionPane.showMessageDialog(null, "Escala de Evaluaci\u00f3n.\n\nI - Inicio.\nEP - En proceso.\nA - Adquirida.\nNE - No evaluado.\n");
            }
            f = "";
        }
    }
}

