/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Formatos.FormatoTablaFija;
import Formatos.FormatoTablaRecomendaciones;
import Modelos.Dao.ModeloDao;
import Modelos.Dao.ModeloDaoImpl;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.Modelo;
import Vistas.PanelObservacion;
import Vistas.model.EditaCeldaTablaRecomendacion;
import Vistas.model.JBroTableDataRecomendacion;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.model.ModelRow;
import org.quinto.swing.table.view.JBroTable;
import vo.ComportamientoVO;

public class RecomendacionTableJbroModel
extends JFrame {
    int nombreMasLargo;
    JBroTable tablaFija;
    JBroTable tablaNotas;
    JScrollPane scroll;
    PanelObservacion panelObservacion = new PanelObservacion();
    ModeloDao modeloDao = new ModeloDaoImpl();

    public RecomendacionTableJbroModel(List<ComportamientoVO> listaCalificaciones, Instructor instructor) {
        IModelFieldGroup[] cabeceraNombres = new IModelFieldGroup[]{new ModelFieldGroup("estudiantes", "LISTADO").withChild((IModelFieldGroup)new ModelField("nombres", "ESTUDIANTES").withRowspan(3))};
        ModelField[] fieldsNombres = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNombres);
        ModelRow[] rowsNombres = new ModelRow[listaCalificaciones.size()];
        for (int i = 0; i < listaCalificaciones.size(); ++i) {
            int inicialNombreMasLargo;
            rowsNombres[i] = new ModelRow(fieldsNombres.length);
            ComportamientoVO estudiante = listaCalificaciones.get(i);
            int n = inicialNombreMasLargo = estudiante.getNombreApellidoEstudiante() != null ? estudiante.getNombreApellidoEstudiante().length() : 0;
            if (inicialNombreMasLargo > this.nombreMasLargo) {
                this.nombreMasLargo = inicialNombreMasLargo;
            }
            for (int j = 0; j < fieldsNombres.length; ++j) {
                rowsNombres[i].setValue(j, (Object)estudiante.getNombreApellidoEstudiante());
            }
        }
        ModelData dataNombres = new ModelData(cabeceraNombres);
        dataNombres.setRows(rowsNombres);
        this.tablaFija = new JBroTable(dataNombres){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                RecomendacionTableJbroModel.this.checkSelection(true);
            }
        };
        this.tablaFija.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaFija(this.tablaFija, this.nombreMasLargo));
        ModelFieldGroup agrupacion = new ModelFieldGroup("_head", "MODELO QUIMESTRAL");
        List<Modelo> listaEncabezado = this.modeloDao.listarPorIdPadre(1);
        for (Modelo quim : listaEncabezado) {
            if (quim.getCualitativa() != 1) continue;
            List<Modelo> listaSub = this.modeloDao.listarPorIdPadre(quim.getId());
            if (listaSub.size() > 0) {
                ModelFieldGroup agrupacionQuimestre = new ModelFieldGroup(quim.getNemonicoElemento(), "<html><div align='center'>" + quim.getNombreElemento().toUpperCase() + "</div></html>");
                for (Modelo sub : listaSub) {
                    if (sub.getCualitativa() != 1 || sub.getNombreElemento().equalsIgnoreCase("p3")) continue;
                    agrupacionQuimestre.withChild((IModelFieldGroup)new ModelField(sub.getNemonicoElemento(), "<html><div align='center'>" + sub.getNombreElemento() + "</div></html>").withDefaultWidth(Integer.valueOf(80)));
                }
                agrupacion.withChild((IModelFieldGroup)agrupacionQuimestre);
                continue;
            }
            agrupacion.withChild((IModelFieldGroup)new ModelField(quim.getNemonicoElemento(), "<html><div align='center'>" + quim.getNombreElemento().toUpperCase() + "</div></html>").withRowspan(3).withDefaultWidth(Integer.valueOf(80)));
        }
        IModelFieldGroup[] cabeceraNotas = new IModelFieldGroup[]{agrupacion};
        ModelField[] fields = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNotas);
        ModelRow[] rowsNotas = new ModelRow[listaCalificaciones.size()];
        ModelData dataNotas = new ModelData(cabeceraNotas);
        dataNotas.setRows(rowsNotas);
        this.tablaNotas = new JBroTableDataRecomendacion(dataNotas, listaCalificaciones, fields, instructor);
        for (int i = 0; i < this.tablaNotas.getColumnCount(); ++i) {
            this.tablaNotas.getColumnModel().getColumn(i).setCellEditor(new EditaCeldaTablaRecomendacion(listaCalificaciones, fields, instructor));
        }
        this.tablaNotas.getTableHeader().setReorderingAllowed(false);
        this.tablaNotas.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaRecomendaciones(this.tablaNotas));
        this.tablaFija.setAutoResizeMode(0);
        this.tablaNotas.setAutoResizeMode(0);
        this.tablaFija.setSelectionMode(0);
        this.tablaNotas.setSelectionMode(0);
        this.scroll = new JScrollPane((Component)this.tablaNotas);
        JViewport viewport = new JViewport();
        viewport.setView((Component)this.tablaFija);
        viewport.setPreferredSize(this.tablaFija.getPreferredSize());
        this.scroll.setRowHeaderView(viewport);
        this.scroll.setCorner("UPPER_LEFT_CORNER", (Component)this.tablaFija.getTableHeader());
    }

    private void checkSelection(boolean isFixedTable) {
        int fixedSelectedIndex = this.tablaFija.getSelectedRow();
        int selectedIndex = this.tablaNotas.getSelectedRow();
        int selectedCol = this.tablaNotas.getSelectedColumn();
        if (fixedSelectedIndex != selectedIndex) {
            if (isFixedTable) {
                this.tablaNotas.setRowSelectionInterval(fixedSelectedIndex, fixedSelectedIndex);
            } else {
                this.tablaFija.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    public void poputTabla() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem1 = new JMenuItem("Registrar Observaci\u00f3n Supletorio", new ImageIcon(this.getClass().getResource("/Imagenes/book.png")));
        JMenuItem menuItem2 = new JMenuItem("Registrar Nota Ex\u00e1men Mejoramiento", new ImageIcon(this.getClass().getResource("/Imagenes/calculo.png")));
        menuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UIManager um = new UIManager();
                UIManager.put("OptionPane.background", Color.blue);
                JTextArea textArea = new JTextArea(6, 35);
                JOptionPane.showMessageDialog(null, new JScrollPane(textArea), "Ingresar una observaci\u00f3n del Examen", 2);
                String nota = textArea.getText();
            }
        });
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UIManager um = new UIManager();
                UIManager.put("OptionPane.background", 1);
                JTextArea textArea = new JTextArea(6, 35);
                JOptionPane.showMessageDialog(null, new JScrollPane(textArea), "Ingresar una observaci\u00f3n del Examen", 2);
                String nota = textArea.getText();
            }
        });
        popupMenu.add(menuItem1);
        popupMenu.add(menuItem2);
        this.tablaNotas.setComponentPopupMenu(popupMenu);
        this.tablaFija.setComponentPopupMenu(popupMenu);
    }

    public int getNombreMasLargo() {
        return this.nombreMasLargo;
    }

    public void setNombreMasLargo(int nombreMasLargo) {
        this.nombreMasLargo = nombreMasLargo;
    }

    public JBroTable getTablaFija() {
        return this.tablaFija;
    }

    public void setTablaFija(JBroTable tablaFija) {
        this.tablaFija = tablaFija;
    }

    public JBroTable getTablaNotas() {
        return this.tablaNotas;
    }

    public void setTablaNotas(JBroTable tablaNotas) {
        this.tablaNotas = tablaNotas;
    }

    public JScrollPane getScroll() {
        return this.scroll;
    }

    public void setScroll(JScrollPane scroll) {
        this.scroll = scroll;
    }
}

