/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.AsignacionDaoImpl;
import Modelos.Dao.AsistenciaBachilleratoDao;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.AsistenciaBachillerato;
import Servicios.ConexionSQLite;
import Util.Constantes;
import Util.DiasSemanaHora;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class AsistenciaBachilleratoDaoImpl
extends ConexionSQLite
implements AsistenciaBachilleratoDao {
    private AsignacionDaoImpl asignacionDaoImpl = new AsignacionDaoImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaAsistencia(List<AsistenciaBachillerato> listaAsistencia) throws Exception {
        if (null != listaAsistencia && !listaAsistencia.isEmpty()) {
            try {
                String sql = " INSERT INTO asistencia(id_asignacion, id_horario,asistencia,reg_anio_inicio, estado,id_usuario_creacion,id,justificada,observacion_justificacion,fecha )  values(?,?,?,?,?,?,?,?,?,? ) ";
                this.Conectar();
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (AsistenciaBachillerato asistencia : listaAsistencia) {
                    if (null == asistencia) continue;
                    ps.setInt(1, asistencia.getIdAsignacion());
                    ps.setInt(2, asistencia.getIdHorario());
                    ps.setBoolean(3, asistencia.getAsistencia());
                    ps.setString(4, asistencia.getRegAnioInicio());
                    ps.setString(5, asistencia.getEstado());
                    ps.setInt(6, asistencia.getIdUsuarioCreacion());
                    ps.setObject(7, (Object)asistencia.getId(), 4);
                    ps.setObject(8, (Object)asistencia.getJustificada(), 16);
                    ps.setString(9, asistencia.getObservacionJustificacion());
                    ps.setString(10, asistencia.getFecha());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaBachillerato> buscarPorParaleloRangoFechas(Integer codigoParalelo, String fechaInicial, String fechaFinal) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaBachillerato.class);
        List<AsistenciaBachillerato> asistencia = new ArrayList<AsistenciaBachillerato>();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, at.estado as estado, strftime('%d-%m-%Y %H:%M:%S', at.fecha / 1000, 'unixepoch') as fecha, at.codigo_error as codigoError, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia at WHERE a.id_paralelo = ? and a.id = at.id_asignacion and at.fecha BETWEEN ? AND ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo, fechaInicial, fechaFinal});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarAsistencia(AsistenciaBachillerato asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO asistencia(id_asignacion, id_horario,asistencia,reg_anio_inicio, id_usuario_creacion, estado,justificada,fecha )  values(?,?,?,?,?,?,?,? )";
        try {
            run.update(conn, sql, new Object[]{asistencia.getIdAsignacion(), asistencia.getIdHorario(), asistencia.getAsistencia(), asistencia.getRegAnioInicio(), asistencia.getIdUsuarioCreacion(), asistencia.getEstado(), asistencia.getJustificada(), asistencia.getFecha()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarAsistencia(AsistenciaBachillerato asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE asistencia set id_asignacion = ?, id_horario = ?, asistencia = ?, reg_anio_inicio = ?, fecha = ?, id= ?, id_usuario_creacion= ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{asistencia.getIdAsignacion(), asistencia.getIdHorario(), asistencia.getAsistencia(), asistencia.getRegAnioInicio(), asistencia.getFecha(), asistencia.getId(), asistencia.getIdUsuarioCreacion(), asistencia.getCodigoError(), asistencia.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public List<AsistenciaBachillerato> inicializarAsistenciaDeParalelo(Integer codigoParalelo, Date fechaInicial, Date fechaFinal, List<DiasSemanaHora> dias) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        ArrayList<AsistenciaBachillerato> asistenciaParaleloInicial = new ArrayList<AsistenciaBachillerato>();
        List<Asignacion> estudiantesParalelo = this.asignacionDaoImpl.buscarPorParalelo(codigoParalelo);
        for (Asignacion estudiante : estudiantesParalelo) {
            for (DiasSemanaHora item : dias) {
                if (item.isFinDeSemana()) continue;
                AsistenciaBachillerato asistenciaGuardada = this.buscarAsistenciaEstudiantePorDiaAsignacion(estudiante.getId(), formatter.format(item.getDia()));
                if (asistenciaGuardada != null) {
                    asistenciaParaleloInicial.add(asistenciaGuardada);
                    continue;
                }
                AsistenciaBachillerato nuevaAsistencia = new AsistenciaBachillerato();
                nuevaAsistencia.setNombresApellidosEstudiante(estudiante.getNombreApellidoEstudiante());
                nuevaAsistencia.setIdAsignacion(estudiante.getId());
                nuevaAsistencia.setIdEstudiante(estudiante.getIdEstudiante());
                nuevaAsistencia.setAsistencia(Constantes.ASISTIO_BOOLEANO);
                nuevaAsistencia.setJustificada(Constantes.ASISTIO_BOOLEANO);
                nuevaAsistencia.setFecha(formatter.format(item.getDia()));
                nuevaAsistencia.setEstado(String.valueOf(1));
                this.guardarAsistencia(nuevaAsistencia);
                asistenciaParaleloInicial.add(this.buscarUltimaAsistenciaIngresada());
            }
        }
        return asistenciaParaleloInicial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsistenciaBachillerato buscarAsistenciaEstudiantePorDiaAsignacion(Integer codigoAsignacion, String fechaAsistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AsistenciaBachillerato.class);
        AsistenciaBachillerato asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (AsistenciaBachillerato)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia at WHERE  at.id_asignacion = ? and at.fecha=? and a.id = at.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoAsignacion, fechaAsistencia});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsistenciaBachillerato buscarUltimaAsistenciaIngresada() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AsistenciaBachillerato.class);
        AsistenciaBachillerato asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (AsistenciaBachillerato)run.query(conn, "SELECT at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, strftime('%d-%m-%Y %H:%M:%S', at.fecha / 1000, 'unixepoch') as fecha, at.estado as estado, a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.codigo_error as codigoError, a.id_estudiante as idEstudiante  FROM asignacion a, asistencia at WHERE  at.id_aplicacion = (SELECT max(id_aplicacion) from asistencia)  and a.id = at.id_asignacion  order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asignacion> buscarAsistenciaPorParalelo(Integer codigoParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Asignacion.class);
        List<Asignacion> asignacion = new ArrayList<Asignacion>();
        try {
            asignacion = (List)run.query(conn, "SELECT a.id as id, a.id_estudiante as idEstudiante, a.nombre_apellido_estudiante as nombreApellidoEstudiante, a.identificacion_estudiante as identificacionEstudiante  FROM asignacion a WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asignacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsistenciaBachillerato buscarAsistenciaEstudiantePorHorarioDiaAsignacion(Integer codigoAsignacion, String fechaAsistencia, Integer horario) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AsistenciaBachillerato.class);
        AsistenciaBachillerato asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (AsistenciaBachillerato)run.query(conn, "SELECT at.id as id, a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, a.id_estudiante as idEstudiante, at.id_aplicacion as idAplicacion, at.id_usuario_creacion as idUsuarioCreacion, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, asistencia at WHERE  at.id_asignacion = ? and at.fecha=? and at.id_horario=? and a.id = at.id_asignacion ", (ResultSetHandler)handler, new Object[]{codigoAsignacion, fechaAsistencia, horario});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsistenciaBachillerato buscarInasistenciaJustificadaEstudiantePorHorarioDiaAsignacion(Integer codigoAsignacion, String fechaAsistencia, Integer horario) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(AsistenciaBachillerato.class);
        AsistenciaBachillerato asistenciaEstudiante = null;
        try {
            asistenciaEstudiante = (AsistenciaBachillerato)run.query(conn, "SELECT at.id as id, a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, a.id_estudiante as idEstudiante, at.id_aplicacion as idAplicacion, at.id_usuario_creacion as idUsuarioCreacion, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, asistencia at WHERE  at.id_asignacion = ? and at.fecha=? and at.id_horario=? and a.id = at.id_asignacion and at.justificada=1 ", (ResultSetHandler)handler, new Object[]{codigoAsignacion, fechaAsistencia, horario});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistenciaEstudiante;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaBachillerato> buscarAsistenciaEstudiantesPorParalelo(Integer codigoParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaBachillerato.class);
        List<AsistenciaBachillerato> asistencia = new ArrayList<AsistenciaBachillerato>();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, a.id_estudiante as idEstudiante, at.id_aplicacion as idAplicacion, at.reg_anio_inicio as regAnioInicio, at.observacion_justificacion as observacionJustificacion, at.id_usuario_creacion as idUsuarioCreacion, at.id  FROM asignacion a, asistencia at WHERE a.id_paralelo = ? and a.id = at.id_asignacion order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarAsistenciaSincronizacion(AsistenciaBachillerato asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE asistencia set id= ?, codigo_error = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{asistencia.getId(), asistencia.getCodigoError(), asistencia.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asignacion> buscarInasistenciaPorParalelo(Integer codigoParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Asignacion.class);
        List<Asignacion> asignacion = new ArrayList<Asignacion>();
        try {
            asignacion = (List)run.query(conn, "SELECT distinct(a.id) as id, a.id_estudiante as idEstudiante, a.nombre_apellido_estudiante as nombreApellidoEstudiante, a.identificacion_estudiante as identificacionEstudiante FROM asignacion a join asistencia i on i.id_asignacion=a.id and i.asistencia=0 WHERE a.id_paralelo = ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asignacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asignacion> buscarInasistenciaPorParaleloAsignacion(Integer codigoParalelo, Integer codigoAsignacion, Integer codigoInstructor) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Asignacion.class);
        List<Asignacion> asignacion = new ArrayList<Asignacion>();
        try {
            asignacion = (List)run.query(conn, "SELECT a.id as id, a.id_estudiante as idEstudiante, a.nombre_apellido_estudiante as nombreApellidoEstudiante, a.identificacion_estudiante as identificacionEstudiante FROM asignacion a join asistencia i on i.id_asignacion=a.id and i.asistencia=0 join horario h on i.id_horario=h.id WHERE a.id_paralelo = ? and a.id = ? and h.id_instructor=? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo, codigoAsignacion, codigoInstructor});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asignacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asignacion> buscarJustificacionPorParaleloAsignacion(Integer codigoParalelo, Integer codigoAsignacion, Integer codigoInstructor) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Asignacion.class);
        List<Asignacion> asignacion = new ArrayList<Asignacion>();
        try {
            asignacion = (List)run.query(conn, "SELECT a.id as id, a.id_estudiante as idEstudiante, a.nombre_apellido_estudiante as nombreApellidoEstudiante, a.identificacion_estudiante as identificacionEstudiante FROM asignacion a join asistencia i on i.id_asignacion=a.id and i.justificada=1 join horario h on i.id_horario=h.id WHERE a.id_paralelo = ? and a.id = ?  and h.id_instructor=? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo, codigoAsignacion, codigoInstructor});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asignacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asignacion> buscarInasistenciaEGBPorParalelo(Integer codigoParalelo) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(Asignacion.class);
        List<Asignacion> asignacion = new ArrayList<Asignacion>();
        try {
            asignacion = (List)run.query(conn, "SELECT DISTINCT(a.id) as id, a.id_estudiante as idEstudiante, a.nombre_apellido_estudiante as nombreApellidoEstudiante, a.identificacion_estudiante as identificacionEstudiante FROM asignacion a INNER JOIN asistencia_educacion_basica e on a.id=e.id_asignacion where (e.dia_1=0 OR e.dia_2=0 or e.dia_3=0 or e.dia_4=0 or e.dia_5=0 or e.dia_6=0 or e.dia_7=0 or e.dia_8=0 or e.dia_9=0 or e.dia_10=0 or e.dia_11=0 or e.dia_12=0 or e.dia_13=0 or e.dia_14=0 or e.dia_15=0 or e.dia_16=0 or e.dia_17=0 or e.dia_18=0 or e.dia_19=0 or e.dia_21=0 or e.dia_22=0 or e.dia_23=0 or e.dia_24=0 or e.dia_25=0 or e.dia_26=0 or e.dia_27=0 or e.dia_28=0 or e.dia_29=0 or e.dia_30=0 or e.dia_31=0) and a.id_paralelo = ? order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler, new Object[]{codigoParalelo});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asignacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarInasistencia(AsistenciaBachillerato asistencia) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE asistencia set justificada = ?, observacion_justificacion = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{asistencia.getJustificada(), asistencia.getObservacionJustificacion(), asistencia.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsistenciaBachillerato> buscarTodo() {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(AsistenciaBachillerato.class);
        ArrayList<AsistenciaBachillerato> asistencia = new ArrayList();
        try {
            asistencia = (List)run.query(conn, "SELECT a.nombre_apellido_estudiante as nombresApellidosEstudiante, at.id_asignacion as idAsignacion, at.id_horario as idHorario, at.asistencia as asistencia,at.justificada as justificada, at.estado as estado, at.fecha as fecha, at.codigo_error as codigoError, a.id_estudiante as idEstudiante, at.id_aplicacion as idAplicacion, at.reg_anio_inicio as regAnioInicio, at.id_usuario_creacion as idUsuarioCreacion, at.id, at.observacion_justificacion as observacionJustificacion  FROM asignacion a, asistencia at WHERE a.id = at.id_asignacion order by a.nombre_apellido_estudiante asc ", (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return asistencia;
    }
}

