/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Entidades.Calificacion;
import Modelos.Entidades.Instructor;
import Vistas.FuncionesAuxiliar;
import Vistas.model.CalificacionTableJbroModel;
import Vistas.model.ComportamientoTableJbroModel;
import Vistas.model.RecomendacionTableJbroModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import vo.CalificacionVO;
import vo.ComportamientoVO;
import vo.InfoUsuarioVO;

public class VistaNota
extends JPanel {
    private Integer codigoParaleloSeleccionado;
    private Integer idEscenarioSeleccionado;
    private Integer idEscenarioDiscrecionSeleccionado;
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private Panel panel1;
    private JPanel panelTabla;

    public VistaNota() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.panelTabla.setLayout(new BorderLayout());
        this.add((Component)this.panelTabla, "Center");
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.panelTabla = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTabla, "Center");
    }

    public void mostrarCalificacion(List<CalificacionVO> listaCalificaciones, InfoUsuarioVO infoUsuario, Instructor instructor) {
        this.codigoParaleloSeleccionado = instructor.getIdParalelo();
        this.idEscenarioSeleccionado = instructor.getIdEscenario();
        this.idEscenarioDiscrecionSeleccionado = instructor.getIdEscenarioDiscrecion();
        if (listaCalificaciones.isEmpty()) {
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("El paralelo no presenta estudiantes. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece el paralelo.");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelTabla.add((Component)panelAuxiliar, "First");
        } else {
            if (instructor.getNombreMateria().equals("COMPORTAMIENTO") || instructor.getNemonicoMateria() != null && instructor.getNemonicoMateria().equals("PE")) {
                List<ComportamientoVO> listaComportamiento = new ArrayList<ComportamientoVO>();
                try {
                    if (instructor.getNombreMateria().equals("COMPORTAMIENTO")) {
                        listaComportamiento = this.calificacionDao.recuperarCalificacionesCualitativasComportamiento(instructor.getIdParalelo());
                        if (listaComportamiento.size() > 0) {
                            List<Object> listaCalificacionesComportamiento = new ArrayList();
                            listaCalificacionesComportamiento = this.calificacionDao.buscarSoloCalificacionesComportamiento(instructor.getIdParalelo());
                            Calificacion primeraCalificacion = (Calificacion)listaCalificacionesComportamiento.get(0);
                            System.out.println(" escenario " + primeraCalificacion.getIdEscenario());
                            System.out.println(" escenarioDiscrecion " + primeraCalificacion.getIdEscenarioDiscrecion());
                            this.idEscenarioSeleccionado = primeraCalificacion.getIdEscenario();
                            this.idEscenarioDiscrecionSeleccionado = primeraCalificacion.getIdEscenarioDiscrecion();
                        }
                    } else {
                        listaComportamiento = this.calificacionDao.recuperarCalificacionesCualitativas(instructor.getIdEscenario(), instructor.getIdParalelo());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.panelTabla.add((Component)new ComportamientoTableJbroModel(listaComportamiento, instructor).getScroll(), "Center");
            } else if (instructor.getNombreMateria().equals("RECOMENDACIONES")) {
                ArrayList<ComportamientoVO> listaRecomendaciones = new ArrayList();
                try {
                    listaRecomendaciones = this.calificacionDao.recuperarRecomendaciones(instructor.getIdEscenario(), instructor.getIdParalelo());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.panelTabla.add((Component)new RecomendacionTableJbroModel(listaRecomendaciones, instructor).getScroll(), "Center");
            } else {
                this.panelTabla.add((Component)new CalificacionTableJbroModel(listaCalificaciones, instructor).getScroll(), "Center");
            }
            this.panelTabla.updateUI();
            this.updateUI();
        }
    }

    public Integer getCodigoParaleloSeleccionado() {
        return this.codigoParaleloSeleccionado;
    }

    public void setCodigoParaleloSeleccionado(Integer codigoParaleloSeleccionado) {
        this.codigoParaleloSeleccionado = codigoParaleloSeleccionado;
    }

    public Integer getIdEscenarioSeleccionado() {
        return this.idEscenarioSeleccionado;
    }

    public void setIdEscenarioSeleccionado(Integer idEscenarioSeleccionado) {
        this.idEscenarioSeleccionado = idEscenarioSeleccionado;
    }

    public Integer getIdEscenarioDiscrecionSeleccionado() {
        return this.idEscenarioDiscrecionSeleccionado;
    }

    public void setIdEscenarioDiscrecionSeleccionado(Integer idEscenarioDiscrecionSeleccionado) {
        this.idEscenarioDiscrecionSeleccionado = idEscenarioDiscrecionSeleccionado;
    }
}

