/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Formatos.FormatoTablaFija;
import Formatos.FormatoTablaInicial;
import Modelos.Dao.AmbitoDestrezaDao;
import Modelos.Dao.AmbitoDestrezaDaoImpl;
import Modelos.Dao.ModeloDao;
import Modelos.Dao.ModeloDaoImpl;
import Modelos.Entidades.AmbitoDestreza;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.Modelo;
import Vistas.model.EditaCeldaTablaInicial;
import Vistas.model.ExcelAdapterCualitativa;
import Vistas.model.JBroTableDataInicial;
import java.awt.Component;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.model.ModelRow;
import org.quinto.swing.table.view.JBroTable;

public class CalificacionInicialTableJbroModel
extends JFrame {
    int nombreMasLargo;
    JBroTable tablaFija;
    JBroTable tablaNotas;
    JScrollPane scroll;
    private final AmbitoDestrezaDao ambitoDestrezaDao = new AmbitoDestrezaDaoImpl();
    private List<AmbitoDestreza> destrezas;
    private Instructor instructor = new Instructor();
    ModeloDao modeloDao = new ModeloDaoImpl();

    public CalificacionInicialTableJbroModel(Integer codigoParalelo, List<Asignacion> estudiantes, AmbitoDestreza ambito, Instructor instructor) {
        this.instructor = instructor;
        IModelFieldGroup[] cabeceraNombres = new IModelFieldGroup[]{new ModelFieldGroup("estudiantes", "LISTADO").withChild((IModelFieldGroup)new ModelField("nombres", "").withRowspan(70))};
        ModelField[] fieldsNombres = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNombres);
        ModelRow[] rowsNombres = new ModelRow[estudiantes.size()];
        for (int i = 0; i < estudiantes.size(); ++i) {
            int inicialNombreMasLargo;
            rowsNombres[i] = new ModelRow(fieldsNombres.length);
            Asignacion estudiante = estudiantes.get(i);
            int n = inicialNombreMasLargo = estudiante.getNombreApellidoEstudiante() != null ? estudiante.getNombreApellidoEstudiante().length() : 0;
            if (inicialNombreMasLargo > this.nombreMasLargo) {
                this.nombreMasLargo = inicialNombreMasLargo;
            }
            for (int j = 0; j < fieldsNombres.length; ++j) {
                rowsNombres[i].setValue(j, (Object)estudiante.getNombreApellidoEstudiante());
            }
        }
        ModelData dataNombres = new ModelData(cabeceraNombres);
        dataNombres.setRows(rowsNombres);
        this.tablaFija = new JBroTable(dataNombres){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                CalificacionInicialTableJbroModel.this.checkSelection(true);
            }
        };
        this.tablaFija.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaFija(this.tablaFija, this.nombreMasLargo));
        ModelFieldGroup agrupacion = new ModelFieldGroup(ambito.getNemonicoGrado() + "_head", ambito.getDescripcion().toUpperCase());
        List<Modelo> listaEncabezado = this.modeloDao.listarPorIdPadre(1);
        for (Modelo quim : listaEncabezado) {
            if (!quim.getNemonicoElemento().equals("QUIM1") && !quim.getNemonicoElemento().equals("QUIM2")) continue;
            ModelFieldGroup agrupacionQuimestre = new ModelFieldGroup(quim.getNemonicoElemento(), "<html><div align='center'>" + quim.getNombreElemento().toUpperCase() + "</div></html>");
            this.destrezas = this.ambitoDestrezaDao.listarAmbitosDestrezasPorIdPadreJornada(ambito.getIdAplicacion(), ambito.getIdJornada());
            for (AmbitoDestreza item : this.destrezas) {
                agrupacionQuimestre.withChild((IModelFieldGroup)new ModelField(item.getIdAplicacion().toString() + "-" + quim.getNemonicoElemento(), "<html><div style='position:absolute;right:30px;width:100px;'>" + item.getDescripcion() + "</div></html>").withDefaultWidth(Integer.valueOf(150)));
            }
            agrupacion.withChild((IModelFieldGroup)agrupacionQuimestre);
        }
        IModelFieldGroup[] cabeceraNotas = new IModelFieldGroup[]{agrupacion};
        ModelField[] fields = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNotas);
        ModelRow[] rowsNotas = new ModelRow[estudiantes.size()];
        ModelData dataNotas = new ModelData(cabeceraNotas);
        dataNotas.setRows(rowsNotas);
        this.tablaNotas = new JBroTableDataInicial(dataNotas, estudiantes, fields, instructor);
        for (int i = 0; i < this.tablaNotas.getColumnCount(); ++i) {
            this.tablaNotas.getColumnModel().getColumn(i).setCellEditor(new EditaCeldaTablaInicial());
        }
        ExcelAdapterCualitativa myAd = new ExcelAdapterCualitativa((JTable)this.tablaNotas, fields);
        this.tablaNotas.getTableHeader().setReorderingAllowed(false);
        this.tablaNotas.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaInicial(this.tablaNotas));
        this.tablaFija.setAutoResizeMode(0);
        this.tablaNotas.setAutoResizeMode(0);
        this.tablaFija.setSelectionMode(0);
        this.tablaNotas.setSelectionMode(0);
        this.scroll = new JScrollPane((Component)this.tablaNotas);
        JViewport viewport = new JViewport();
        viewport.setView((Component)this.tablaFija);
        viewport.setPreferredSize(this.tablaFija.getPreferredSize());
        this.scroll.setRowHeaderView(viewport);
        this.scroll.setCorner("UPPER_LEFT_CORNER", (Component)this.tablaFija.getTableHeader());
    }

    private void checkSelection(boolean isFixedTable) {
        int selectedIndex;
        int fixedSelectedIndex = this.tablaFija.getSelectedRow();
        if (fixedSelectedIndex != (selectedIndex = this.tablaNotas.getSelectedRow())) {
            if (isFixedTable) {
                this.tablaNotas.setRowSelectionInterval(fixedSelectedIndex, fixedSelectedIndex);
            } else {
                this.tablaFija.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    public int getNombreMasLargo() {
        return this.nombreMasLargo;
    }

    public void setNombreMasLargo(int nombreMasLargo) {
        this.nombreMasLargo = nombreMasLargo;
    }

    public JBroTable getTablaFija() {
        return this.tablaFija;
    }

    public void setTablaFija(JBroTable tablaFija) {
        this.tablaFija = tablaFija;
    }

    public JBroTable getTablaNotas() {
        return this.tablaNotas;
    }

    public void setTablaNotas(JBroTable tablaNotas) {
        this.tablaNotas = tablaNotas;
    }

    public JScrollPane getScroll() {
        return this.scroll;
    }

    public void setScroll(JScrollPane scroll) {
        this.scroll = scroll;
    }
}

