/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.EstudianteRetiradoDao;
import Modelos.Dao.EstudianteRetiradoDaoImpl;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.AsistenciaBachillerato;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.PeriodoInactividad;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.view.JBroTable;

public class JBroTableDataAsistenciaBachillerato
extends JBroTable {
    private final List<Asignacion> asistenciaEstudiantes;
    private final ModelField[] fields;
    private final Instructor instructor;
    private final BigDecimal numeroDiasClase;
    private final Integer codigoParalelo;
    private final AsistenciaBachilleratoDaoImpl asistenciaBachilleratoDaoImpl = new AsistenciaBachilleratoDaoImpl();
    private final EstudianteRetiradoDao estudianteRetiradoDao = new EstudianteRetiradoDaoImpl();

    public JBroTableDataAsistenciaBachillerato(ModelData data, List<Asignacion> asistenciaEstudiantes, ModelField[] fields, Instructor instructor, BigDecimal numeroDiasClase, Integer codigoParalelo) {
        super(data);
        this.asistenciaEstudiantes = asistenciaEstudiantes;
        this.fields = fields;
        this.instructor = instructor;
        this.numeroDiasClase = numeroDiasClase;
        this.codigoParalelo = codigoParalelo;
    }

    public int getRowCount() {
        return this.asistenciaEstudiantes.size();
    }

    public Class<?> getColumnClass(int i) {
        return this.getValueAt(this.getRowCount() - 1, i).getClass();
    }

    public boolean isCellEditable(int fila, int col) {
        boolean valor = false;
        if (this.fields[col].toString().equals("SET")) {
            valor = true;
        } else if (!this.fields[col].toString().equals("VC")) {
            Asignacion asignacion = this.asistenciaEstudiantes.get(fila);
            String[] codigo = this.fields[col].getIdentifier().split("-");
            AsistenciaBachillerato asistencia = this.asistenciaBachilleratoDaoImpl.buscarInasistenciaJustificadaEstudiantePorHorarioDiaAsignacion(asignacion.getId(), codigo[0], Integer.valueOf(codigo[1]));
            if (asistencia == null) {
                valor = true;
            }
        }
        return !this.fields[col].toString().equals("VC") && valor;
    }

    public Object getValueAt(int fila, int col) {
        Asignacion asignacion = this.asistenciaEstudiantes.get(fila);
        PeriodoInactividad retirado = this.estudianteRetiradoDao.buscarPorAsignacion(asignacion.getId(), this.instructor.getIdParalelo());
        Comparable<Boolean> valor = null;
        if (!this.fields[col].toString().equals("VC") && !this.fields[col].toString().equals("SET")) {
            String[] codigo = this.fields[col].getIdentifier().split("-");
            AsistenciaBachillerato asistencia = this.asistenciaBachilleratoDaoImpl.buscarAsistenciaEstudiantePorHorarioDiaAsignacion(asignacion.getId(), codigo[0], Integer.valueOf(codigo[1]));
            valor = asistencia == null ? Boolean.valueOf(true) : asistencia.getAsistencia();
            if (retirado != null && !retirado.getRetirado().booleanValue()) {
                valor = retirado.getRetirado();
            }
        } else if (this.fields[col].toString().equals("SET")) {
            valor = retirado == null ? Boolean.valueOf(true) : retirado.getRetirado();
        } else if (retirado != null && !retirado.getRetirado().booleanValue()) {
            valor = new BigDecimal("100");
        } else {
            List<Asignacion> inasistencia = this.asistenciaBachilleratoDaoImpl.buscarInasistenciaPorParaleloAsignacion(this.codigoParalelo, asignacion.getId(), this.instructor.getId());
            List<Asignacion> justificacion = this.asistenciaBachilleratoDaoImpl.buscarJustificacionPorParaleloAsignacion(this.codigoParalelo, asignacion.getId(), this.instructor.getId());
            BigDecimal resu = new BigDecimal(inasistencia.size()).subtract(new BigDecimal(justificacion.size())).divide(this.numeroDiasClase, 4, RoundingMode.DOWN).multiply(new BigDecimal(100)).setScale(2, RoundingMode.DOWN);
            valor = resu;
        }
        return valor;
    }

    public void setValueAt(Object o, int fila, int col) {
        boolean update = true;
        Boolean valorSetear = null;
        Asignacion asignacion = this.asistenciaEstudiantes.get(fila);
        if (o != null) {
            valorSetear = (Boolean)o;
        }
        if (this.fields[col].toString().equals("SET")) {
            PeriodoInactividad retiradoAux = this.estudianteRetiradoDao.buscarPorAsignacion(asignacion.getId(), this.instructor.getIdParalelo());
            if (retiradoAux == null) {
                retiradoAux = new PeriodoInactividad();
                retiradoAux.setEstado("1");
                retiradoAux.setIdAsignacion(asignacion.getId());
                retiradoAux.setRetirado(valorSetear);
                retiradoAux.setIdUsuarioCreacion(this.instructor.getIdUsuario());
                retiradoAux.setIdParaleloCenso(this.instructor.getIdParalelo());
                this.estudianteRetiradoDao.guardarEstudianteRetirado(retiradoAux);
            } else {
                retiradoAux.setRetirado(valorSetear);
                this.estudianteRetiradoDao.actualizarEstudianteRetirado(retiradoAux);
            }
        } else {
            String[] codigo = this.fields[col].getIdentifier().split("-");
            AsistenciaBachillerato asistencia = this.asistenciaBachilleratoDaoImpl.buscarAsistenciaEstudiantePorHorarioDiaAsignacion(asignacion.getId(), codigo[0], Integer.valueOf(codigo[1]));
            if (asistencia == null) {
                update = false;
                asistencia = new AsistenciaBachillerato();
                asistencia.setEstado("1");
                asistencia.setFecha(codigo[0]);
                asistencia.setIdHorario(Integer.valueOf(codigo[1]));
                asistencia.setIdAsignacion(asignacion.getId());
            }
            asistencia.setAsistencia(valorSetear);
            asistencia.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
            asistencia.setIdUsuarioCreacion(this.instructor.getIdUsuario());
            if (update) {
                this.asistenciaBachilleratoDaoImpl.actualizarAsistencia(asistencia);
            } else {
                this.asistenciaBachilleratoDaoImpl.guardarAsistencia(asistencia);
            }
        }
        this.updateUI();
    }
}

