/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Modelos.Dao.AsignacionDao;
import Modelos.Dao.AsignacionDaoImpl;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Dao.PeriodoAnioLectivoDao;
import Modelos.Dao.PeriodoAnioLectivoDaoImpl;
import Modelos.Dao.RecomendacionDao;
import Modelos.Dao.RecomendacionDaoImpl;
import Modelos.Entidades.Calificacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.PeriodoAnioLectivo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.view.JBroTable;
import vo.ComportamientoVO;

public class JBroTableDataRecomendacion
extends JBroTable {
    private final List<ComportamientoVO> asistenciaEstudiantes;
    private final ModelField[] fields;
    private final Instructor instructor;
    private Calificacion calificacion = null;
    private ComportamientoVO comportamientoVO = new ComportamientoVO();
    private final RecomendacionDao recomendacionDao = new RecomendacionDaoImpl();
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private final AsignacionDao asignacionDao = new AsignacionDaoImpl();
    private final PeriodoAnioLectivoDao periodoAnioLectivoDao = new PeriodoAnioLectivoDaoImpl();
    private Date fechaBloqueop1q1 = null;
    private Date fechaBloqueop2q1 = null;
    private Date fechaBloqueop3q1 = null;
    private Date fechaBloqueop1q2 = null;
    private Date fechaBloqueop2q2 = null;
    private Date fechaBloqueop3q2 = null;
    private Date fechaBloqueoExQ1 = null;
    private Date fechaBloqueoExQ2 = null;
    private Date fecha = null;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private String fechaSistema = this.format.format(new Date());

    public void obtenerFechasBloqueo() {
        List<Object> listaFechas = new ArrayList();
        listaFechas = this.periodoAnioLectivoDao.obtenerFechasNotas(this.instructor.getIdRegistroAnioLectivo());
        try {
            for (PeriodoAnioLectivo periodoAnioLectivo : listaFechas) {
                if (periodoAnioLectivo.getFechaInicio().contains("Q1P1")) {
                    this.fechaBloqueop1q1 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (periodoAnioLectivo.getFechaInicio().contains("Q1P2")) {
                    this.fechaBloqueop2q1 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (periodoAnioLectivo.getFechaInicio().contains("Q1P3")) {
                    this.fechaBloqueop3q1 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (periodoAnioLectivo.getFechaInicio().contains("Q2P1")) {
                    this.fechaBloqueop1q2 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (periodoAnioLectivo.getFechaInicio().contains("Q2P2")) {
                    this.fechaBloqueop2q2 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (periodoAnioLectivo.getFechaInicio().contains("Q2P3")) {
                    this.fechaBloqueop3q2 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (periodoAnioLectivo.getFechaInicio().contains("Q1EX")) {
                    this.fechaBloqueoExQ1 = this.format.parse(periodoAnioLectivo.getFechaFin());
                    continue;
                }
                if (!periodoAnioLectivo.getFechaInicio().contains("Q2EX")) continue;
                this.fechaBloqueoExQ2 = this.format.parse(periodoAnioLectivo.getFechaFin());
            }
            this.fecha = this.format.parse(this.fechaSistema);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JBroTableDataRecomendacion(ModelData data, List<ComportamientoVO> asistenciaEstudiantes, ModelField[] fields, Instructor instructor) {
        super(data);
        this.asistenciaEstudiantes = asistenciaEstudiantes;
        this.fields = fields;
        this.instructor = instructor;
        this.obtenerFechasBloqueo();
    }

    public int getRowCount() {
        return this.asistenciaEstudiantes.size();
    }

    public Class<?> getColumnClass(int i) {
        return this.getValueAt(this.getRowCount() - 1, i).getClass();
    }

    public boolean isCellEditable(int fila, int col) {
        return true;
    }

    public Object getValueAt(int fila, int col) {
        this.comportamientoVO = this.asistenciaEstudiantes.get(fila);
        String valor = null;
        try {
            switch (this.fields[col].getIdentifier()) {
                case "Q1P1": {
                    valor = this.comportamientoVO.getNota1Nota1();
                    break;
                }
                case "Q1P2": {
                    valor = this.comportamientoVO.getNota2Nota1();
                    break;
                }
                case "Q1P3": {
                    valor = this.comportamientoVO.getNota3Nota1();
                    break;
                }
                case "Q1Q1": {
                    valor = this.comportamientoVO.getNotaQuimestreNota1();
                    break;
                }
                case "Q2P1": {
                    valor = this.comportamientoVO.getNota1Nota2();
                    break;
                }
                case "Q2P2": {
                    valor = this.comportamientoVO.getNota2Nota2();
                    break;
                }
                case "Q2P3": {
                    valor = this.comportamientoVO.getNota3Nota2();
                    break;
                }
                case "Q2Q2": {
                    valor = this.comportamientoVO.getNotaQuimestreNota2();
                    break;
                }
                case "QTCF": {
                    valor = this.comportamientoVO.getObservacion();
                    break;
                }
                default: {
                    valor = "";
                    break;
                }
            }
        }
        catch (Exception e) {
            valor = "";
        }
        return valor;
    }

    public void setValueAt(Object o, int fila, int col) {
    }
}

