/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.Constantes;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import Util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ConexionSQLite {
    private String url;
    private final String urlDirectorioBase = Util.rutaApp() + Constantes.DIRECTORIO_BASE_DATOS;

    public Connection getConnection() {
        try {
            this.url = this.urlDirectorioBase + ObtenerPropiedad.obtenerPropiedadFile("bdd");
            return DriverManager.getConnection("jdbc:sqlite:" + this.url);
        }
        catch (IOException | SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public Connection getConnectionPlatilla() {
        try {
            this.url = this.urlDirectorioBase + ObtenerPropiedad.obtenerPropiedadFile("plantilla");
            return DriverManager.getConnection("jdbc:sqlite:" + this.url);
        }
        catch (IOException | SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public void cerrarExterno(Connection conn) throws SQLException {
        if (conn != null) {
            try {
                if (!conn.isClosed()) {
                    conn.close();
                    this.url = this.urlDirectorioBase + ObtenerPropiedad.obtenerPropiedad("bdd");
                    Util.encriptaArchivoBB(this.url);
                }
            }
            catch (FileNotFoundException | SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace(e));
            }
        }
    }
}

