/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.ClienteServicioWeb;
import Util.ConexionSQLite;
import Util.Constantes;
import Util.MsgLog;
import Util.ScriptRunner;
import Util.Util;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class MigrateDatabase {
    public static void actualizarModeloDatos(boolean actualizarPlantilla) {
        try {
            int ultimaVersion = MigrateDatabase.consultarUltimaMigracion("B", actualizarPlantilla);
            int versionActual = 0;
            boolean actualizar = false;
            Path data_file = Paths.get(Util.rutaApp() + Constantes.PATH_BASE_DATOS_MODELO, new String[0]);
            URL url = data_file.toFile().toURL();
            boolean continuar = true;
            try {
                ScriptRunner scriptRunner = new ScriptRunner(actualizarPlantilla ? new ConexionSQLite().getConnectionPlatilla() : new ConexionSQLite().getConnection(), false, true);
                if (url != null) {
                    File directory = new File(url.getPath());
                    File[] fList = directory.listFiles();
                    if (fList != null && fList.length > 0) {
                        block6: do {
                            ++ultimaVersion;
                            continuar = false;
                            for (File file : fList) {
                                if (!file.isFile() || !file.getName().startsWith("V" + ultimaVersion) || !file.getName().endsWith(".sql")) continue;
                                actualizar = true;
                                versionActual = ultimaVersion;
                                continuar = true;
                                try {
                                    Util.desencriptaArchivoBB(Util.rutaApp() + Constantes.PATH_BASE_DATOS_MODELO + file.getName());
                                    scriptRunner.runScript(new FileReader(file));
                                    Util.encriptaArchivoBB(Util.rutaApp() + Constantes.PATH_BASE_DATOS_MODELO + file.getName());
                                }
                                catch (IOException | SQLException e) {
                                    Util.encriptaArchivoBB(Util.rutaApp() + Constantes.PATH_BASE_DATOS_MODELO + file.getName());
                                    MsgLog.write(ExceptionUtils.getStackTrace(e));
                                }
                                continue block6;
                            }
                        } while (continuar);
                    }
                    if (actualizar) {
                        MigrateDatabase.actualizarVersion("B", versionActual, new Date(), actualizarPlantilla);
                    }
                }
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace(e));
            }
        }
        catch (MalformedURLException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int consultarUltimaMigracion(String tipoConsulta, boolean consultarPlantilla) {
        String descripcion = tipoConsulta.equals("A") ? "APP" : "BD";
        ConexionSQLite conexionSqlite = new ConexionSQLite();
        Connection conn = consultarPlantilla ? conexionSqlite.getConnectionPlatilla() : conexionSqlite.getConnection();
        QueryRunner run = new QueryRunner();
        ScalarHandler rsh = new ScalarHandler();
        int version = 0;
        try {
            try {
                version = (Integer)run.query(conn, "select MAX(version) from versionamiento where tipo = ?", (ResultSetHandler)rsh, new Object[]{tipoConsulta});
            }
            catch (NullPointerException npe) {
                run.update(conn, "insert into versionamiento(descripcion, tipo, version, fecha_actualizacion) values(?, ?, ?, ?)", new Object[]{descripcion, tipoConsulta, 0, new Date()});
            }
            int npe = version;
            return npe;
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
            int n = 0;
            return n;
        }
        finally {
            try {
                DbUtils.close((Connection)conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void actualizarVersion(String tipoConsulta, int version, Date fechaActualizacion, boolean actualizarPlantilla) {
        ConexionSQLite conexionSqlite = new ConexionSQLite();
        Connection conn = actualizarPlantilla ? conexionSqlite.getConnectionPlatilla() : conexionSqlite.getConnection();
        QueryRunner run = new QueryRunner();
        try {
            run.update(conn, "update versionamiento set version = ?, fecha_actualizacion = ? where tipo = ?", new Object[]{version, fechaActualizacion, tipoConsulta});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        finally {
            try {
                DbUtils.close((Connection)conn);
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace(e));
            }
        }
    }

    public static Date getLastModification() {
        Date lastModification = null;
        try {
            String fechaActualizacion = ClienteServicioWeb.servicioWebGet("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/UltimaFechaActualizacionApp");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            lastModification = format.parse(fechaActualizacion);
        }
        catch (ParseException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace(ex));
        }
        return lastModification;
    }

    public static Date getLastModificationMetadata() {
        Date lastModification = null;
        try {
            URL url = new URL(MigrateDatabase.getDownloadLinkFromHost());
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            long date = httpCon.getLastModified();
            if (date != 0L) {
                lastModification = new Date(date);
            }
        }
        catch (MalformedURLException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace(ex));
        }
        catch (IOException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace(ex));
        }
        return lastModification;
    }

    public static String getDownloadLinkFromHost() throws MalformedURLException, IOException {
        URL url = new URL("https://www.educarecuador.gob.ec/anexos/academico/app/update/url.html");
        InputStream html = null;
        html = url.openStream();
        int c = 0;
        StringBuilder buffer = new StringBuilder("");
        while (c != -1) {
            c = html.read();
            buffer.append((char)c);
        }
        return buffer.substring(buffer.indexOf("[url]") + 5, buffer.indexOf("[/url]"));
    }
}

