/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.ClienteServicioWeb;
import Util.Encripta;
import Util.MD5;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dto.JarDTO;
import ec.gob.educacion.encripta.UtilEncripta;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import update.Main_Gui;

public class Util {
    private static final int BUFFER_SIZE = 4096;

    public static Boolean encriptaArchivoBBNueva(String url) {
        try (FileWriter fw = new FileWriter(url, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            String key = String.valueOf(Calendar.getInstance().getTimeInMillis());
            out.println(Util.generaKeyEncriptar(MD5.getMD5(key)));
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return Util.encriptaArchivoBB(url);
    }

    public static Boolean encriptaArchivoBB1(String url) {
        Boolean exito;
        block40: {
            exito = false;
            try {
                String key1;
                String key;
                Encripta encripta;
                File archivoBB = new File(url);
                if (!archivoBB.isFile() || !(encripta = new Encripta(Util.generaKeyEncriptar(key = MD5.getMD5(key1 = String.valueOf(Calendar.getInstance().getTimeInMillis()))))).encrypt(archivoBB, archivoBB).booleanValue()) break block40;
                try (FileWriter fw = new FileWriter(url, true);
                     BufferedWriter bw = new BufferedWriter(fw);
                     PrintWriter out = new PrintWriter(bw);){
                    out.println(key1);
                }
                catch (IOException e) {
                    MsgLog.write(ExceptionUtils.getStackTrace(e));
                }
                ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                exito = true;
            }
            catch (IOException e) {
                MsgLog.write(ExceptionUtils.getStackTrace(e));
            }
        }
        return exito;
    }

    public static Boolean desencriptaArchivoBB1(String url) {
        Boolean exito = false;
        try {
            File archivoBB = new File(url);
            if (archivoBB.isFile()) {
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                FileChannel channel = FileChannel.open(Paths.get(url, new String[0]), StandardOpenOption.READ);
                channel.read(buffer, channel.size() - 15L);
                RandomAccessFile file = new RandomAccessFile(url, "rw");
                long length = file.length();
                file.setLength(length - 15L);
                file.close();
                archivoBB = new File(url);
                String ultimaModificacion = String.valueOf(archivoBB.lastModified());
                String key1 = new String(buffer.array());
                String key2 = key1.trim();
                String key = MD5.getMD5(key1.trim());
                Encripta encripta = new Encripta(Util.generaKeyEncriptar(key));
                if (!encripta.decrypt(archivoBB, archivoBB).booleanValue()) {
                    exito = MD5.getMD5(ultimaModificacion).equals(ObtenerPropiedad.obtenerPropiedad("ortografia"));
                } else {
                    ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                    exito = true;
                }
            }
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return exito;
    }

    public static Boolean desencriptaArchivoImportado(String url, String keyAnterior) {
        Boolean exito = false;
        try {
            File archivoBB = new File(url);
            if (archivoBB.isFile()) {
                String ultimaModificacion = String.valueOf(archivoBB.lastModified());
                String key = MD5.getMD5(keyAnterior);
                Encripta encripta = new Encripta(Util.generaKeyEncriptar(key));
                if (!encripta.decrypt(archivoBB, archivoBB).booleanValue()) {
                    exito = MD5.getMD5(ultimaModificacion).equals(ObtenerPropiedad.obtenerPropiedad("ortografia"));
                } else {
                    ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                    exito = true;
                }
            }
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return exito;
    }

    private static String generaKeyEncriptar(String keyInicial) {
        String outKeyFinal = keyInicial;
        Integer keySize = 16;
        if (keyInicial.length() > keySize) {
            outKeyFinal = outKeyFinal.substring(0, keySize);
        } else {
            for (int i = keyInicial.length() + 1; i <= keySize; ++i) {
                outKeyFinal = outKeyFinal + String.valueOf((char)(122 - i));
            }
        }
        return outKeyFinal;
    }

    public static Boolean encriptaArchivoBB(String url) {
        Boolean exito = false;
        try {
            if (UtilEncripta.encriptaArchivoBB((String)url).booleanValue()) {
                File archivoBB = new File(url);
                ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                exito = true;
            }
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return exito;
    }

    public static Boolean desencriptaArchivoBB(String url) {
        Boolean exito = false;
        try {
            File archivoBB = new File(url);
            String ultimaModificacion = String.valueOf(archivoBB.lastModified());
            if (!UtilEncripta.desencriptaArchivoBB((String)url).booleanValue()) {
                exito = MD5.getMD5(ultimaModificacion).equals(ObtenerPropiedad.obtenerPropiedad("ortografia"));
            } else {
                ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                exito = true;
            }
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return exito;
    }

    public static String rutaApp() {
        String ruta = null;
        try {
            File pto = new File(Main_Gui.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            ruta = pto.getCanonicalPath();
        }
        catch (IOException | URISyntaxException ex) {
            MsgLog.write(ExceptionUtils.getStackTrace(ex));
        }
        return Paths.get(ruta, new String[0]).getParent().toString();
    }

    public static List<JarDTO> listarElementosControlVersionesDesdeServidor() {
        ArrayList<JarDTO> listaJars = new ArrayList();
        Gson gson = new Gson();
        Type type = new TypeToken<List<JarDTO>>(){}.getType();
        MsgLog.write("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/VersionadorDetalleObjetos");
        String jsonRespuesta = ClienteServicioWeb.servicioWebGet("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/VersionadorDetalleObjetos");
        listaJars = (List)gson.fromJson(jsonRespuesta, type);
        return listaJars;
    }

    public static List<String> listarArchivosDesdeAppEscritorio(String directory) {
        ArrayList<String> listaJarsEscritorio = new ArrayList<String>();
        try (Stream<Path> paths = Files.walk(Paths.get(directory, new String[0]), new FileVisitOption[0]);){
            paths.forEach(filePath -> {
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    listaJarsEscritorio.add(Util.getNombreArchivo(filePath));
                }
            });
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return listaJarsEscritorio;
    }

    public static String getNombreArchivo(Path filePath) {
        String nombre = "";
        try {
            nombre = filePath.getFileName().toString();
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace(e));
        }
        return nombre.trim();
    }

    public static long bytesToMegaBytes(long bytes) {
        return bytes / 0x100000L;
    }

    public static List<JarDTO> listaElementosParaDescargar(String directorioEscritorioComparacion, List<JarDTO> elementosServidor, String tipoComponenteDescarga) {
        List<JarDTO> jarsDescarga = new ArrayList<JarDTO>();
        List jarsServidor = elementosServidor.stream().filter(t -> t.getTipoComponente().equalsIgnoreCase(tipoComponenteDescarga)).collect(Collectors.toList());
        if (!jarsServidor.isEmpty()) {
            jarsDescarga = jarsServidor.stream().filter(t -> !Util.listarArchivosDesdeAppEscritorio(directorioEscritorioComparacion).contains(t.getNombre().trim())).collect(Collectors.toList());
        }
        return jarsDescarga;
    }

    public static void descargarArchivosDesdeUrl(String fileURL, String saveDir) throws IOException {
        HttpURLConnection httpConn;
        block29: {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
                }
                try (InputStream inputStream = httpConn.getInputStream();){
                    String saveFilePath = saveDir + File.separator + fileName;
                    try (FileOutputStream outputStream = new FileOutputStream(saveFilePath);){
                        int bytesRead = -1;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        break block29;
                    }
                }
            }
            MsgLog.write("El recurso ubicado en " + fileURL + " no pudo ser descargado. Server replied HTTP code:" + responseCode);
        }
        httpConn.disconnect();
    }
}

