/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.customizer;

import datechooser.beans.customizer.PropertyDescriptorsHolder;
import datechooser.beans.customizer.render.CaptionCellRenderer;
import datechooser.beans.customizer.render.ValueCellRenderer;
import datechooser.beans.locale.LocaleUtils;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTableModel
extends DefaultTableModel {
    private PropertyDescriptorsHolder holder;

    public PropertyTableModel(PropertyDescriptorsHolder holder) {
        super(holder.getPropertyCount(), 2);
        this.holder = holder;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.holder.getPropertyDescriptors()[row].getName();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return CaptionCellRenderer.class;
            }
            case 1: {
                return ValueCellRenderer.class;
            }
        }
        return CaptionCellRenderer.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return LocaleUtils.getEditorLocaleString("property");
            }
            case 1: {
                return LocaleUtils.getEditorLocaleString("value");
            }
        }
        return "?? (" + column + ')';
    }
}

