/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border.types;

import datechooser.beans.editor.border.SimpleBorderEditor;
import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.utils.EditorDialog;
import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class CompoundBorderEditor
extends AbstractBorderEditor {
    private Border inside;
    private Border outside;
    private EditorDialog editorDialog;

    public CompoundBorderEditor() {
        this.initialize();
        this.setCaption(LocaleUtils.getEditorLocaleString("Compound"));
        this.editorDialog = new EditorDialog((Frame)this.getParent(), new SimpleBorderEditor());
        JPanel buttons = new JPanel(new GridLayout(2, 1, 5, 2));
        buttons.add(this.createOutsideChooseButton());
        buttons.add(this.createInsideChooseButton());
        this.setLayout(new BorderLayout());
        this.add((Component)buttons, "North");
        this.refreshInterface();
    }

    private JPanel createInsideChooseButton() {
        JButton bBorder = new JButton(LocaleUtils.getEditorLocaleString("Inside_border"));
        bBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Border newBorder = (Border)CompoundBorderEditor.this.editorDialog.showDialog(CompoundBorderEditor.this.inside, LocaleUtils.getEditorLocaleString("Select_border"));
                if (!CompoundBorderEditor.this.editorDialog.isCanceled()) {
                    CompoundBorderEditor.this.inside = newBorder;
                    CompoundBorderEditor.this.fireChange();
                }
            }
        });
        return this.getCenteredPane(bBorder);
    }

    private JPanel createOutsideChooseButton() {
        JButton bBorder = new JButton(LocaleUtils.getEditorLocaleString("Outside_border"));
        bBorder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Border newBorder = (Border)CompoundBorderEditor.this.editorDialog.showDialog(CompoundBorderEditor.this.outside, LocaleUtils.getEditorLocaleString("Select_border"));
                if (!CompoundBorderEditor.this.editorDialog.isCanceled()) {
                    CompoundBorderEditor.this.outside = newBorder;
                    CompoundBorderEditor.this.fireChange();
                }
            }
        });
        return this.getCenteredPane(bBorder);
    }

    public void prepareSelection() {
        this.value = new CompoundBorder(this.outside, this.inside);
    }

    public void refreshInterface() {
        CompoundBorder compoundBorder = (CompoundBorder)this.getCurrentBorder();
        if (compoundBorder != null) {
            this.inside = compoundBorder.getInsideBorder();
            this.outside = compoundBorder.getOutsideBorder();
        }
    }

    protected Border getDefaultValue() {
        return BorderFactory.createCompoundBorder();
    }
}

