/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.cell;

import datechooser.beans.editor.cell.CellEditorPane;
import datechooser.beans.editor.cell.CellPreview;
import datechooser.beans.editor.cell.CellViewEditor;
import datechooser.beans.editor.cell.CustomCellEditorPane;
import datechooser.beans.editor.cell.SwingCellEditorPane;
import datechooser.view.appearance.CellAppearance;
import datechooser.view.appearance.custom.CustomCellAppearance;
import datechooser.view.appearance.swing.SwingCellAppearance;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class MainCellEditorPane
extends JPanel
implements PropertyChangeListener {
    private CellViewEditor editor;
    private CellPreview preview;
    private CellAppearance value;
    private boolean tempEdit;
    private Map<Class, CellEditorPane> editPanels;
    private Class currentEditingStyle;

    public MainCellEditorPane(CellViewEditor editor) {
        this.setEditor(editor);
        this.initializeEditors();
        this.preview = new CellPreview(this.getValue());
        this.generateClonedValue();
        this.setCurrentEditingStyle(this.getEditor().getValue().getClass());
        this.setLayout(new BorderLayout());
        this.addCurrentSelector();
        this.add((Component)this.preview, "Center");
    }

    private void addCurrentSelector() {
        this.add((Component)this.getSelectors(), "North");
    }

    private void initializeEditors() {
        this.editPanels = new HashMap<Class, CellEditorPane>();
        this.editPanels.put(CustomCellAppearance.class, new CustomCellEditorPane(this));
        this.editPanels.put(SwingCellAppearance.class, new SwingCellEditorPane(this));
    }

    private CellEditorPane getCurrentEditorPane() {
        return this.editPanels.get(this.getCurrentEditingStyle());
    }

    private void generateClonedValue() {
        if (!this.isTempEdit()) {
            this.setTempEdit(true);
            this.getEditor().setValue(((CellAppearance)this.getEditor().getValue()).clone());
            this.getEditor().firePropertyChange();
            this.preview.setLook((CellAppearance)this.getEditor().getValue());
            this.setTempEdit(false);
        }
    }

    private JPanel getSelectors() {
        return this.getCurrentEditorPane();
    }

    void fireLocalPropertyChange() {
        this.getEditor().firePropertyChange();
    }

    CellAppearance getValue() {
        return (CellAppearance)this.getEditor().getValue();
    }

    public CellViewEditor getEditor() {
        return this.editor;
    }

    public void setEditor(CellViewEditor editor) {
        if (this.getEditor() != editor && this.getEditor() != null) {
            this.getEditor().removePropertyChangeListener(this);
        }
        this.editor = editor;
        if (this.getEditor() != null) {
            this.getEditor().addPropertyChangeListener(this);
        }
    }

    public boolean isTempEdit() {
        return this.tempEdit;
    }

    public void setTempEdit(boolean tempEdit) {
        this.tempEdit = tempEdit;
    }

    private Class getCurrentEditingStyle() {
        return this.currentEditingStyle;
    }

    private void setCurrentEditingStyle(Class currentEditingStyle) {
        boolean styleChanged = false;
        if (currentEditingStyle != this.getCurrentEditingStyle() && this.getCurrentEditingStyle() != null) {
            this.remove(this.getSelectors());
            styleChanged = true;
        }
        this.currentEditingStyle = currentEditingStyle;
        if (styleChanged) {
            this.addCurrentSelector();
            this.revalidate();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setCurrentEditingStyle(this.getEditor().getValue().getClass());
        this.getCurrentEditorPane().updateState();
        this.generateClonedValue();
        this.preview.repaint();
    }
}

