/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.descriptor;

import datechooser.beans.editor.descriptor.AppearancesListDescriptor;
import datechooser.beans.editor.descriptor.BackRendererDescriptor;
import datechooser.beans.editor.descriptor.BorderDescriptor;
import datechooser.beans.editor.descriptor.ClassDescriptor;
import datechooser.beans.editor.descriptor.ColorDescriptor;
import datechooser.beans.editor.descriptor.CustomCellAppearanceDescriptor;
import datechooser.beans.editor.descriptor.FontDescriptor;
import datechooser.beans.editor.descriptor.GregorianCalendarDescriptor;
import datechooser.beans.editor.descriptor.IntegerDescriptor;
import datechooser.beans.editor.descriptor.LocaleDescriptor;
import datechooser.beans.editor.descriptor.ModelBehaviorDescriptor;
import datechooser.beans.editor.descriptor.PeriodDescriptor;
import datechooser.beans.editor.descriptor.PeriodSetDescriptor;
import datechooser.beans.editor.descriptor.StringDescriptor;
import datechooser.beans.editor.descriptor.SwingCellAppearanceDescriptor;
import datechooser.beans.editor.descriptor.ViewDescriptor;
import datechooser.beans.editor.descriptor.WeekDaysStyleDescriptor;
import datechooser.beans.locale.LocaleUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;

public class DescriptionManager {
    private static DescriptionManager instance = new DescriptionManager();
    private ArrayList<ClassDescriptor> descriptors = new ArrayList();

    private DescriptionManager() {
        this.registerDescriptor(new FontDescriptor());
        this.registerDescriptor(new ColorDescriptor());
        this.registerDescriptor(new BorderDescriptor());
        this.registerDescriptor(new CustomCellAppearanceDescriptor());
        this.registerDescriptor(new SwingCellAppearanceDescriptor());
        this.registerDescriptor(new ModelBehaviorDescriptor());
        this.registerDescriptor(new ViewDescriptor());
        this.registerDescriptor(new AppearancesListDescriptor());
        this.registerDescriptor(new GregorianCalendarDescriptor());
        this.registerDescriptor(new PeriodDescriptor());
        this.registerDescriptor(new PeriodSetDescriptor());
        this.registerDescriptor(new LocaleDescriptor());
        this.registerDescriptor(new IntegerDescriptor());
        this.registerDescriptor(new StringDescriptor());
        this.registerDescriptor(new WeekDaysStyleDescriptor());
        this.registerDescriptor(new BackRendererDescriptor());
    }

    public void registerDescriptor(ClassDescriptor descriptor) {
        this.descriptors.add(descriptor);
    }

    private ClassDescriptor getDescriptor(Class aClass) {
        for (ClassDescriptor elem : this.descriptors) {
            if (!elem.getDescriptedClass().isAssignableFrom(aClass)) continue;
            return elem;
        }
        return null;
    }

    public static String describe(Object value) {
        return DescriptionManager.describe(value, null);
    }

    public static String describe(Object value, Locale locale) {
        if (value == null) {
            return LocaleUtils.getEditorLocaleString("null");
        }
        ClassDescriptor descriptor = instance.getDescriptor(value.getClass());
        if (descriptor == null) {
            return MessageFormat.format(LocaleUtils.getEditorLocaleString("cant_describe_message"), value.getClass().getName());
        }
        return locale == null ? descriptor.getDescription(value) : descriptor.getDescription(value, locale);
    }

    public static String describeJava(Object value, Class aClass) {
        ClassDescriptor descriptor = instance.getDescriptor(aClass);
        if (descriptor == null) {
            return "new " + value.getClass().getName() + "() /*" + LocaleUtils.getEditorLocaleString("no_java_init_default_used") + "*/";
        }
        if (value == null && !descriptor.canProcessNull()) {
            return "(" + aClass.getName() + ")null";
        }
        return descriptor.getJavaDescription(value);
    }
}

