/*
 * Decompiled with CFR 0.152.
 */
package datechooser.model.single;

import datechooser.model.AbstractDateChooseModel;
import datechooser.model.DateUtils;
import datechooser.model.DaysGrid;
import datechooser.model.single.SingleDateChoose;
import java.util.Calendar;

public class SingleDateChooseModel
extends AbstractDateChooseModel
implements SingleDateChoose {
    private Calendar selected = (Calendar)this.getCurrent().clone();
    private boolean nothingSelected;

    public SingleDateChooseModel(Calendar current) {
        super(current, DaysGrid.getRowsCount(), DaysGrid.getColsCount());
        this.setNothingSelected(false);
    }

    public boolean isSelected(Calendar date) {
        if (this.isNothingSelected()) {
            return false;
        }
        return DateUtils.equals(date, this.selected);
    }

    public Calendar getSelectedDate() {
        if (this.isNothingSelected()) {
            return null;
        }
        return this.getCurrent();
    }

    protected void applySelection() {
        if (this.isDateForbidden(this.getCurrent())) {
            return;
        }
        this.selected.setTime(this.getCurrent().getTime());
        this.setNothingSelected(false);
        this.firePropertyChange("selected", null, this.selected);
        this.fireSelectionChange();
        this.commit();
    }

    protected void selectColumn(int column) {
    }

    public void applySelectNothing() {
        boolean wasNothing = this.isNothingSelected();
        this.setNothingSelected(true);
        this.firePropertyChange("nothing", wasNothing, true);
        this.fireSelectionChange();
        this.commit();
    }

    public boolean isNothingSelected() {
        return this.nothingSelected;
    }

    public void setNothingSelected(boolean nothingSelected) {
        if (!this.isNothingAllowed() && nothingSelected) {
            return;
        }
        this.nothingSelected = nothingSelected;
    }

    protected void refreshIncompatibility() {
    }
}

