/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view;

import datechooser.controller.DateChooseController;
import datechooser.model.DateChoose;
import datechooser.view.AbstractNavigatePane;
import datechooser.view.ButtonNavigatePane;
import datechooser.view.ComboNavigatePane;
import datechooser.view.GridPane;
import datechooser.view.WeekDaysStyle;
import datechooser.view.appearance.AppearancesList;
import datechooser.view.appearance.ViewAppearance;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JPanel;

public class CalendarPane
extends JPanel
implements PropertyChangeListener {
    private GridPane gp;
    private AbstractNavigatePane[] navigPanes;
    private DateChoose model;
    private Locale locale;
    private int currentNavigateIndex = 0;

    public void initialize(DateChoose model, DateChooseController controller) {
        this.setPreferredSize(new Dimension(100, 100));
        this.gp = new GridPane();
        this.setLayout(new BorderLayout());
        this.navigPanes = new AbstractNavigatePane[]{new ComboNavigatePane(), new ButtonNavigatePane()};
        this.setNavigateFont(new Font("serif", 0, 11));
        this.setModel(model);
        this.gp.setModel(model);
        this.setLocale(Locale.getDefault());
        this.gp.setController(controller);
        this.add((Component)this.gp, "Center");
        this.setCurrentNavigateIndex(0);
        this.add((Component)this.getCurrentNavigPane(), "North");
    }

    private AbstractNavigatePane getCurrentNavigPane() {
        return this.navigPanes[this.getCurrentNavigateIndex()];
    }

    private void setAllNavigCurrentModel() {
        for (int i = 0; i < this.navigPanes.length; ++i) {
            this.navigPanes[i].setModel(this.getModel());
        }
    }

    public void reInitialize(DateChoose model, DateChooseController controller) {
        if (this.gp == null) {
            return;
        }
        this.setModel(model);
        this.gp.setModel(model);
        this.gp.setController(controller);
    }

    public CalendarPane(DateChoose model, DateChooseController controller) {
        this.initialize(model, controller);
    }

    public CalendarPane() {
    }

    public DateChoose getModel() {
        return this.model;
    }

    public void setModel(DateChoose model) {
        DateChoose oldModel = this.getModel();
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
        this.model = model;
        this.setAllNavigCurrentModel();
        this.getModel().addPropertyChangeListener(this);
        this.firePropertyChange("model", oldModel, model);
    }

    public Font getNavigateFont() {
        return this.getCurrentNavigPane().getFont();
    }

    public void setNavigateFont(Font font) {
        Font oldFont = this.getNavigateFont();
        for (int i = 0; i < this.navigPanes.length; ++i) {
            this.navigPanes[i].setFont(font);
        }
        this.updateUI();
        this.firePropertyChange("dch_navFont", oldFont, font);
    }

    public ViewAppearance getCurrentCellAppearance() {
        return this.gp.getAppearance();
    }

    public AppearancesList getAppearancesList() {
        return this.gp.getAppearanceList();
    }

    public void setAppearancesList(AppearancesList aList) {
        AppearancesList oldView = this.getAppearancesList();
        this.gp.setAppearanceList(aList);
        this.firePropertyChange("dch_view", oldView, aList);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (this.getLocale() != null && this.getLocale().equals(locale)) {
            return;
        }
        Locale oldLocale = this.getLocale();
        this.locale = locale;
        this.model.setLocale(locale);
        this.gp.setLocale(locale);
        for (AbstractNavigatePane pane : this.navigPanes) {
            pane.setLocale(locale);
        }
        this.firePropertyChange("dch_locale", oldLocale, locale);
    }

    public int getCurrentNavigateIndex() {
        return this.currentNavigateIndex;
    }

    public void setCurrentNavigateIndex(int currentNavigateIndex) {
        int newPaneIndex = 0;
        if (currentNavigateIndex >= 0 && currentNavigateIndex < this.navigPanes.length) {
            newPaneIndex = currentNavigateIndex;
        }
        if (newPaneIndex != this.getCurrentNavigateIndex()) {
            int oldIndex = this.getCurrentNavigateIndex();
            this.remove(this.getCurrentNavigPane());
            this.currentNavigateIndex = currentNavigateIndex;
            this.add((Component)this.getCurrentNavigPane(), "North");
            this.revalidate();
            this.getCurrentNavigPane().setEnabled(this.getModel().isEnabled());
            this.firePropertyChange("dch_navigPane", oldIndex, newPaneIndex);
        }
    }

    public WeekDaysStyle getWeekStyle() {
        return this.gp.getWeekStyle();
    }

    public void setWeekStyle(WeekDaysStyle weekStyle) {
        WeekDaysStyle oldStyle = this.getWeekStyle();
        this.gp.setWeekStyle(weekStyle);
        this.firePropertyChange("dch_weekDayStyle", (Object)oldStyle, (Object)weekStyle);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        DateChoose model = this.getModel();
        this.gp.setEnabled(model.isEnabled());
        AbstractNavigatePane navig = this.getCurrentNavigPane();
        navig.setNothingSelectEnabled(model.isNothingAllowed());
        navig.setEnabled(model.isEnabled());
    }

    public void setGridBackground(Color color) {
        this.gp.setBackground(color);
    }

    public Color getGridBackground() {
        return this.gp.getBackground();
    }
}

