/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view.appearance.swing;

import datechooser.view.appearance.CellAppearance;
import datechooser.view.appearance.CellRenderer;
import datechooser.view.appearance.swing.Painter;
import datechooser.view.appearance.swing.SwingCellAttributes;
import datechooser.view.appearance.swing.SwingCellRenderer;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;

public class SwingCellAppearance
extends CellAppearance
implements SwingCellAttributes {
    private boolean pressed;
    private boolean enabled;
    private SwingCellRenderer renderer;
    private Painter painter;
    private Color cursorColor;

    public SwingCellAppearance(Font font, Color color, Color cursorColor, boolean pressed, boolean enabled, Painter painter) {
        this.renderer = new SwingCellRenderer(this, painter);
        this.painter = painter;
        this.setTextColor(color);
        this.setFont(font);
        this.setPressed(pressed);
        this.setEnabled(enabled);
        this.setCursorColor(cursorColor);
    }

    public Painter getPainter() {
        return this.renderer.getPainter();
    }

    protected CellRenderer getRenderer() {
        return this.renderer;
    }

    public Object clone() {
        SwingCellAppearance newInst = new SwingCellAppearance(this.getFont(), this.getTextColor(), this.getCursorColor(), this.isPressed(), this.isEnabled(), (Painter)this.renderer.getPainter().clone());
        newInst.setSelectable(this.isSelectable());
        return newInst;
    }

    public void assign(CellAppearance newAppearance) {
        if (newAppearance == null) {
            return;
        }
        SwingCellAppearance swingAppearance = (SwingCellAppearance)newAppearance;
        this.setTextColor(swingAppearance.getTextColor());
        this.setFont(swingAppearance.getFont());
        this.setCursorColor(swingAppearance.getCursorColor());
        this.setSelectable(swingAppearance.isSelectable());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwingCellAppearance value = (SwingCellAppearance)obj;
        return this.getTextColor().equals(value.getTextColor()) && this.getCursorColor().equals(value.getCursorColor()) && this.getFont().equals(value.getFont());
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Font getFont() {
        Font aFont = this.painter.getFont();
        if (aFont == null) {
            return this.renderer.getDefaultFont();
        }
        return aFont;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
    }

    public Color getTextColor() {
        return this.painter.getTextColor();
    }

    public void setFont(Font font) {
        this.painter.setFont(font);
    }

    public void setTextColor(Color textColor) {
        this.painter.setTextColor(textColor);
    }

    public Composite getComposite() {
        return null;
    }
}

