/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.model.Utils;

public class ModelField
implements Serializable,
Comparable<ModelField>,
IModelFieldGroup {
    private static final long serialVersionUID = 3L;
    private String identifier;
    private String caption;
    private ModelFieldGroup parent;
    private int rowspan;
    private boolean fixed;
    private boolean manageable;
    private boolean visible;
    private Integer defaultWidth;

    public ModelField() {
        this(null, null);
    }

    public ModelField(String identifier, String caption) {
        this.caption = caption;
        this.identifier = identifier;
        this.visible = true;
        this.manageable = true;
    }

    @Override
    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Trying to set a null identifier for the field " + this.identifier + " (" + this.caption + ")");
        }
        this.identifier = identifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public ModelField withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public ModelField withVisible(boolean visible) {
        this.setVisible(visible);
        return this;
    }

    public Integer getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(Integer defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public ModelField withDefaultWidth(Integer defaultWidth) {
        this.setDefaultWidth(defaultWidth);
        return this;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public void setCaption(String caption) {
        this.caption = caption;
    }

    public ModelField withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        if (fixed && this.parent != null) {
            this.parent.setFixed(fixed);
        }
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    public ModelField withFixed(boolean fixed) {
        this.setFixed(fixed);
        return this;
    }

    @Override
    public void setManageable(boolean manageable) {
        this.manageable = manageable;
        if (!manageable && this.parent != null) {
            this.parent.setManageable(manageable);
        }
    }

    @Override
    public boolean isManageable() {
        return this.manageable;
    }

    public ModelField withManageable(boolean manageable) {
        this.setManageable(manageable);
        return this;
    }

    @Override
    public ModelFieldGroup getParent() {
        return this.parent;
    }

    void setParent(ModelFieldGroup parent) {
        this.parent = parent;
    }

    private ModelField withParent(ModelFieldGroup parent) {
        this.setParent(parent);
        return this;
    }

    @Override
    public ModelField clone() {
        ModelField ret;
        try {
            ret = (ModelField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ret = new ModelField();
        }
        return ret.withIdentifier(this.identifier).withCaption(this.caption).withVisible(this.visible).withFixed(this.fixed).withManageable(this.manageable).withParent(this.parent).withRowspan(this.rowspan).withDefaultWidth(this.defaultWidth);
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    @Override
    public boolean equals(Object obj, boolean withParent) {
        if (!(obj instanceof ModelField)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ModelField field = (ModelField)obj;
        return Utils.equals(this.identifier, field.identifier) && Utils.equals(this.caption, field.caption) && (!withParent || Utils.equals(this.parent, field.parent));
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.identifier == null ? 0 : this.identifier.hashCode());
        hash = 19 * hash + (this.caption == null ? 0 : this.caption.hashCode());
        return hash;
    }

    @Override
    public int getColspan() {
        return 1;
    }

    @Override
    public int getRowspan() {
        return this.rowspan;
    }

    @Override
    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public ModelField withRowspan(int rowspan) {
        this.setRowspan(rowspan);
        return this;
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public int compareTo(ModelField modelField) {
        return modelField == null || modelField.identifier == null ? -1 : (this.identifier == null ? 1 : this.identifier.compareTo(modelField.identifier));
    }

    public static boolean equals(ModelField[] fields1, ModelField[] fields2) {
        if (fields1 == null && fields2 == null) {
            return true;
        }
        if (fields1 == null && fields2 != null || fields1 != null && fields2 == null || fields1.length != fields2.length) {
            return false;
        }
        for (int a = 0; a < fields1.length; ++a) {
            if (fields1[a].equals(fields2[a])) continue;
            return false;
        }
        return true;
    }

    public static int getVisibleFieldsCount(ModelField[] fields) {
        if (fields == null || fields.length == 0) {
            return 0;
        }
        int result = 0;
        for (ModelField field : fields) {
            if (!field.isVisible()) continue;
            ++result;
        }
        return result;
    }

    public static int getIndexOfModelField(ModelField[] fields, String identifier) {
        if (fields == null || fields.length == 0 || identifier == null) {
            return -1;
        }
        for (int a = 0; a < fields.length; ++a) {
            if (fields[a] == null || !fields[a].identifier.equals(identifier)) continue;
            return a;
        }
        return -1;
    }

    public static LinkedHashMap<String, Integer> getIndexes(ModelField[] fields) {
        LinkedHashMap<String, Integer> ret = new LinkedHashMap<String, Integer>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            ret.put(fields[i].getIdentifier(), i);
        }
        return ret;
    }

    public static ModelField[] copyOfModelFields(ModelField[] fields) {
        if (fields == null || fields.length == 0) {
            return fields;
        }
        IModelFieldGroup[] upperFields = ModelFieldGroup.getUpperFieldGroups(fields);
        IModelFieldGroup[] ret = new IModelFieldGroup[upperFields.length];
        for (int i = 0; i < upperFields.length; ++i) {
            ret[i] = upperFields[i].clone();
        }
        return ModelFieldGroup.getBottomFields(ret);
    }

    public boolean isDescendantOf(IModelFieldGroup ancestorCandidate, boolean checkAncestorCandidateItself) {
        if (ancestorCandidate == null) {
            return false;
        }
        if (!checkAncestorCandidateItself) {
            ancestorCandidate = ancestorCandidate.getParent();
        }
        while (ancestorCandidate != null) {
            if (ancestorCandidate == this) {
                return true;
            }
            ancestorCandidate = ancestorCandidate.getParent();
        }
        return false;
    }
}

