/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.openxmlformats;

import fr.opensagres.poi.xwpf.converter.core.openxmlformats.AbstractOpenXMLFormatsPartProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSettings;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyles;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FontsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.SettingsDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.StylesDocument;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RelashionShipsHandler
extends DefaultHandler {
    private final Map<String, Relationship> relationships;
    private final AbstractOpenXMLFormatsPartProvider provider;
    private CTStyles styles;
    private final List<ThemeDocument> themeDocuments;
    private final List<FontsDocument> fontsDocuments;
    private CTSettings settings;

    private RelashionShipsHandler(AbstractOpenXMLFormatsPartProvider provider) {
        this.provider = provider;
        this.relationships = new HashMap<String, Relationship>();
        this.themeDocuments = new ArrayList<ThemeDocument>();
        this.fontsDocuments = new ArrayList<FontsDocument>();
    }

    public static RelashionShipsHandler create(String partName, AbstractOpenXMLFormatsPartProvider provider) throws SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        RelashionShipsHandler contentHandler = new RelashionShipsHandler(provider);
        xmlReader.setContentHandler(contentHandler);
        xmlReader.parse(new InputSource(provider.getEntryInputStream("word/_rels/" + partName + ".rels")));
        return contentHandler;
    }

    @Override
    public final void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("Relationship".equals(localName)) {
            String id = attributes.getValue("Id");
            String type = attributes.getValue("Type");
            String target = attributes.getValue("Target");
            this.relationships.put(id, new Relationship(id, type, target));
            if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/settings".equals(type)) {
                InputStream in = this.getInputStream(target);
                try {
                    this.settings = SettingsDocument.Factory.parse((InputStream)in).getSettings();
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles".equals(type)) {
                InputStream in = this.getInputStream(target);
                try {
                    this.styles = StylesDocument.Factory.parse((InputStream)in).getStyles();
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme".equals(type)) {
                InputStream in = this.getInputStream(target);
                try {
                    ThemeDocument theme = ThemeDocument.Factory.parse((InputStream)in);
                    this.themeDocuments.add(theme);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
            if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/fontTable".equals(type)) {
                InputStream in = this.getInputStream(target);
                try {
                    FontsDocument fonts = FontsDocument.Factory.parse((InputStream)in);
                    this.fontsDocuments.add(fonts);
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            }
        }
    }

    private InputStream getInputStream(String target) {
        return this.provider.getEntryInputStream("word/" + target);
    }

    public InputStream getInputStreamByRelId(String relId) {
        Relationship relation = this.getRelationship(relId);
        return this.getInputStream(relation.target);
    }

    public List<ThemeDocument> getThemeDocuments() {
        return this.themeDocuments;
    }

    public List<FontsDocument> getFontsDocument() {
        return this.fontsDocuments;
    }

    public CTSettings getSettings() {
        return this.settings;
    }

    public CTStyles getStyle() {
        return this.styles;
    }

    public FtrDocument getFtrDocument(String relId) throws XmlException, IOException {
        Relationship relationship = this.getRelationship(relId);
        InputStream in = this.provider.getEntryInputStream("word/" + relationship.target);
        FtrDocument ftrDoc = FtrDocument.Factory.parse((InputStream)in);
        return ftrDoc;
    }

    Relationship getRelationship(String relId) {
        return this.relationships.get(relId);
    }

    public HdrDocument getHdrDocument(String relId) throws XmlException, IOException {
        Relationship relationship = this.getRelationship(relId);
        InputStream in = this.provider.getEntryInputStream("word/" + relationship.target);
        HdrDocument hdrDoc = HdrDocument.Factory.parse((InputStream)in);
        return hdrDoc;
    }

    static class Relationship {
        public final String id;
        public final String type;
        public final String target;

        public Relationship(String id, String type, String target) {
            this.id = id;
            this.type = type;
            this.target = target;
        }
    }
}

