/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.odt.odfdom.xhtml;

import fr.opensagres.odfdom.converter.core.ODFConverterException;
import fr.opensagres.odfdom.converter.xhtml.XHTMLConverter;
import fr.opensagres.odfdom.converter.xhtml.XHTMLOptions;
import fr.opensagres.xdocreport.converter.IURIResolver;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.OptionsHelper;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterNoEntriesSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;

public class ODF2XHTMLConverter
extends AbstractConverterNoEntriesSupport
implements MimeMappingConstants {
    private static final ODF2XHTMLConverter INSTANCE = new ODF2XHTMLConverter();

    public static ODF2XHTMLConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public void convert(InputStream in, OutputStream out, Options options) throws XDocConverterException {
        try {
            OdfTextDocument odfDocument = OdfTextDocument.loadDocument((InputStream)in);
            XHTMLConverter.getInstance().convert((OdfDocument)odfDocument, out, this.toXHTMLOptions(options));
        }
        catch (ODFConverterException e) {
            throw new XDocConverterException(e);
        }
        catch (IOException e) {
            throw new XDocConverterException(e);
        }
        catch (Exception e) {
            throw new XDocConverterException(e);
        }
    }

    public XHTMLOptions toXHTMLOptions(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(XHTMLOptions.class);
        if (value instanceof XHTMLOptions) {
            return (XHTMLOptions)value;
        }
        XHTMLOptions xhtmlOptions = XHTMLOptions.create();
        final IURIResolver resolver = OptionsHelper.getURIResolver(options);
        if (resolver != null) {
            xhtmlOptions.URIResolver(new fr.opensagres.odfdom.converter.core.IURIResolver(){

                @Override
                public String resolve(String uri) {
                    return resolver.resolve(uri);
                }
            });
        }
        return xhtmlOptions;
    }

    @Override
    public MimeMapping getMimeMapping() {
        return XHTML_MIME_MAPPING;
    }

    @Override
    public boolean isDefault() {
        return true;
    }
}

