/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax;

import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.Directive;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.Attributes;

public abstract class MergefieldBufferedRegion
extends BufferedElement {
    private static final String TEXTSTYLING = "_TEXTSTYLING";
    private static final String W_P = "w:p";
    private static final String START_MERGEFORMAT = "\\*";
    private static final String MERGEFORMAT = "MERGEFORMAT";
    private static final String MERGEFIELD_FIELD_TYPE = "MERGEFIELD";
    private static final String HYPERLINK_FIELD_TYPE = "HYPERLINK";
    private final TransformedBufferedDocumentContentHandler handler;
    private String fieldName;
    private BufferedElement tRegion;

    public MergefieldBufferedRegion(TransformedBufferedDocumentContentHandler handler, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.handler = handler;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String setInstrText(String instrText, FieldMetadata fieldAsTextStyling) {
        this.fieldName = MergefieldBufferedRegion.getFieldName(this, instrText, fieldAsTextStyling, this.handler.getFormatter(), this.handler);
        if (this.fieldName == null) {
            return this.decodeInstrTextIfNeeded(instrText);
        }
        return instrText;
    }

    private String decodeInstrTextIfNeeded(String instrText) {
        String fieldName;
        IDocumentFormatter formatter = this.handler.getFormatter();
        if (formatter == null) {
            return instrText;
        }
        int index = instrText.indexOf(HYPERLINK_FIELD_TYPE);
        if (index != -1 && StringUtils.isNotEmpty(fieldName = instrText.substring(index + HYPERLINK_FIELD_TYPE.length(), instrText.length()).trim())) {
            if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            if (formatter.containsInterpolation(fieldName = StringUtils.decode(fieldName))) {
                return StringUtils.decode(instrText);
            }
        }
        return instrText;
    }

    private static String getFieldName(MergefieldBufferedRegion mergefield, String instrText, FieldMetadata fieldAsTextStyling, IDocumentFormatter formatter, TransformedBufferedDocumentContentHandler handler) {
        String fieldName;
        if (StringUtils.isEmpty(instrText)) {
            return null;
        }
        int index = instrText.indexOf(MERGEFIELD_FIELD_TYPE);
        if (index != -1 && StringUtils.isNotEmpty(fieldName = instrText.substring(index + MERGEFIELD_FIELD_TYPE.length(), instrText.length()).trim())) {
            String mergeformat;
            int mergeFormatIndex = fieldName.lastIndexOf(START_MERGEFORMAT);
            if (mergeFormatIndex != -1 && MERGEFORMAT.startsWith(mergeformat = fieldName.substring(mergeFormatIndex + START_MERGEFORMAT.length(), fieldName.length()).trim())) {
                fieldName = fieldName.substring(0, mergeFormatIndex).trim();
            }
            if (StringUtils.isNotEmpty(fieldName)) {
                if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                    fieldName = fieldName.length() == 1 ? "" : fieldName.substring(1, fieldName.length() - 1);
                }
                fieldName = StringUtils.replaceAll(fieldName, "\\\"", "\"");
                fieldName = StringUtils.xmlUnescape(fieldName);
                if (fieldAsTextStyling != null) {
                    String key;
                    BufferedElement parent = mergefield.findParent(W_P);
                    String directive = parent.get(key = fieldName + TEXTSTYLING);
                    if (directive != null) {
                        return directive;
                    }
                    long variableIndex = handler.getVariableIndex();
                    String elementId = handler.registerBufferedElement(variableIndex, parent);
                    String setVariableDirective = formatter.formatAsCallTextStyling(variableIndex, fieldName, DocumentKind.DOCX.name(), fieldAsTextStyling.getSyntaxKind(), fieldAsTextStyling.isSyntaxWithDirective(), elementId, handler.getEntryName());
                    String textBefore = formatter.formatAsTextStylingField(variableIndex, "textBefore");
                    String textBody = formatter.formatAsTextStylingField(variableIndex, "textBody");
                    String textEnd = formatter.formatAsTextStylingField(variableIndex, "textEnd");
                    parent.setContentBeforeStartTagElement(Directive.formatDirective(setVariableDirective + " " + textBefore, handler.getStartNoParse(), handler.getEndNoParse()));
                    parent.setContentAfterEndTagElement(Directive.formatDirective(textEnd, handler.getStartNoParse(), handler.getEndNoParse()));
                    directive = Directive.formatDirective(textBody, handler.getStartNoParse(), handler.getEndNoParse());
                    parent.put(key, directive);
                    return directive;
                }
                return Directive.formatDirective(fieldName, handler.getStartNoParse(), handler.getEndNoParse());
            }
        }
        return null;
    }

    public BufferedElement getTRegion(int index) {
        return super.findChildAt("w:t", index);
    }
}

