/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core;

import fr.opensagres.poi.xwpf.converter.core.IImageExtractor;
import fr.opensagres.poi.xwpf.converter.core.IMasterPageHandler;
import fr.opensagres.poi.xwpf.converter.core.IXWPFMasterPage;
import fr.opensagres.poi.xwpf.converter.core.ListContext;
import fr.opensagres.poi.xwpf.converter.core.ListItemContext;
import fr.opensagres.poi.xwpf.converter.core.MasterPageManager;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFRunHelper;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFTableUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.ISDTContent;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlink;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlTokenSource;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTWrapSquare;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRunTrackChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtContentRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSmartTagRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.HdrDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.xml.sax.SAXException;

public abstract class XWPFDocumentVisitor<T, O extends Options, E extends IXWPFMasterPage>
implements IMasterPageHandler<E> {
    private static final Logger LOGGER = Logger.getLogger(XWPFDocumentVisitor.class.getName());
    protected static final String WORD_MEDIA = "word/media/";
    protected final XWPFDocument document;
    private final MasterPageManager masterPageManager;
    private XWPFHeader currentHeader;
    private XWPFFooter currentFooter;
    protected final XWPFStylesDocument stylesDocument;
    protected final O options;
    private boolean pageBreakOnNextParagraph;
    protected boolean processingTotalPageCountField = false;
    protected boolean totalPageFieldUsed = false;
    private Map<Integer, ListContext> listContextMap;

    public XWPFDocumentVisitor(XWPFDocument document, O options) throws Exception {
        this.document = document;
        this.options = options;
        this.stylesDocument = this.createStylesDocument(document);
        this.masterPageManager = new MasterPageManager(document.getDocument(), this);
    }

    protected XWPFStylesDocument createStylesDocument(XWPFDocument document) throws XmlException, IOException {
        return new XWPFStylesDocument(document);
    }

    @Override
    public XWPFStylesDocument getStylesDocument() {
        return this.stylesDocument;
    }

    public O getOptions() {
        return this.options;
    }

    public MasterPageManager getMasterPageManager() {
        return this.masterPageManager;
    }

    public void start() throws Exception {
        T container = this.startVisitDocument();
        List bodyElements = this.document.getBodyElements();
        this.visitBodyElements(bodyElements, container);
        this.endVisitDocument();
    }

    protected abstract T startVisitDocument() throws Exception;

    protected abstract void endVisitDocument() throws Exception;

    protected void visitBodyElements(List<IBodyElement> bodyElements, T container) throws Exception {
        if (!this.masterPageManager.isInitialized()) {
            this.masterPageManager.initialize();
        }
        Object previousParagraphStyleName = null;
        block5: for (int i = 0; i < bodyElements.size(); ++i) {
            IBodyElement bodyElement = bodyElements.get(i);
            switch (bodyElement.getElementType()) {
                case PARAGRAPH: {
                    XWPFParagraph paragraph = (XWPFParagraph)bodyElement;
                    String paragraphStyleName = paragraph.getStyleID();
                    boolean sameStyleBelow = paragraphStyleName != null && paragraphStyleName.equals(previousParagraphStyleName);
                    this.visitParagraph(paragraph, i, container);
                    continue block5;
                }
                case TABLE: {
                    previousParagraphStyleName = null;
                    this.visitTable((XWPFTable)bodyElement, i, container);
                    continue block5;
                }
                case CONTENTCONTROL: {
                    this.visitSDT((XWPFSDT)bodyElement, i, container);
                }
            }
        }
    }

    protected void visitSDT(XWPFSDT contents, int index, T container) throws Exception {
        T sdtContainer = this.startVisitSDT(contents, container);
        this.visitSDTBody(contents, sdtContainer);
        this.endVisitSDT(contents, container, sdtContainer);
    }

    protected abstract T startVisitSDT(XWPFSDT var1, T var2) throws SAXException;

    protected abstract void endVisitSDT(XWPFSDT var1, T var2, T var3) throws SAXException;

    protected void visitSDTBody(XWPFSDT contents, T sdtContainer) throws Exception {
        ISDTContent content = contents.getContent();
        try {
            Field bodyElements = content.getClass().getDeclaredField("bodyElements");
            bodyElements.setAccessible(true);
            List isdtContents = (List)bodyElements.get(content);
            for (int i = 0; i < isdtContents.size(); ++i) {
                ISDTContents isdtContent = (ISDTContents)isdtContents.get(i);
                if (isdtContent instanceof XWPFParagraph) {
                    this.visitParagraph((XWPFParagraph)isdtContent, i, sdtContainer);
                    continue;
                }
                if (isdtContent instanceof XWPFTable) {
                    this.visitTable((XWPFTable)isdtContent, i, sdtContainer);
                    continue;
                }
                if (isdtContent instanceof XWPFRun) {
                    this.visitRun((XWPFParagraph)((XWPFRun)isdtContent).getParent(), (XmlObject)isdtContent, sdtContainer);
                    continue;
                }
                if (!(isdtContent instanceof XWPFSDT)) continue;
                this.visitSDT((XWPFSDT)isdtContent, i, sdtContainer);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void visitParagraph(XWPFParagraph paragraph, int index, T container) throws Exception {
        XWPFNum num;
        if (this.isWordDocumentPartParsing()) {
            this.masterPageManager.update(paragraph.getCTP());
        }
        if (this.pageBreakOnNextParagraph) {
            this.pageBreak();
        }
        this.pageBreakOnNextParagraph = false;
        ListItemContext itemContext = null;
        CTNumPr originalNumPr = this.stylesDocument.getParagraphNumPr(paragraph);
        CTNumPr numPr = this.getNumPr(originalNumPr);
        if (numPr != null && (num = this.getXWPFNum(numPr)) != null) {
            XWPFAbstractNum abstractNum = this.getXWPFAbstractNum(num);
            CTDecimalNumber ilvl = numPr.getIlvl();
            int level = ilvl != null ? ilvl.getVal().intValue() : 0;
            CTLvl lvl = abstractNum.getAbstractNum().getLvlArray(level);
            if (lvl != null) {
                ListContext listContext = this.getListContext(originalNumPr.getNumId().getVal().intValue());
                itemContext = listContext.addItem(lvl);
            }
        }
        T paragraphContainer = this.startVisitParagraph(paragraph, itemContext, container);
        this.visitParagraphBody(paragraph, index, paragraphContainer);
        this.endVisitParagraph(paragraph, container, paragraphContainer);
    }

    private CTNumPr getNumPr(CTNumPr numPr) {
        XWPFNum num;
        if (numPr != null && (num = this.getXWPFNum(numPr)) != null) {
            String styleId;
            XWPFAbstractNum abstractNum = this.getXWPFAbstractNum(num);
            CTString numStyleLink = abstractNum.getAbstractNum().getNumStyleLink();
            String string = styleId = numStyleLink != null ? numStyleLink.getVal() : null;
            if (styleId != null) {
                CTStyle style = this.stylesDocument.getStyle(styleId);
                CTPPr ppr = style.getPPr();
                if (ppr == null) {
                    return null;
                }
                return this.getNumPr(ppr.getNumPr());
            }
        }
        return numPr;
    }

    private ListContext getListContext(int numId) {
        ListContext listContext;
        if (this.listContextMap == null) {
            this.listContextMap = new HashMap<Integer, ListContext>();
        }
        if ((listContext = this.listContextMap.get(numId)) == null) {
            listContext = new ListContext();
            this.listContextMap.put(numId, listContext);
        }
        return listContext;
    }

    protected abstract T startVisitParagraph(XWPFParagraph var1, ListItemContext var2, T var3) throws Exception;

    protected abstract void endVisitParagraph(XWPFParagraph var1, T var2, T var3) throws Exception;

    protected void visitParagraphBody(XWPFParagraph paragraph, int index, T paragraphContainer) throws Exception {
        CTOnOff pageBreak;
        CTPPr ppr;
        List runs = paragraph.getRuns();
        if (runs.isEmpty()) {
            if (this.isAddNewLine(paragraph, index)) {
                this.visitEmptyRun(paragraphContainer);
            }
        } else {
            this.visitRuns(paragraph, paragraphContainer);
        }
        if ((ppr = paragraph.getCTP().getPPr()) != null && ppr.isSetPageBreakBefore() && (pageBreak = ppr.getPageBreakBefore()) != null && (pageBreak.getVal() == null || pageBreak.getVal().intValue() == 1)) {
            this.pageBreak();
        }
    }

    protected XWPFNum getXWPFNum(CTNumPr numPr) {
        CTDecimalNumber numID = numPr.getNumId();
        if (numID == null) {
            return null;
        }
        XWPFNum num = this.document.getNumbering().getNum(numID.getVal());
        return num;
    }

    protected XWPFAbstractNum getXWPFAbstractNum(XWPFNum num) {
        CTDecimalNumber abstractNumID = num.getCTNum().getAbstractNumId();
        XWPFAbstractNum abstractNum = this.document.getNumbering().getAbstractNum(abstractNumID.getVal());
        return abstractNum;
    }

    private boolean isAddNewLine(XWPFParagraph paragraph, int index) {
        IBody body = paragraph.getBody();
        List bodyElements = body.getBodyElements();
        if (body.getPartType() == BodyType.TABLECELL && bodyElements.size() == 1) {
            XWPFTableCell cell = (XWPFTableCell)body;
            STMerge.Enum vMerge = this.stylesDocument.getTableCellVMerge(cell);
            if (vMerge != null && vMerge.equals(STMerge.CONTINUE)) {
                return false;
            }
            XWPFTableRow row = cell.getTableRow();
            List cells = row.getTableCells();
            Iterator i$ = cells.iterator();
            if (i$.hasNext()) {
                XWPFTableCell c = (XWPFTableCell)i$.next();
                if (c.getBodyElements().size() != 1) {
                    return false;
                }
                IBodyElement element = (IBodyElement)c.getBodyElements().get(0);
                if (element.getElementType() != BodyElementType.PARAGRAPH) {
                    return false;
                }
                return ((XWPFParagraph)element).getRuns().size() == 0;
            }
            return true;
        }
        return bodyElements.size() > index + 1;
    }

    private void visitRuns(XWPFParagraph paragraph, T paragraphContainer) throws Exception {
        boolean fldCharTypeParsing = false;
        boolean pageNumber = false;
        String url = null;
        ArrayList<CTR> rListAfterSeparate = null;
        CTP ctp = paragraph.getCTP();
        XmlCursor c = ctp.newCursor();
        c.selectPath("child::*");
        while (c.toNextSelection()) {
            XmlObject o = c.getObject();
            if (o instanceof CTR) {
                CTR r = (CTR)o;
                STFldCharType.Enum fldCharType = XWPFRunHelper.getFldCharType(r);
                if (fldCharType != null) {
                    if (fldCharType.equals(STFldCharType.BEGIN)) {
                        this.process(paragraph, paragraphContainer, pageNumber, url, (List<XmlObject>)rListAfterSeparate);
                        fldCharTypeParsing = true;
                        rListAfterSeparate = new ArrayList<CTR>();
                        pageNumber = false;
                        url = null;
                        continue;
                    }
                    if (!fldCharType.equals(STFldCharType.END)) continue;
                    this.process(paragraph, paragraphContainer, pageNumber, url, (List<XmlObject>)rListAfterSeparate);
                    fldCharTypeParsing = false;
                    rListAfterSeparate = null;
                    pageNumber = false;
                    this.processingTotalPageCountField = false;
                    url = null;
                    continue;
                }
                if (fldCharTypeParsing) {
                    String instrText = XWPFRunHelper.getInstrText(r);
                    if (instrText != null) {
                        if (!StringUtils.isNotEmpty(instrText)) continue;
                        boolean instrTextPage = XWPFRunHelper.isInstrTextPage(instrText);
                        if (!instrTextPage) {
                            String instrTextHyperlink;
                            this.processingTotalPageCountField = XWPFRunHelper.isInstrTextNumpages(instrText);
                            if (!this.totalPageFieldUsed) {
                                this.totalPageFieldUsed = true;
                            }
                            if ((instrTextHyperlink = XWPFRunHelper.getInstrTextHyperlink(instrText)) == null) continue;
                            if (instrTextHyperlink.startsWith("\\l ")) {
                                url = "#" + instrTextHyperlink.substring(3);
                                continue;
                            }
                            url = instrTextHyperlink;
                            continue;
                        }
                        pageNumber = true;
                        continue;
                    }
                    rListAfterSeparate.add(r);
                    continue;
                }
                XWPFRun run = new XWPFRun(r, paragraph);
                this.visitRun(run, false, null, paragraphContainer);
                continue;
            }
            if (fldCharTypeParsing) {
                rListAfterSeparate.add((CTR)o);
                continue;
            }
            this.visitRun(paragraph, o, paragraphContainer);
        }
        c.dispose();
        this.process(paragraph, paragraphContainer, pageNumber, url, rListAfterSeparate);
        fldCharTypeParsing = false;
        rListAfterSeparate = null;
        pageNumber = false;
        url = null;
    }

    private void process(XWPFParagraph paragraph, T paragraphContainer, boolean pageNumber, String url, List<XmlObject> rListAfterSeparate) throws Exception {
        if (rListAfterSeparate != null) {
            for (XmlObject oAfterSeparate : rListAfterSeparate) {
                if (oAfterSeparate instanceof CTR) {
                    CTR ctr = (CTR)oAfterSeparate;
                    XWPFRun run = new XWPFRun(ctr, paragraph);
                    this.visitRun(run, pageNumber, url, paragraphContainer);
                    continue;
                }
                this.visitRun(paragraph, oAfterSeparate, paragraphContainer);
            }
        }
    }

    private void visitRun(XWPFParagraph paragraph, XmlObject o, T paragraphContainer) throws Exception {
        if (o instanceof CTHyperlink) {
            CTHyperlink link = (CTHyperlink)o;
            String anchor = link.getAnchor();
            String href = null;
            String hyperlinkId = link.getId();
            if (StringUtils.isNotEmpty(hyperlinkId)) {
                XWPFHyperlink hyperlink = this.document.getHyperlinkByID(hyperlinkId);
                href = hyperlink != null ? hyperlink.getURL() : null;
            }
            for (CTR r : link.getRList()) {
                XWPFHyperlinkRun run = new XWPFHyperlinkRun(link, r, (IRunBody)paragraph);
                this.visitRun((XWPFRun)run, false, href != null ? href : "#" + anchor, paragraphContainer);
            }
        } else if (o instanceof CTSdtRun) {
            CTSdtContentRun run = ((CTSdtRun)o).getSdtContent();
            for (CTR r : run.getRList()) {
                XWPFRun ru = new XWPFRun(r, paragraph);
                this.visitRun(ru, false, null, paragraphContainer);
            }
        } else if (o instanceof CTRunTrackChange) {
            for (CTR r : ((CTRunTrackChange)o).getRList()) {
                XWPFRun run = new XWPFRun(r, paragraph);
                this.visitRun(run, false, null, paragraphContainer);
            }
        } else if (o instanceof CTSimpleField) {
            CTSimpleField simpleField = (CTSimpleField)o;
            String instr = simpleField.getInstr();
            boolean fieldPageNumber = XWPFRunHelper.isInstrTextPage(instr);
            String fieldHref = null;
            if (!fieldPageNumber) {
                fieldHref = XWPFRunHelper.getInstrTextHyperlink(instr);
            }
            for (CTR r : simpleField.getRList()) {
                XWPFRun run = new XWPFRun(r, paragraph);
                this.visitRun(run, fieldPageNumber, fieldHref, paragraphContainer);
            }
        } else if (!(o instanceof CTSmartTagRun) && o instanceof CTBookmark) {
            CTBookmark bookmark = (CTBookmark)o;
            this.visitBookmark(bookmark, paragraph, paragraphContainer);
        }
    }

    protected abstract void visitEmptyRun(T var1) throws Exception;

    protected void visitRun(XWPFRun run, boolean pageNumber, String url, T paragraphContainer) throws Exception {
        CTR ctr = run.getCTR();
        CTRPr rPr = ctr.getRPr();
        boolean hasTexStyles = rPr != null && (rPr.getHighlight() != null || rPr.getStrike() != null || rPr.getDstrike() != null || rPr.getVertAlign() != null);
        StringBuilder text = new StringBuilder();
        XmlCursor c = ctr.newCursor();
        c.selectPath("./*");
        while (c.toNextSelection()) {
            XmlObject o = c.getObject();
            if (o instanceof CTText) {
                CTText ctText = (CTText)o;
                String tagName = o.getDomNode().getNodeName();
                if ("w:instrText".equals(tagName)) continue;
                if (hasTexStyles) {
                    text.append(ctText.getStringValue());
                    continue;
                }
                this.visitText(ctText, pageNumber, paragraphContainer);
                continue;
            }
            if (o instanceof CTPTab) {
                this.visitTab((CTPTab)o, paragraphContainer);
                continue;
            }
            if (o instanceof CTBr) {
                this.visitBR((CTBr)o, paragraphContainer);
                continue;
            }
            if (o instanceof CTEmpty) {
                String tagName = o.getDomNode().getNodeName();
                if ("w:tab".equals(tagName)) {
                    CTTabs tabs = this.stylesDocument.getParagraphTabs(run.getParagraph());
                    this.visitTabs(tabs, paragraphContainer);
                }
                if ("w:br".equals(tagName)) {
                    this.visitBR(null, paragraphContainer);
                }
                if (!"w:cr".equals(tagName)) continue;
                this.visitBR(null, paragraphContainer);
                continue;
            }
            if (!(o instanceof CTDrawing)) continue;
            this.visitDrawing((CTDrawing)o, paragraphContainer);
        }
        if (hasTexStyles && StringUtils.isNotEmpty(text.toString())) {
            this.visitStyleText(run, text.toString());
        }
        c.dispose();
    }

    protected void visitStyleText(XWPFRun run, String text) throws Exception {
    }

    protected abstract void visitText(CTText var1, boolean var2, T var3) throws Exception;

    protected abstract void visitTab(CTPTab var1, T var2) throws Exception;

    protected abstract void visitTabs(CTTabs var1, T var2) throws Exception;

    protected void visitBR(CTBr br, T paragraphContainer) throws Exception {
        STBrType.Enum brType = XWPFRunHelper.getBrType(br);
        if (brType.equals(STBrType.PAGE)) {
            this.pageBreakOnNextParagraph = true;
        } else {
            this.addNewLine(br, paragraphContainer);
        }
    }

    protected abstract void visitBookmark(CTBookmark var1, XWPFParagraph var2, T var3) throws Exception;

    protected abstract void addNewLine(CTBr var1, T var2) throws Exception;

    protected abstract void pageBreak() throws Exception;

    protected void visitTable(XWPFTable table, int index, T container) throws Exception {
        float[] colWidths = XWPFTableUtil.computeColWidths(table);
        T tableContainer = this.startVisitTable(table, colWidths, container);
        this.visitTableBody(table, colWidths, tableContainer);
        this.endVisitTable(table, container, tableContainer);
    }

    protected void visitTableBody(XWPFTable table, float[] colWidths, T tableContainer) throws Exception {
        boolean firstRow = false;
        boolean lastRow = false;
        List rows = table.getRows();
        int rowsSize = rows.size();
        for (int i = 0; i < rowsSize; ++i) {
            firstRow = i == 0;
            lastRow = this.isLastRow(i, rowsSize);
            XWPFTableRow row = (XWPFTableRow)rows.get(i);
            this.visitTableRow(row, colWidths, tableContainer, firstRow, lastRow, i, rowsSize);
        }
    }

    private boolean isLastRow(int rowIndex, int rowsSize) {
        return rowIndex == rowsSize - 1;
    }

    protected abstract T startVisitTable(XWPFTable var1, float[] var2, T var3) throws Exception;

    protected abstract void endVisitTable(XWPFTable var1, T var2, T var3) throws Exception;

    protected void visitTableRow(XWPFTableRow row, float[] colWidths, T tableContainer, boolean firstRow, boolean lastRowIfNoneVMerge, int rowIndex, int rowsSize) throws Exception {
        boolean headerRow = this.stylesDocument.isTableRowHeader(row);
        this.startVisitTableRow(row, tableContainer, rowIndex, headerRow);
        int nbColumns = colWidths.length;
        boolean firstCol = true;
        boolean lastCol = false;
        boolean lastRow = false;
        List<XWPFTableCell> vMergedCells = null;
        List cells = row.getTableCells();
        if (nbColumns > cells.size()) {
            firstCol = true;
            int cellIndex = -1;
            int cellPtr = 0;
            CTRow ctRow = row.getCtRow();
            XmlCursor c = ctRow.newCursor();
            c.selectPath("./*");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (o instanceof CTTc) {
                    CTTc tc = (CTTc)o;
                    XWPFTableCell cell = row.getTableCell(tc);
                    lastCol = (cellIndex = this.getCellIndex(cellIndex, cell)) == nbColumns;
                    vMergedCells = this.getVMergedCells(cell, rowIndex, cellPtr);
                    if (vMergedCells == null || vMergedCells.size() > 0) {
                        lastRow = this.isLastRow(lastRowIfNoneVMerge, rowIndex, rowsSize, vMergedCells);
                        this.visitCell(cell, tableContainer, firstRow, lastRow, firstCol, lastCol, rowIndex, cellPtr, vMergedCells);
                    }
                    ++cellPtr;
                    firstCol = false;
                    continue;
                }
                if (!(o instanceof CTSdtCell)) continue;
                CTSdtCell sdtCell = (CTSdtCell)o;
                List tcList = sdtCell.getSdtContent().getTcList();
                for (CTTc ctTc : tcList) {
                    XWPFTableCell cell = new XWPFTableCell(ctTc, row, row.getTable().getBody());
                    lastCol = (cellIndex = this.getCellIndex(cellIndex, cell)) == nbColumns;
                    List rowCells = row.getTableCells();
                    if (!rowCells.contains(cell)) {
                        rowCells.add(cell);
                    }
                    if ((vMergedCells = this.getVMergedCells(cell, rowIndex, cellPtr)) == null || vMergedCells.size() > 0) {
                        lastRow = this.isLastRow(lastRowIfNoneVMerge, rowIndex, rowsSize, vMergedCells);
                        this.visitCell(cell, tableContainer, firstRow, lastRow, firstCol, lastCol, rowIndex, cellPtr, vMergedCells);
                    }
                    ++cellPtr;
                    firstCol = false;
                }
            }
            c.dispose();
        } else {
            for (int i = 0; i < cells.size(); ++i) {
                lastCol = i == cells.size() - 1;
                XWPFTableCell cell = (XWPFTableCell)cells.get(i);
                vMergedCells = this.getVMergedCells(cell, rowIndex, i);
                if (vMergedCells == null || vMergedCells.size() > 0) {
                    lastRow = this.isLastRow(lastRowIfNoneVMerge, rowIndex, rowsSize, vMergedCells);
                    this.visitCell(cell, tableContainer, firstRow, lastRow, firstCol, lastCol, rowIndex, i, vMergedCells);
                }
                firstCol = false;
            }
        }
        this.endVisitTableRow(row, tableContainer, firstRow, lastRow, headerRow);
    }

    private boolean isLastRow(boolean lastRowIfNoneVMerge, int rowIndex, int rowsSize, List<XWPFTableCell> vMergedCells) {
        if (vMergedCells == null) {
            return lastRowIfNoneVMerge;
        }
        return this.isLastRow(rowIndex - 1 + vMergedCells.size(), rowsSize);
    }

    private int getCellIndex(int cellIndex, XWPFTableCell cell) {
        BigInteger gridSpan = this.stylesDocument.getTableCellGridSpan(cell.getCTTc().getTcPr());
        cellIndex = gridSpan != null ? (cellIndex += gridSpan.intValue()) : ++cellIndex;
        return cellIndex;
    }

    protected void startVisitTableRow(XWPFTableRow row, T tableContainer, int rowIndex, boolean headerRow) throws Exception {
    }

    protected void endVisitTableRow(XWPFTableRow row, T tableContainer, boolean firstRow, boolean lastRow, boolean headerRow) throws Exception {
    }

    protected void visitCell(XWPFTableCell cell, T tableContainer, boolean firstRow, boolean lastRow, boolean firstCol, boolean lastCol, int rowIndex, int cellIndex, List<XWPFTableCell> vMergedCells) throws Exception {
        T tableCellContainer = this.startVisitTableCell(cell, tableContainer, firstRow, lastRow, firstCol, lastCol, vMergedCells);
        this.visitTableCellBody(cell, vMergedCells, tableCellContainer);
        this.endVisitTableCell(cell, tableContainer, tableCellContainer);
    }

    private List<XWPFTableCell> getVMergedCells(XWPFTableCell cell, int rowIndex, int cellIndex) {
        ArrayList<XWPFTableCell> vMergedCells = null;
        STMerge.Enum vMerge = this.stylesDocument.getTableCellVMerge(cell);
        if (vMerge != null) {
            if (vMerge.equals(STMerge.RESTART)) {
                XWPFTableCell c;
                vMergedCells = new ArrayList<XWPFTableCell>();
                vMergedCells.add(cell);
                XWPFTableRow row = null;
                XWPFTable table = cell.getTableRow().getTable();
                for (int i = rowIndex + 1; i < table.getRows().size() && (c = (row = table.getRow(i)).getCell(cellIndex)) != null; ++i) {
                    vMerge = this.stylesDocument.getTableCellVMerge(c);
                    if (vMerge == null || !vMerge.equals(STMerge.CONTINUE)) {
                        return vMergedCells;
                    }
                    vMergedCells.add(c);
                }
            } else {
                return Collections.emptyList();
            }
        }
        return vMergedCells;
    }

    protected void visitTableCellBody(XWPFTableCell cell, List<XWPFTableCell> vMergeCells, T tableCellContainer) throws Exception {
        if (vMergeCells != null) {
            for (XWPFTableCell mergedCell : vMergeCells) {
                List bodyElements = mergedCell.getBodyElements();
                this.visitBodyElements(bodyElements, tableCellContainer);
            }
        } else {
            List bodyElements = cell.getBodyElements();
            this.visitBodyElements(bodyElements, tableCellContainer);
        }
    }

    protected abstract T startVisitTableCell(XWPFTableCell var1, T var2, boolean var3, boolean var4, boolean var5, boolean var6, List<XWPFTableCell> var7) throws Exception;

    protected abstract void endVisitTableCell(XWPFTableCell var1, T var2, T var3) throws Exception;

    protected XWPFStyle getXWPFStyle(String styleID) {
        if (styleID == null) {
            return null;
        }
        return this.document.getStyles().getStyle(styleID);
    }

    protected boolean isWordDocumentPartParsing() {
        return this.currentHeader == null && this.currentFooter == null;
    }

    @Override
    public void visitHeaderRef(CTHdrFtrRef headerRef, CTSectPr sectPr, E masterPage) throws Exception {
        this.currentHeader = this.getXWPFHeader(headerRef);
        this.visitHeader(this.currentHeader, headerRef, sectPr, masterPage);
        this.currentHeader = null;
    }

    protected abstract void visitHeader(XWPFHeader var1, CTHdrFtrRef var2, CTSectPr var3, E var4) throws Exception;

    @Override
    public void visitFooterRef(CTHdrFtrRef footerRef, CTSectPr sectPr, E masterPage) throws Exception {
        this.currentFooter = this.getXWPFFooter(footerRef);
        this.visitFooter(this.currentFooter, footerRef, sectPr, masterPage);
        this.currentFooter = null;
    }

    protected abstract void visitFooter(XWPFFooter var1, CTHdrFtrRef var2, CTSectPr var3, E var4) throws Exception;

    protected List<IBodyElement> getBodyElements(XWPFHeaderFooter part) {
        ArrayList<IBodyElement> bodyElements = new ArrayList<IBodyElement>();
        CTHdrFtr headerFooter = part._getHdrFtr();
        this.addBodyElements((XmlTokenSource)headerFooter, (IBody)part, bodyElements);
        return bodyElements;
    }

    private void addBodyElements(XmlTokenSource source, IBody part, List<IBodyElement> bodyElements) {
        XmlCursor cursor = source.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o = cursor.getObject();
            if (o instanceof CTSdtBlock) {
                CTSdtBlock block = (CTSdtBlock)o;
                CTSdtContentBlock contentBlock = block.getSdtContent();
                if (contentBlock == null) continue;
                this.addBodyElements((XmlTokenSource)contentBlock, part, bodyElements);
                continue;
            }
            if (o instanceof CTP) {
                XWPFParagraph p = new XWPFParagraph((CTP)o, part);
                bodyElements.add((IBodyElement)p);
                continue;
            }
            if (!(o instanceof CTTbl)) continue;
            XWPFTable t = new XWPFTable((CTTbl)o, part);
            bodyElements.add((IBodyElement)t);
        }
        cursor.dispose();
    }

    protected XWPFHeader getXWPFHeader(CTHdrFtrRef headerRef) throws XmlException, IOException {
        PackagePart hdrPart = this.document.getPartById(headerRef.getId());
        List headers = this.document.getHeaderList();
        for (XWPFHeader header : headers) {
            if (!header.getPackagePart().equals(hdrPart)) continue;
            return header;
        }
        HdrDocument hdrDoc = HdrDocument.Factory.parse((InputStream)hdrPart.getInputStream());
        CTHdrFtr hdrFtr = hdrDoc.getHdr();
        XWPFHeader hdr = new XWPFHeader(this.document, hdrFtr);
        return hdr;
    }

    protected XWPFFooter getXWPFFooter(CTHdrFtrRef footerRef) throws XmlException, IOException {
        PackagePart hdrPart = this.document.getPartById(footerRef.getId());
        List footers = this.document.getFooterList();
        for (XWPFFooter footer : footers) {
            if (!footer.getPackagePart().equals(hdrPart)) continue;
            return footer;
        }
        FtrDocument hdrDoc = FtrDocument.Factory.parse((InputStream)hdrPart.getInputStream());
        CTHdrFtr hdrFtr = hdrDoc.getFtr();
        XWPFFooter ftr = new XWPFFooter(this.document, hdrFtr);
        return ftr;
    }

    protected void visitDrawing(CTDrawing drawing, T parentContainer) throws Exception {
        List inlines = drawing.getInlineList();
        for (CTInline inline : inlines) {
            this.visitInline(inline, parentContainer);
        }
        List anchors = drawing.getAnchorList();
        for (CTAnchor anchor : anchors) {
            this.visitAnchor(anchor, parentContainer);
        }
    }

    protected void visitAnchor(CTAnchor anchor, T parentContainer) throws Exception {
        CTGraphicalObject graphic = anchor.getGraphic();
        STRelFromH.Enum relativeFromH = null;
        Float offsetX = null;
        CTPosH positionH = anchor.getPositionH();
        if (positionH != null) {
            relativeFromH = positionH.getRelativeFrom();
            offsetX = Float.valueOf(DxaUtil.emu2points(positionH.getPosOffset()));
        }
        STRelFromV.Enum relativeFromV = null;
        Float offsetY = null;
        CTPosV positionV = anchor.getPositionV();
        if (positionV != null) {
            relativeFromV = positionV.getRelativeFrom();
            offsetY = Float.valueOf(DxaUtil.emu2points(positionV.getPosOffset()));
        }
        STWrapText.Enum wrapText = null;
        CTWrapSquare wrapSquare = anchor.getWrapSquare();
        if (wrapSquare != null) {
            wrapText = wrapSquare.getWrapText();
        }
        this.visitGraphicalObject(parentContainer, graphic, offsetX, relativeFromH, offsetY, relativeFromV, wrapText);
    }

    protected void visitInline(CTInline inline, T parentContainer) throws Exception {
        CTGraphicalObject graphic = inline.getGraphic();
        this.visitGraphicalObject(parentContainer, graphic, null, null, null, null, null);
    }

    private void visitGraphicalObject(T parentContainer, CTGraphicalObject graphic, Float offsetX, STRelFromH.Enum relativeFromH, Float offsetY, STRelFromV.Enum relativeFromV, STWrapText.Enum wrapText) throws Exception {
        CTGraphicalObjectData graphicData;
        if (graphic != null && (graphicData = graphic.getGraphicData()) != null) {
            XmlCursor c = graphicData.newCursor();
            c.selectPath("./*");
            while (c.toNextSelection()) {
                XWPFPictureData pictureData;
                XmlObject o = c.getObject();
                if (!(o instanceof CTPicture)) continue;
                CTPicture picture = (CTPicture)o;
                IImageExtractor extractor = this.getImageExtractor();
                if (extractor != null && (pictureData = this.getPictureData(picture)) != null) {
                    try {
                        extractor.extract(WORD_MEDIA + pictureData.getFileName(), pictureData.getData());
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.SEVERE, "Error while extracting the image " + pictureData.getFileName(), e);
                    }
                }
                this.visitPicture(picture, offsetX, relativeFromH, offsetY, relativeFromV, wrapText, parentContainer);
            }
            c.dispose();
        }
    }

    protected XWPFPictureData getPictureDataByID(String blipId) {
        if (this.currentHeader != null) {
            return this.currentHeader.getPictureDataByID(blipId);
        }
        if (this.currentFooter != null) {
            return this.currentFooter.getPictureDataByID(blipId);
        }
        return this.document.getPictureDataByID(blipId);
    }

    protected IImageExtractor getImageExtractor() {
        return ((Options)this.options).getExtractor();
    }

    public XWPFPictureData getPictureData(CTPicture picture) {
        String blipId = picture.getBlipFill().getBlip().getEmbed();
        return this.getPictureDataByID(blipId);
    }

    protected abstract void visitPicture(CTPicture var1, Float var2, STRelFromH.Enum var3, Float var4, STRelFromV.Enum var5, STWrapText.Enum var6, T var7) throws Exception;
}

