/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class SXSSFRow
implements Row {
    SXSSFSheet _sheet;
    SXSSFCell[] _cells;
    int _maxColumn = -1;
    short _style = (short)-1;
    short _height = (short)-1;
    boolean _zHeight = false;
    int _outlineLevel = 0;
    Boolean _hidden;
    Boolean _collapsed;

    public SXSSFRow(SXSSFSheet sheet, int initialSize) {
        this._sheet = sheet;
        this._cells = new SXSSFCell[initialSize];
    }

    public Iterator<Cell> allCellsIterator() {
        return new CellIterator();
    }

    public boolean hasCustomHeight() {
        return this._height != -1;
    }

    int getOutlineLevel() {
        return this._outlineLevel;
    }

    void setOutlineLevel(int level) {
        this._outlineLevel = level;
    }

    public Boolean getHidden() {
        return this._hidden;
    }

    public void setHidden(Boolean hidden) {
        this._hidden = hidden;
    }

    public Boolean getCollapsed() {
        return this._collapsed;
    }

    public void setCollapsed(Boolean collapsed) {
        this._collapsed = collapsed;
    }

    public Iterator<Cell> iterator() {
        return new FilledCellIterator();
    }

    public Cell createCell(int column) {
        return this.createCell(column, 3);
    }

    public Cell createCell(int column, int type) {
        SXSSFRow.checkBounds(column);
        if (column >= this._cells.length) {
            SXSSFCell[] newCells = new SXSSFCell[Math.max(column + 1, this._cells.length * 2)];
            System.arraycopy(this._cells, 0, newCells, 0, this._cells.length);
            this._cells = newCells;
        }
        this._cells[column] = new SXSSFCell(this, type);
        if (column > this._maxColumn) {
            this._maxColumn = column;
        }
        return this._cells[column];
    }

    private static void checkBounds(int cellIndex) {
        SpreadsheetVersion v = SpreadsheetVersion.EXCEL2007;
        int maxcol = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        if (cellIndex < 0 || cellIndex > maxcol) {
            throw new IllegalArgumentException("Invalid column index (" + cellIndex + ").  Allowable column range for " + v.name() + " is (0.." + maxcol + ") or ('A'..'" + v.getLastColumnName() + "')");
        }
    }

    public void removeCell(Cell cell) {
        int index = this.getCellIndex(cell);
        if (index >= 0) {
            this._cells[index] = null;
            while (this._maxColumn >= 0 && this._cells[this._maxColumn] == null) {
                --this._maxColumn;
            }
        }
    }

    int getCellIndex(Cell cell) {
        for (int i = 0; i <= this._maxColumn; ++i) {
            if (this._cells[i] != cell) continue;
            return i;
        }
        return -1;
    }

    public void setRowNum(int rowNum) {
        this._sheet.changeRowNum(this, rowNum);
    }

    public int getRowNum() {
        return this._sheet.getRowNum(this);
    }

    public Cell getCell(int cellnum) {
        if (cellnum < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        SXSSFCell cell = cellnum > this._maxColumn ? null : this._cells[cellnum];
        Row.MissingCellPolicy policy = this._sheet.getWorkbook().getMissingCellPolicy();
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell((short)cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    public Cell getCell(int cellnum, Row.MissingCellPolicy policy) {
        Cell cell = this.getCell(cellnum);
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell(cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + policy + " (" + policy.id + ")");
    }

    public short getFirstCellNum() {
        for (int i = 0; i <= this._maxColumn; ++i) {
            if (this._cells[i] == null) continue;
            return (short)i;
        }
        return -1;
    }

    public short getLastCellNum() {
        return this._maxColumn == -1 ? (short)-1 : (short)(this._maxColumn + 1);
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        for (int i = 0; i <= this._maxColumn; ++i) {
            if (this._cells[i] == null) continue;
            ++count;
        }
        return count;
    }

    public void setHeight(short height) {
        this._height = height;
    }

    public void setZeroHeight(boolean zHeight) {
        this._zHeight = zHeight;
    }

    public boolean getZeroHeight() {
        return this._zHeight;
    }

    public void setHeightInPoints(float height) {
        this._height = height == -1.0f ? (short)-1 : (short)(height * 20.0f);
    }

    public short getHeight() {
        return (short)(this._height == -1 ? this.getSheet().getDefaultRowHeightInPoints() * 20.0f : (float)this._height);
    }

    public float getHeightInPoints() {
        return (float)(this._height == -1 ? (double)this.getSheet().getDefaultRowHeightInPoints() : (double)this._height / 20.0);
    }

    public boolean isFormatted() {
        return this._style > -1;
    }

    public CellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        return this.getSheet().getWorkbook().getCellStyleAt(this._style);
    }

    public void setRowStyle(CellStyle style) {
        if (style == null) {
            this._style = (short)-1;
            return;
        }
        this._style = style.getIndex();
    }

    public Iterator<Cell> cellIterator() {
        return this.iterator();
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public class CellIterator
    implements Iterator<Cell> {
        int pos = 0;

        @Override
        public boolean hasNext() {
            return this.pos <= SXSSFRow.this._maxColumn;
        }

        @Override
        public Cell next() throws NoSuchElementException {
            if (this.hasNext()) {
                return SXSSFRow.this._cells[this.pos++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class FilledCellIterator
    implements Iterator<Cell> {
        int pos = 0;

        FilledCellIterator() {
            for (int i = 0; i <= SXSSFRow.this._maxColumn; ++i) {
                if (SXSSFRow.this._cells[i] == null) continue;
                this.pos = i;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos <= SXSSFRow.this._maxColumn;
        }

        void advanceToNext() {
            ++this.pos;
            while (this.pos <= SXSSFRow.this._maxColumn && SXSSFRow.this._cells[this.pos] == null) {
                ++this.pos;
            }
        }

        @Override
        public Cell next() throws NoSuchElementException {
            if (this.hasNext()) {
                SXSSFCell retval = SXSSFRow.this._cells[this.pos];
                this.advanceToNext();
                return retval;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

