/*
 * Decompiled with CFR 0.152.
 */
package org.quinto.swing.table.view;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;

public class PredefinedRowSorter<This extends PredefinedRowSorter<This>>
extends TableRowSorter<TableModel> {
    private static final Logger LOGGER = Logger.getLogger(PredefinedRowSorter.class);
    private static final RowSorter.SortKey[] EMPTY_ARRAY = new RowSorter.SortKey[0];
    private final JTable table;
    private RowSorter.SortKey[] preColumns = EMPTY_ARRAY;
    private RowSorter.SortKey[] postColumns = EMPTY_ARRAY;

    public PredefinedRowSorter(JTable table) {
        super(table.getModel());
        this.table = table;
    }

    private void check(RowSorter.SortKey[] modelColumns, RowSorter.SortKey[] crossCheckColumns, boolean post) {
        TableModel tm = this.table.getModel();
        int max = tm.getColumnCount();
        HashSet<Integer> used = new HashSet<Integer>();
        for (RowSorter.SortKey key : modelColumns) {
            if (key == null) {
                throw new IllegalArgumentException("SortKey must be non-null");
            }
            if (key.getColumn() < 0) {
                throw new IllegalArgumentException("SortKey column must be non-negative");
            }
            if (key.getColumn() >= max) {
                throw new IllegalArgumentException("SortKey column is too high (out of model scope)");
            }
            if (key.getSortOrder() == SortOrder.UNSORTED) {
                throw new IllegalArgumentException("SortKey must be ordered (ascending or descending)");
            }
            if (used.add(key.getColumn())) continue;
            throw new IllegalArgumentException("SortKey column must be unique (column " + key.getColumn() + " is repeating)");
        }
        for (RowSorter.SortKey key : crossCheckColumns) {
            if (!used.contains(key.getColumn())) continue;
            throw new IllegalArgumentException("SortKey column must be unique (column " + key.getColumn() + " is already contained in " + (post ? "post" : "pre") + " columns list)");
        }
    }

    public This withPreColumns(RowSorter.SortKey ... modelColumns) {
        if (modelColumns == null) {
            modelColumns = EMPTY_ARRAY;
        }
        if (!Arrays.equals(this.preColumns, modelColumns)) {
            this.check(modelColumns, this.postColumns, true);
            this.preColumns = modelColumns;
            this.setSortKeys(this.getSortKeys());
        }
        return (This)this;
    }

    public This withPostColumns(RowSorter.SortKey ... modelColumns) {
        if (modelColumns == null) {
            modelColumns = EMPTY_ARRAY;
        }
        if (!Arrays.equals(this.postColumns, modelColumns)) {
            this.check(modelColumns, this.preColumns, false);
            this.postColumns = modelColumns;
            this.setSortKeys(this.getSortKeys());
        }
        return (This)this;
    }

    public JTable getTable() {
        return this.table;
    }

    public RowSorter.SortKey[] getPreColumns() {
        return this.preColumns.length == 0 ? this.preColumns : (RowSorter.SortKey[])this.preColumns.clone();
    }

    public RowSorter.SortKey[] getPostColumns() {
        return this.postColumns.length == 0 ? this.postColumns : (RowSorter.SortKey[])this.postColumns.clone();
    }

    private void setSortKeysInternal(List<? extends RowSorter.SortKey> sortKeys) {
        try {
            Field field = DefaultRowSorter.class.getDeclaredField("sortKeys");
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(this, sortKeys);
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error(null, (Throwable)e);
        }
    }

    private Object getViewToModelInternal() {
        try {
            Field field = DefaultRowSorter.class.getDeclaredField("viewToModel");
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Object ret = field.get(this);
            if (!accessible) {
                field.setAccessible(false);
            }
            return ret;
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (SecurityException e) {
            LOGGER.error(null, (Throwable)e);
        }
        return null;
    }

    private void sortExistingDataInternal() {
        try {
            Method method = DefaultRowSorter.class.getDeclaredMethod("sortExistingData", new Class[0]);
            boolean accessible = method.isAccessible();
            if (!accessible) {
                method.setAccessible(true);
            }
            method.invoke((Object)this, new Object[0]);
            if (!accessible) {
                method.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(null, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(null, (Throwable)e);
            LOGGER.error(null, e.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        List<Object> newSortKeys;
        List<RowSorter.SortKey> oldSortKeys = this.getSortKeys();
        if (sortKeys != null && !sortKeys.isEmpty()) {
            int max = this.getModelWrapper().getColumnCount();
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < max) continue;
                throw new IllegalArgumentException("Invalid SortKey");
            }
            newSortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(sortKeys));
        } else {
            newSortKeys = Collections.emptyList();
        }
        this.setSortKeysInternal(newSortKeys);
        if (!newSortKeys.equals(oldSortKeys)) {
            this.fireSortOrderChanged();
            boolean wasChanged = false;
            if (this.preColumns.length > 0 || this.postColumns.length > 0) {
                void var6_7;
                ArrayList<RowSorter.SortKey> editableSortKeys = new ArrayList<RowSorter.SortKey>(newSortKeys);
                int n = this.preColumns.length - 1;
                while (var6_7 >= 0) {
                    int modelColumn = this.preColumns[var6_7].getColumn();
                    int idx = this.indexOfColumn(editableSortKeys, this.preColumns.length - var6_7 - 1, editableSortKeys.size(), modelColumn);
                    SortOrder sortOrder = idx < 0 ? this.preColumns[var6_7].getSortOrder() : ((RowSorter.SortKey)editableSortKeys.remove(idx)).getSortOrder();
                    editableSortKeys.add(0, new RowSorter.SortKey(modelColumn, sortOrder));
                    --var6_7;
                }
                int n2 = editableSortKeys.size();
                for (RowSorter.SortKey postColumn : this.postColumns) {
                    SortOrder sortOrder;
                    void var6_9;
                    int modelColumn = postColumn.getColumn();
                    int idx = this.indexOfColumn(editableSortKeys, this.preColumns.length, (int)var6_9, modelColumn);
                    if (idx < 0) {
                        sortOrder = postColumn.getSortOrder();
                    } else {
                        sortOrder = ((RowSorter.SortKey)editableSortKeys.remove(idx)).getSortOrder();
                        --var6_9;
                    }
                    editableSortKeys.add(new RowSorter.SortKey(modelColumn, sortOrder));
                }
                wasChanged = !editableSortKeys.equals(newSortKeys);
                if (wasChanged) {
                    this.setSortKeysInternal(editableSortKeys);
                }
            }
            if (this.getViewToModelInternal() == null) {
                this.sort();
            } else {
                this.sortExistingDataInternal();
            }
            if (wasChanged) {
                this.setSortKeysInternal(newSortKeys);
            }
        }
    }

    private int indexOfColumn(List<RowSorter.SortKey> sortKeys, int fromIncl, int toExcl, int column) {
        for (int i = toExcl - 1; i >= fromIncl; --i) {
            if (sortKeys.get(i).getColumn() != column) continue;
            return i;
        }
        return -1;
    }
}

