/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.odfdom.converter.internal.xhtml;

import fr.opensagres.odfdom.converter.core.AbstractStyleEngine;
import fr.opensagres.odfdom.converter.core.IURIResolver;
import fr.opensagres.odfdom.converter.core.utils.StringUtils;
import fr.opensagres.xdocreport.xhtml.extension.CSSStylePropertyConstants;
import fr.opensagres.xdocreport.xhtml.extension.CSSStyleSheet;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPageContentBuffer;
import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.w3c.dom.Node;

public class StyleEngineForXHTML
extends AbstractStyleEngine
implements XHTMLConstants,
CSSStylePropertyConstants {
    private static final String STYLE_NAME_HEADER = "Header";
    private static final String STYLE_NAME_FOOTER = "Footer";
    private CSSStyleSheet cssStyleSheet;
    private final boolean generateCSSComments;
    private final Map<String, String> classNamesMap = new HashMap<String, String>();
    private final IURIResolver resolver;

    public StyleEngineForXHTML(OdfDocument odfDocument, boolean generateCSSComments, int indent, IURIResolver resolver) {
        super(odfDocument);
        this.generateCSSComments = generateCSSComments;
        this.resolver = resolver;
        this.cssStyleSheet = new CSSStyleSheet(indent);
    }

    @Override
    public void visit(OfficeStylesElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:styles begin");
        }
        super.visit(ele);
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:styles end");
        }
    }

    @Override
    public void visit(OfficeAutomaticStylesElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:automatic-styles begin");
        }
        super.visit(ele);
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:automatic-styles end");
        }
    }

    @Override
    public void visit(OfficeMasterStylesElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:master-styles begin");
        }
        super.visit(ele);
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:master-styles end");
        }
    }

    @Override
    public void visit(StyleDefaultStyleElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:default-style @style:family=" + ele.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)ele));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:default-style @style:family=" + ele.getFamilyName() + " end");
        }
    }

    @Override
    public void visit(StyleStyleElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:style @style:name= " + ele.getStyleNameAttribute() + ", @style:family=" + ele.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)ele));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:style @style:name= " + ele.getStyleNameAttribute() + ", @style:family=" + ele.getFamilyName() + " end");
        }
    }

    public void visit(StylePageLayoutElement ele) {
        super.visit(ele);
    }

    public void visit(StylePageLayoutPropertiesElement ele) {
        String width;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String styleName = null;
        String styleFamilyName = null;
        StylePageLayoutElement styleBase = null;
        Node parentNode = ele.getParentNode();
        if (!(parentNode instanceof StylePageLayoutElement)) {
            return;
        }
        styleName = ((StylePageLayoutElement)parentNode).getStyleNameAttribute();
        styleFamilyName = ((StylePageLayoutElement)parentNode).getFamilyName();
        styleBase = (StylePageLayoutElement)parentNode;
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:page-layout-properties @style:page-layout-name= " + styleName + ", @style:family=" + styleFamilyName + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)styleBase));
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        if (StringUtils.isNotEmpty(width = ele.getFoPageWidthAttribute())) {
            this.cssStyleSheet.setCSSProperty("width", width);
        }
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:page-layout-properties @style:page-layout-name=" + styleName + ", @style:family=" + styleFamilyName + " end");
        }
    }

    public void visit(StyleHeaderStyleElement ele) {
        StylePageLayoutElement stylePageLayout = (StylePageLayoutElement)ele.getParentNode();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:header-style @style:page-layout-name=" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)stylePageLayout, STYLE_NAME_HEADER));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:header-style @style:page-layout-name" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " end");
        }
    }

    public void visit(StyleFooterStyleElement ele) {
        StylePageLayoutElement stylePageLayout = (StylePageLayoutElement)ele.getParentNode();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:footer-style @style:page-layout-name=" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)stylePageLayout, STYLE_NAME_FOOTER));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:footer-style @style:page-layout-name" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " end");
        }
    }

    public void visit(StyleHeaderFooterPropertiesElement ele) {
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String minHeight;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty(minHeight = ele.getFoMinHeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("min-height", minHeight);
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
    }

    @Override
    public void visit(StyleParagraphPropertiesElement ele) {
        String textIndent;
        String textAlign;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String lineHeight;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty(lineHeight = ele.getFoLineHeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("line-height", lineHeight);
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        if (StringUtils.isNotEmpty(textAlign = ele.getFoTextAlignAttribute())) {
            if ("start".equals(textAlign)) {
                textAlign = "left";
            } else if ("end".equals(textAlign)) {
                textAlign = "right";
            }
            this.cssStyleSheet.setCSSProperty("text-align", textAlign);
        }
        if (StringUtils.isNotEmpty(textIndent = ele.getFoTextIndentAttribute())) {
            this.cssStyleSheet.setCSSProperty("text-indent", textIndent);
        }
        super.visit(ele);
    }

    @Override
    public void visit(StyleTextPropertiesElement ele) {
        String underlineType;
        String underlineStyle;
        String fontWeight;
        String fontVariant;
        String fontStyle;
        String fontSize;
        String fontName;
        String fontFamily;
        String color;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(color = ele.getFoColorAttribute())) {
            this.cssStyleSheet.setCSSProperty("color", color);
        }
        if (StringUtils.isNotEmpty(fontFamily = ele.getFoFontFamilyAttribute())) {
            this.cssStyleSheet.setCSSProperty("font-family", "\"" + fontFamily + "\"");
        }
        if (StringUtils.isNotEmpty(fontName = ele.getStyleFontNameAttribute())) {
            this.cssStyleSheet.setCSSProperty("font-family", "\"" + fontName + "\"");
        }
        if (StringUtils.isNotEmpty(fontSize = ele.getFoFontSizeAttribute())) {
            this.cssStyleSheet.setCSSProperty("font-size", fontSize);
        }
        if (StringUtils.isNotEmpty(fontStyle = ele.getFoFontStyleAttribute())) {
            this.cssStyleSheet.setCSSProperty("font-style", fontStyle);
        }
        if (StringUtils.isNotEmpty(fontVariant = ele.getFoFontVariantAttribute())) {
            this.cssStyleSheet.setCSSProperty("font-variant", fontVariant);
        }
        if (StringUtils.isNotEmpty(fontWeight = ele.getFoFontWeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("font-weight", fontWeight);
        }
        if (StringUtils.isNotEmpty(underlineStyle = ele.getStyleTextUnderlineStyleAttribute()) && !underlineStyle.equals("none")) {
            this.cssStyleSheet.setCSSProperty("text-decoration", "underline");
        }
        if (StringUtils.isNotEmpty(underlineType = ele.getStyleTextUnderlineTypeAttribute()) && !underlineType.equals("none")) {
            this.cssStyleSheet.setCSSProperty("text-decoration", "underline");
        }
        super.visit(ele);
    }

    @Override
    public void visit(StyleTablePropertiesElement ele) {
        String width;
        String borderModel;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty(borderModel = ele.getTableBorderModelAttribute())) {
            if ("collapsing".equals(borderModel)) {
                this.cssStyleSheet.setCSSProperty("border-collapse", "collapse");
            } else {
                this.cssStyleSheet.setCSSProperty("border-collapse", "separate");
            }
        }
        if (StringUtils.isNotEmpty(width = ele.getStyleWidthAttribute())) {
            this.cssStyleSheet.setCSSProperty("width", width);
        }
        super.visit(ele);
    }

    public void visit(StyleTableColumnPropertiesElement ele) {
        String width = ele.getStyleColumnWidthAttribute();
        if (StringUtils.isNotEmpty(width)) {
            this.cssStyleSheet.setCSSProperty("width", width);
        }
        super.visit(ele);
    }

    public void visit(StyleTableRowPropertiesElement ele) {
        String height;
        String minHeight;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(minHeight = ele.getStyleMinRowHeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("min-height", minHeight);
        }
        if (StringUtils.isNotEmpty(height = ele.getStyleRowHeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("height", minHeight);
        }
        super.visit(ele);
    }

    @Override
    public void visit(StyleTableCellPropertiesElement ele) {
        String verticalAlign;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        if (StringUtils.isNotEmpty(verticalAlign = ele.getStyleVerticalAlignAttribute())) {
            this.cssStyleSheet.setCSSProperty("vertical-align", verticalAlign);
        }
        super.visit(ele);
    }

    public void visit(StyleGraphicPropertiesElement ele) {
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String minWidth;
        String minHeight;
        String maxWidth;
        String maxHeight;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty(backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty(border = ele.getFoBorderAttribute())) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty(borderBottom = ele.getFoBorderBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty(borderLeft = ele.getFoBorderLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty(borderRight = ele.getFoBorderRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty(borderTop = ele.getFoBorderTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty(margin = ele.getFoMarginAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty(marginBottom = ele.getFoMarginBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty(marginLeft = ele.getFoMarginLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty(marginRight = ele.getFoMarginRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty(marginTop = ele.getFoMarginTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty(maxHeight = ele.getFoMaxHeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("max-height", maxHeight);
        }
        if (StringUtils.isNotEmpty(maxWidth = ele.getFoMaxWidthAttribute())) {
            this.cssStyleSheet.setCSSProperty("max-width", maxWidth);
        }
        if (StringUtils.isNotEmpty(minHeight = ele.getFoMinHeightAttribute())) {
            this.cssStyleSheet.setCSSProperty("min-height", minHeight);
        }
        if (StringUtils.isNotEmpty(minWidth = ele.getFoMinWidthAttribute())) {
            this.cssStyleSheet.setCSSProperty("min-width", minWidth);
        }
        if (StringUtils.isNotEmpty(padding = ele.getFoPaddingAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty(paddingBottom = ele.getFoPaddingBottomAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty(paddingLeft = ele.getFoPaddingLeftAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty(paddingRight = ele.getFoPaddingRightAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty(paddingTop = ele.getFoPaddingTopAttribute())) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        super.visit(ele);
    }

    private String computeCSSClassName(OdfStyleBase style) {
        return this.computeCSSClassName(style, null);
    }

    private String computeCSSClassName(OdfStyleBase style, String prefix) {
        StringBuilder classNames = new StringBuilder();
        String className = this.compute(style, classNames, true, prefix);
        this.classNamesMap.put(className, classNames.toString());
        return "." + className;
    }

    private String compute(OdfStyleBase style, StringBuilder classNames, boolean first, String prefix) {
        if (style == null) {
            return null;
        }
        String familyName = style.getFamilyName();
        String styleName = null;
        if (style instanceof StyleStyleElement) {
            styleName = ((StyleStyleElement)style).getStyleNameAttribute();
        } else if (style instanceof StylePageLayoutElement) {
            styleName = ((StylePageLayoutElement)style).getStyleNameAttribute();
        }
        String className = this.getClassName(familyName, styleName);
        if (prefix != null) {
            className = className + prefix;
        }
        if (first) {
            classNames.append(className);
        } else {
            classNames.insert(0, ' ');
            classNames.insert(0, className);
        }
        style = style.getParentStyle();
        if (style != null) {
            this.compute(style, classNames, false, prefix);
        }
        return className;
    }

    public String getClassName(String familyName, String styleName) {
        StringBuilder className = new StringBuilder();
        className.append(familyName);
        if (styleName != null) {
            className.append('_');
            className.append(StringUtils.replaceAll(styleName, ".", "_"));
        }
        return className.toString();
    }

    public CSSStyleSheet getCSSStyleSheet() {
        return this.cssStyleSheet;
    }

    public String getMasterPageHeaderStyleName(String masterPageLayoutName) {
        return masterPageLayoutName + STYLE_NAME_HEADER;
    }

    public String getMasterPageFooterStyleName(String masterPageLayoutName) {
        return masterPageLayoutName + STYLE_NAME_FOOTER;
    }

    public void applyStyles(String familyName, String styleName, XHTMLPageContentBuffer xhtml) {
        String className = this.classNamesMap.get(this.getClassName(familyName, styleName));
        if (StringUtils.isNotEmpty(className)) {
            xhtml.setAttribute("class", className);
        }
    }

    public IURIResolver getURIResolver() {
        return this.resolver;
    }
}

