/*
 * Decompiled with CFR 0.152.
 */
package datechooser.model.multiple;

import datechooser.model.DateUtils;
import datechooser.model.multiple.DateOutputStyle;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period
extends DateOutputStyle
implements Comparable,
Serializable,
Cloneable {
    private Calendar startDate;
    private Calendar endDate;

    public Period(Calendar start, Calendar end) {
        this.set(start, end);
    }

    public Period(Calendar aDate) {
        this(aDate, aDate);
    }

    public void set(Calendar start, Calendar end) {
        if (start == null || end == null) {
            this.setStartDate(start);
            this.setEndDate(end);
        }
        if (DateUtils.before(start, end)) {
            this.setStartDate(start);
            this.setEndDate(end);
        } else {
            this.setStartDate(end);
            this.setEndDate(start);
        }
    }

    public boolean isIn(Calendar aDate) {
        return DateUtils.after(aDate, this.getStartDate()) && DateUtils.before(aDate, this.getEndDate()) || DateUtils.equals(aDate, this.getStartDate()) || DateUtils.equals(aDate, this.getEndDate());
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        if (this.startDate == null) {
            if (startDate == null) {
                return;
            }
            this.startDate = (Calendar)startDate.clone();
        } else if (startDate == null) {
            this.startDate = null;
        } else {
            this.startDate.setTime(startDate.getTime());
        }
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        if (this.endDate == null) {
            if (endDate == null) {
                return;
            }
            this.endDate = (Calendar)endDate.clone();
        } else if (endDate == null) {
            this.endDate = null;
        } else {
            this.endDate.setTime(endDate.getTime());
        }
    }

    public boolean isOneDate() {
        return this.getStartDate() != null && this.getEndDate() != null && DateUtils.equals(this.getStartDate(), this.getEndDate());
    }

    public boolean isValid() {
        return this.getStartDate() != null && this.getEndDate() != null;
    }

    public int compareTo(Object o) {
        Period trg = (Period)o;
        if (this.isIntersects(trg)) {
            return 0;
        }
        return this.getStartDate().compareTo(trg.getStartDate());
    }

    Collection<Calendar> listDates() {
        if (!this.isValid()) {
            return null;
        }
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        Calendar buffer = (Calendar)this.getStartDate().clone();
        while (buffer.before(this.getEndDate()) || buffer.equals(this.getEndDate())) {
            result.add(buffer);
            buffer = (Calendar)buffer.clone();
            buffer.add(5, 1);
        }
        return result;
    }

    public boolean isIntersects(Period anotherPeriod) {
        return this.isIn(anotherPeriod.getStartDate()) || this.isIn(anotherPeriod.getEndDate()) || anotherPeriod.isIn(this.getStartDate()) || anotherPeriod.isIn(this.getEndDate());
    }

    public boolean isNear(Period anotherPeriod) {
        return DateUtils.isNear(anotherPeriod.getEndDate(), this.getStartDate()) || DateUtils.isNear(this.getEndDate(), anotherPeriod.getStartDate());
    }

    public boolean isNear(Calendar date) {
        return DateUtils.isNear(date, this.getStartDate()) || DateUtils.isNear(this.getEndDate(), date);
    }

    public void unite(Period anotherPeriod) {
        if (this.getStartDate().after(anotherPeriod.getStartDate())) {
            this.setStartDate(anotherPeriod.getStartDate());
        }
        if (this.getEndDate().before(anotherPeriod.getEndDate())) {
            this.setEndDate(anotherPeriod.getEndDate());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public Object clone() {
        return new Period((Calendar)this.getStartDate().clone(), (Calendar)this.getEndDate().clone());
    }

    public String toString() {
        return this.toString(Period.getDateFormat());
    }

    public String toString(int fmtStyle, Locale locale) {
        return this.toString(DateFormat.getDateInstance(fmtStyle, locale));
    }

    public String toString(DateFormat dateFormat) {
        if (!this.isValid()) {
            return "invalid";
        }
        StringBuffer ans = new StringBuffer();
        ans.append(dateFormat.format(this.getStartDate().getTime()));
        if (!this.isOneDate()) {
            ans.append(" - ");
            ans.append(dateFormat.format(this.getEndDate().getTime()));
        }
        return ans.toString();
    }
}

