/*
 * Decompiled with CFR 0.152.
 */
package datechooser.view;

import datechooser.controller.DateChooseController;
import datechooser.controller.FooEventHandler;
import datechooser.model.DateChoose;
import datechooser.model.FooModel;
import datechooser.view.BackRenderer;
import datechooser.view.WeekDaysStyle;
import datechooser.view.appearance.AppearancesList;
import datechooser.view.appearance.CellAppearance;
import datechooser.view.appearance.ViewAppearance;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JPanel;

public class GridPane
extends JPanel
implements PropertyChangeListener {
    private static final int TEXT_SHIFT = 8;
    private DateChoose model;
    private DateChooseController controller;
    private AppearancesList appearance;
    private transient CellAppearance currentAppearance;
    private String[] weekDays;
    private Locale locale;
    private boolean focused;
    private boolean autoFontSize;
    private WeekDaysStyle weekStyle;
    private Rectangle cell;
    private transient int rows;
    private transient int cols;
    private transient int cellWidth;
    private transient int cellHeight;
    private transient int widthShift;
    private transient int heightShift;
    private transient int widthCounter;
    private transient int heightCounter;
    private transient int curWidth;
    private transient int curHeight;

    public GridPane() {
        this(new AppearancesList());
    }

    public GridPane(AppearancesList appearanceList) {
        this.setAppearanceList(appearanceList);
        this.getAppearance().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GridPane.this.firePropertyChange("currentAppearance", null, null);
                GridPane.this.repaint();
            }
        });
        this.setFocused(false);
        this.setEnabled(true);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                GridPane.this.setFocused(true);
            }

            public void focusLost(FocusEvent e) {
                GridPane.this.setFocused(false);
            }
        });
        this.cell = new Rectangle();
        this.setFocusable(true);
        this.setModel(new FooModel());
        this.setController(new FooEventHandler());
        this.locale = Locale.getDefault();
        this.weekStyle = WeekDaysStyle.NORMAL;
        this.initWeekDays();
    }

    public void setLocale(Locale l) {
        if (this.getLocale().equals(l)) {
            return;
        }
        super.setLocale(l);
        this.locale = l;
        this.initWeekDays();
        this.repaint();
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void initWeekDays() {
        DateFormatSymbols dateSymbols = new DateFormatSymbols(this.getLocale());
        String[] allDays = null;
        switch (this.getWeekStyle()) {
            case FULL: {
                allDays = dateSymbols.getWeekdays();
                break;
            }
            case NORMAL: {
                allDays = dateSymbols.getShortWeekdays();
                break;
            }
            case SHORT: {
                allDays = dateSymbols.getShortWeekdays();
                for (int i = 0; i < allDays.length; ++i) {
                    if (allDays[i].length() < 2) continue;
                    allDays[i] = allDays[i].substring(0, 1).toLowerCase();
                }
                break;
            }
        }
        this.weekDays = new String[allDays.length - 1];
        int firstWD = Calendar.getInstance(this.getLocale()).getFirstDayOfWeek();
        for (int i = 0; i < allDays.length - 1; ++i) {
            this.weekDays[i] = allDays[firstWD];
            if (firstWD < allDays.length - 1) {
                ++firstWD;
                continue;
            }
            firstWD = 1;
        }
        allDays = null;
    }

    protected void paintComponent(Graphics g) {
        BackRenderer renderer;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.getController().reBound();
        Rectangle bounds = this.getBounds();
        BackRenderer backRenderer = renderer = this.getAppearance().isSupportsTransparency() ? this.getAppearance().getRenderer() : null;
        if (renderer != null) {
            renderer.render(g2d, bounds);
        }
        this.rows = this.getModel().getRowsCount() + 1;
        this.cols = this.getModel().getColsCount();
        this.cellWidth = (int)bounds.getWidth() / this.cols;
        this.cellHeight = (int)bounds.getHeight() / this.rows;
        this.widthShift = (int)bounds.getWidth() % this.cols;
        this.heightShift = (int)bounds.getHeight() % this.rows;
        this.curWidth = 0;
        this.widthCounter = this.widthShift;
        this.heightCounter = this.heightShift;
        this.curHeight = this.cellHeight + (this.heightCounter-- > 0 ? 1 : 0);
        for (int c = 0; c < this.cols; ++c) {
            this.curWidth = this.cellWidth + (this.widthCounter-- > 0 ? 1 : 0);
            this.paintCaption(g2d, c, this.curWidth, this.curHeight);
            g2d.translate(this.curWidth, 0);
        }
        g2d.translate(-this.cellWidth * this.cols - this.widthShift, this.curHeight);
        this.widthCounter = this.widthShift;
        for (int i = 1; i < this.rows; ++i) {
            this.curHeight = this.cellHeight + (this.heightCounter-- > 0 ? 1 : 0);
            for (int j = 0; j < this.cols; ++j) {
                this.curWidth = this.cellWidth + (this.widthCounter-- > 0 ? 1 : 0);
                this.paintCell(g2d, i - 1, j, this.curWidth, this.curHeight);
                if (j == this.cols - 1) {
                    g2d.translate(-this.cellWidth * (this.cols - 1) - this.widthShift, this.curHeight);
                    this.widthCounter = this.widthShift;
                    continue;
                }
                g2d.translate(this.curWidth, 0);
            }
        }
    }

    private void paintCell(Graphics2D g2d, int row, int column, int width, int height) {
        boolean isText = true;
        switch (this.getModel().getCellState(row, column)) {
            case NORMAL: {
                this.currentAppearance = this.getAppearance().getUsual();
                break;
            }
            case NOW: {
                this.currentAppearance = this.getAppearance().getNow();
                break;
            }
            case SELECTED: {
                this.currentAppearance = this.getAppearance().getSelected();
                break;
            }
            case UNACCESSIBLE: {
                this.currentAppearance = this.getAppearance().getDisabled();
                break;
            }
            case NORMAL_SCROLL: {
                isText = this.getModel().isShowNeighbourMonth();
                this.currentAppearance = this.getAppearance().getScroll();
            }
        }
        if (this.currentAppearance == null) {
            return;
        }
        this.currentAppearance.render(g2d, this, isText ? this.getModel().getCellCaption(row, column) : "", width, height, this.isFocused() && this.getModel().isCursor(row, column));
    }

    private void paintCaption(Graphics2D g2d, int c, int width, int height) {
        this.getAppearance().getCaption().render(g2d, this, this.weekDays[c], width, height);
    }

    public DateChooseController getController() {
        return this.controller;
    }

    public void setController(DateChooseController controller) {
        this.controller = controller;
        controller.setView(this);
    }

    public DateChoose getModel() {
        return this.model;
    }

    public void setModel(DateChoose model) {
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
        this.model = model;
        this.getModel().addPropertyChangeListener(this);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        this.repaint();
    }

    public boolean isAutoFontSize() {
        return this.autoFontSize;
    }

    public void setAutoFontSize(boolean autoFontSize) {
        this.autoFontSize = autoFontSize;
    }

    public ViewAppearance getAppearance() {
        return this.appearance.getCurrent();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setFocusable(enabled);
    }

    public AppearancesList getAppearanceList() {
        return this.appearance;
    }

    public void setAppearanceList(AppearancesList appearance) {
        this.appearance = appearance;
    }

    public WeekDaysStyle getWeekStyle() {
        return this.weekStyle;
    }

    public void setWeekStyle(WeekDaysStyle weekStyle) {
        if (weekStyle == this.weekStyle) {
            return;
        }
        this.weekStyle = weekStyle;
        this.initWeekDays();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }
}

