/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.HoraDao;
import Modelos.Entidades.Hora;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang.exception.ExceptionUtils;

public class HoraDaoImpl
extends ConexionSQLite
implements HoraDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarHoraList(List<Hora> listaHoras) throws Exception {
        if (null != listaHoras && !listaHoras.isEmpty()) {
            try {
                String sql = "INSERT INTO hora(id, hora) values(?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Hora hora : listaHoras) {
                    if (null == hora) continue;
                    ps.setInt(1, hora.getId());
                    ps.setString(2, hora.getHora());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarHora(Hora hora) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO hora(id, hora) values(?,?)";
        try {
            run.update(conn, sql, new Object[]{hora.getId(), hora.getHora()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }
}

