/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Enumeradores.EstadoEnum;
import Modelos.Dao.UnidadPcaDao;
import Modelos.Entidades.Pca;
import Modelos.Entidades.UnidadPca;
import Servicios.ConexionSQLite;
import Util.DestrezaPcaUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class UnidadPcaDaoImpl
extends ConexionSQLite
implements UnidadPcaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eliminarUnidadPca(Integer id) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        if (null != id) {
            try {
                String sql = " update detalle_unidad set estado = '0', observacion = 'elimacion de unidad' where id_unidad_pca = ? ";
                run.update(conn, sql, (Object)id);
                sql = " update unidad_pca set estado = '0' where id_aplicacion = ? ";
                run.update(conn, sql, (Object)id);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.cerrarExterno(conn);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List<UnidadPca> obtenerListaUnidadesPca(Integer idPca) {
        return this.obtenerListaUnidades("where id_pca =" + idPca.toString() + " and estado = '1' ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaUnidadPcaSinc(List<UnidadPca> listaUnidadPca) {
        if (null != listaUnidadPca && !listaUnidadPca.isEmpty()) {
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" INSERT INTO unidad_pca(");
                sql.append("id, ");
                sql.append("id_pca, ");
                sql.append("nombre, ");
                sql.append("descripcion, ");
                sql.append("orden, ");
                sql.append("duracion_semana, ");
                sql.append("objetivos_especificos, ");
                sql.append("id_usuario_creacion, ");
                sql.append("fecha_creacion, ");
                sql.append("estado, ");
                sql.append("codigo_error, ");
                sql.append("reg_anio_inicio, ");
                sql.append("orientacion_metodologica)");
                sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,? )");
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql.toString());
                for (UnidadPca unidadPca : listaUnidadPca) {
                    if (null == unidadPca) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT id_aplicacion FROM pca WHERE id =? ");
                    psc.setInt(1, unidadPca.getIdPca());
                    ResultSet rsc = psc.executeQuery();
                    if (null == rsc) continue;
                    rsc.next();
                    ps.setObject(1, (Object)unidadPca.getId(), 4);
                    ps.setInt(2, rsc.getInt("id_aplicacion"));
                    ps.setString(3, unidadPca.getNombre());
                    ps.setString(4, unidadPca.getDescripcion());
                    ps.setInt(5, unidadPca.getOrden());
                    ps.setInt(6, unidadPca.getDuracionSemana());
                    ps.setString(7, unidadPca.getObjetivosEspecificos());
                    ps.setInt(8, unidadPca.getIdUsuarioCreacion());
                    ps.setObject(9, (Object)unidadPca.getFechaCreacion(), 91);
                    ps.setString(10, unidadPca.getEstado());
                    ps.setObject(11, (Object)unidadPca.getCodigoError(), 4);
                    ps.setString(12, unidadPca.getRegAnioInicio());
                    ps.setString(13, unidadPca.getOrientacionMetodologica());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(UnidadPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean guardarListaUnidadPca(List<UnidadPca> listaUnidadPca) {
        if (null != listaUnidadPca && !listaUnidadPca.isEmpty()) {
            try {
                String[] columnNames = new String[]{"id_aplicacion"};
                StringBuilder sql = new StringBuilder();
                sql.append(" INSERT INTO unidad_pca(");
                sql.append("id_pca, ");
                sql.append("nombre, ");
                sql.append("descripcion, ");
                sql.append("orden, ");
                sql.append("duracion_semana, ");
                sql.append("objetivos_especificos, ");
                sql.append("id_usuario_creacion, ");
                sql.append("fecha_creacion, ");
                sql.append("estado, ");
                sql.append("codigo_error, ");
                sql.append("reg_anio_inicio, ");
                sql.append("orientacion_metodologica)");
                sql.append(" values(?,?,?,?,?,?,?,datetime('now'),?,?,?,? )");
                StringBuilder sqlUpdate = new StringBuilder();
                sqlUpdate.append(" update unidad_pca set ");
                sqlUpdate.append("nombre = ?, ");
                sqlUpdate.append("descripcion = ?, ");
                sqlUpdate.append("orden = ?, ");
                sqlUpdate.append("duracion_semana = ?, ");
                sqlUpdate.append("objetivos_especificos = ?, ");
                sqlUpdate.append("orientacion_metodologica = ? ");
                sqlUpdate.append(" where id_aplicacion = ? ");
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql.toString(), columnNames);
                PreparedStatement psUpdate = this.getConexion().prepareStatement(sqlUpdate.toString());
                for (UnidadPca unidadPca : listaUnidadPca) {
                    if (null == unidadPca) continue;
                    if (null == unidadPca.getIdAplicacion()) {
                        Object generatedKeys;
                        ps.setInt(1, unidadPca.getIdPca());
                        ps.setString(2, unidadPca.getNombre());
                        ps.setString(3, unidadPca.getDescripcion());
                        ps.setInt(4, unidadPca.getOrden());
                        ps.setInt(5, unidadPca.getDuracionSemana());
                        ps.setString(6, unidadPca.getObjetivosEspecificos());
                        ps.setInt(7, unidadPca.getIdUsuarioCreacion());
                        ps.setString(8, unidadPca.getEstado());
                        ps.setObject(9, (Object)unidadPca.getCodigoError(), 4);
                        ps.setString(10, unidadPca.getRegAnioInicio());
                        ps.setString(11, unidadPca.getOrientacionMetodologica());
                        if (ps.executeUpdate() > 0) {
                            generatedKeys = ps.getGeneratedKeys();
                            if (!generatedKeys.next()) continue;
                            unidadPca.setIdAplicacion(generatedKeys.getInt(1));
                            continue;
                        }
                        generatedKeys = false;
                        return generatedKeys;
                    }
                    psUpdate.setString(1, unidadPca.getNombre());
                    psUpdate.setString(2, unidadPca.getDescripcion());
                    psUpdate.setInt(3, unidadPca.getOrden());
                    psUpdate.setInt(4, unidadPca.getDuracionSemana());
                    psUpdate.setString(5, unidadPca.getObjetivosEspecificos());
                    psUpdate.setString(6, unidadPca.getOrientacionMetodologica());
                    psUpdate.setInt(7, unidadPca.getIdAplicacion());
                    psUpdate.addBatch();
                }
                psUpdate.executeBatch();
                this.getConexion().commit();
                StringBuilder sqlDetalle = new StringBuilder();
                sqlDetalle.append(" INSERT INTO detalle_unidad(");
                sqlDetalle.append("id_unidad_pca, ");
                sqlDetalle.append("id_detreza_pca, ");
                sqlDetalle.append("id_usuario_creacion, ");
                sqlDetalle.append("fecha_creacion, ");
                sqlDetalle.append("estado, ");
                sqlDetalle.append("reg_anio_inicio) ");
                sqlDetalle.append(" values(?,?,?,datetime('now'),?,? )");
                String sqlDelete = " update detalle_unidad set estado = '0', observacion = 'actualizacion de unidad' where id_unidad_pca = ? ";
                QueryRunner run = new QueryRunner();
                PreparedStatement psDetalleUnidad = this.getConexion().prepareStatement(sqlDetalle.toString());
                for (UnidadPca unidadPca : listaUnidadPca) {
                    run.update(this.getConexion(), sqlDelete, (Object)unidadPca.getIdAplicacion());
                    for (DestrezaPcaUtil d : unidadPca.getListaDestrezas()) {
                        psDetalleUnidad.setInt(1, unidadPca.getIdAplicacion());
                        psDetalleUnidad.setInt(2, d.getId());
                        psDetalleUnidad.setInt(3, unidadPca.getIdUsuarioCreacion());
                        psDetalleUnidad.setString(4, EstadoEnum.ESTADO_ACTIVO.getEstado());
                        psDetalleUnidad.setString(5, unidadPca.getRegAnioInicio());
                        psDetalleUnidad.addBatch();
                    }
                }
                psDetalleUnidad.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(UnidadPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UnidadPca> obtenerListaUnidadesPcaEnviar(List<Pca> listaPcaRecibida) {
        CharSequence[] ids = new String[listaPcaRecibida.size()];
        for (int i = 0; i < listaPcaRecibida.size(); ++i) {
            ids[i] = listaPcaRecibida.get(i).getIdAplicacion().toString();
        }
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(UnidadPca.class);
        List<UnidadPca> listaUnidadPca = new ArrayList<UnidadPca>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT ");
            query.append("u.id, ");
            query.append("u.id_aplicacion as idAplicacion, ");
            query.append("p.id as idPca, ");
            query.append("u.nombre, ");
            query.append("u.descripcion, ");
            query.append("u.orden, ");
            query.append("u.duracion_semana as duracionSemana, ");
            query.append("u.objetivos_especificos objetivosEspecificos, ");
            query.append("u.orientacion_metodologica as orientacionMetodologica, ");
            query.append("u.id_usuario_creacion as idUsuarioCreacion, ");
            query.append("u.estado ");
            query.append(" FROM unidad_pca u ");
            query.append(" JOIN pca p on p.id_aplicacion = u.id_pca ");
            query.append(" where u.id_pca in ( ");
            query.append(String.join((CharSequence)",", ids));
            query.append(") and (u.estado = ? or (u.id is not null and u.estado = ? )) ");
            query.append(" order by u.orden ");
            listaUnidadPca = (List)run.query(conn, query.toString(), (ResultSetHandler)handler, new Object[]{EstadoEnum.ESTADO_ACTIVO.getEstado(), EstadoEnum.ESTADO_INACTIVO.getEstado()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaUnidadPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UnidadPca> obtenerListaUnidades(String where) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(UnidadPca.class);
        List<UnidadPca> listaUnidadPca = new ArrayList<UnidadPca>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT ");
            query.append("u.id, ");
            query.append("u.id_aplicacion as idAplicacion, ");
            query.append("u.id_pca as idPca, ");
            query.append("u.nombre, ");
            query.append("u.descripcion, ");
            query.append("u.orden, ");
            query.append("u.duracion_semana as duracionSemana, ");
            query.append("u.objetivos_especificos objetivosEspecificos, ");
            query.append("u.orientacion_metodologica as orientacionMetodologica, ");
            query.append("u.id_usuario_creacion as idUsuarioCreacion ");
            query.append(" FROM unidad_pca u ");
            if (null != where) {
                query.append(where);
            }
            listaUnidadPca = (List)run.query(conn, query.append(" order by orden ").toString(), (ResultSetHandler)handler);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaUnidadPca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarUnidadPcaSinc(List<UnidadPca> listaUnidad) {
        if (null != listaUnidad && !listaUnidad.isEmpty()) {
            try {
                String sql = " update unidad_pca set id = ?, codigo_error = ? where id_aplicacion = ? ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (UnidadPca unidad : listaUnidad) {
                    if (null == unidad) continue;
                    ps.setObject(1, (Object)unidad.getId(), 4);
                    ps.setInt(2, unidad.getCodigoError());
                    ps.setInt(3, unidad.getIdAplicacion());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(UnidadPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }
}

