/*
 * Decompiled with CFR 0.152.
 */
package Servicios.Sincronizacion;

import Json.ClienteServicioWeb;
import Modelos.Dao.CalificacionDao;
import Modelos.Dao.CalificacionDaoImpl;
import Modelos.Dao.NotaCualitativaDao;
import Modelos.Dao.NotaCualitativaDaoImpl;
import Modelos.Dao.NotaDao;
import Modelos.Dao.NotaDaoImpl;
import Modelos.Dao.NotaInicialDao;
import Modelos.Dao.NotaInicialDaoImpl;
import Modelos.Dao.RecomendacionDao;
import Modelos.Dao.RecomendacionDaoImpl;
import Modelos.Dao.SupletorioDao;
import Modelos.Dao.SupletorioDaoImpl;
import Modelos.Entidades.Calificacion;
import Modelos.Entidades.Nota;
import Modelos.Entidades.NotaCualitativa;
import Modelos.Entidades.NotaInicial;
import Modelos.Entidades.Recomendacion;
import Modelos.Entidades.Supletorio;
import Util.MsgLog;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;

public class SincronizarNotas {
    private final NotaInicialDao notaInicialDao = new NotaInicialDaoImpl();
    private final NotaDao notaDao = new NotaDaoImpl();
    private final CalificacionDao calificacionDao = new CalificacionDaoImpl();
    private final SupletorioDao supletorioDao = new SupletorioDaoImpl();
    private final NotaCualitativaDao notaCualitativaDao = new NotaCualitativaDaoImpl();
    private final RecomendacionDao recomendacionDao = new RecomendacionDaoImpl();

    public int asentarNotasInicialEnServidor(Integer codigoParalelo) {
        List<NotaInicial> notas = codigoParalelo > 0 ? this.notaInicialDao.obtenerPorParalelo(codigoParalelo) : this.notaInicialDao.buscarTodo();
        ArrayList<NotaInicial> notasAux = new ArrayList<NotaInicial>();
        for (NotaInicial nota : notas) {
            NotaInicial aux = new NotaInicial();
            aux.setId(nota.getId() != null ? nota.getId() : null);
            aux.setIdAplicacion(nota.getIdAplicacion());
            aux.setIdDestreza(nota.getIdDestreza());
            aux.setNota1(nota.getNota1() != null ? nota.getNota1() : " ");
            aux.setNota2(nota.getNota2() != null ? nota.getNota2() : " ");
            aux.setCodigoError(nota.getCodigoError());
            aux.setIdAsignacion(nota.getIdAsignacion());
            aux.setRegAnioInicio(nota.getRegAnioInicio());
            aux.setIdUsuarioCreacion(nota.getIdUsuarioCreacion());
            notasAux.add(aux);
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<NotaInicial>>(){}.getType();
            String jsonEnvio = gson.toJson(notasAux, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/NotaInicialServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List notasSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (NotaInicial nota : notasSincronizada) {
                this.notaInicialDao.actualizarNotaSincronizacion(nota);
                if (!nota.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }

    public int asentarNotasEnServidor(Integer idEscenario, Integer idEscenarioDiscrecion) {
        List<Object> notas = new ArrayList();
        if (idEscenario > 0) {
            try {
                notas = this.notaDao.obtenerPorParalelo(idEscenario, idEscenarioDiscrecion);
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                notas = this.notaDao.buscarTodo();
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<Nota>>(){}.getType();
            String jsonEnvio = gson.toJson(notas, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/NotaServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List notasSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (Nota nota : notasSincronizada) {
                this.notaDao.actualizarNotaSincronizacion(nota);
                if (!nota.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion == 1 && this.asentarSupletoriosEnServidor(idEscenario, idEscenarioDiscrecion) == 1 ? 1 : (correctaMigracion == -1 || this.asentarSupletoriosEnServidor(idEscenario, idEscenarioDiscrecion) == -1 ? -1 : 0);
    }

    public int asentarCalificacionesEnServidor(Integer idEscenario, Integer idEscenarioDiscrecion) {
        List<Object> notas = new ArrayList();
        if (idEscenario > 0) {
            try {
                notas = this.calificacionDao.obtenerPorParalelo(idEscenario, idEscenarioDiscrecion);
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                notas = this.calificacionDao.buscarTodo();
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<Calificacion>>(){}.getType();
            String jsonEnvio = gson.toJson(notas, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/CalificacionServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List calificacionSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (Calificacion cal : calificacionSincronizada) {
                this.calificacionDao.actualizarNotaSincronizacion(cal);
                if (!cal.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion == 1 && this.asentarNotasEnServidor(idEscenario, idEscenarioDiscrecion) == 1 ? 1 : (correctaMigracion == -1 || this.asentarNotasEnServidor(idEscenario, idEscenarioDiscrecion) == -1 ? -1 : 0);
    }

    public int asentarCalificacioneAuxNotasEnServidor(Integer idEscenario, Integer idEscenarioDiscrecion) {
        List<Object> notas = new ArrayList();
        if (idEscenario > 0) {
            try {
                notas = this.calificacionDao.obtenerPorParalelo(idEscenario, idEscenarioDiscrecion);
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                notas = this.calificacionDao.buscarTodo();
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<Calificacion>>(){}.getType();
            String jsonEnvio = gson.toJson(notas, type);
            System.out.println("jsonEnvio:" + jsonEnvio);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/CalificacionServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List calificacionSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (Calificacion cal : calificacionSincronizada) {
                this.calificacionDao.actualizarNotaSincronizacion(cal);
                if (!cal.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }

    public int asentarSupletoriosEnServidor(Integer idEscenario, Integer idEscenarioDiscrecion) {
        List<Object> supletorios = new ArrayList();
        if (idEscenario > 0) {
            try {
                supletorios = this.supletorioDao.obtenerPorParalelo(idEscenario, idEscenarioDiscrecion);
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                supletorios = this.supletorioDao.buscarTodo();
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<Supletorio>>(){}.getType();
            String jsonEnvio = gson.toJson(supletorios, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/SupletorioServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List calificacionSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (Supletorio suple : calificacionSincronizada) {
                this.supletorioDao.actualizarNotaSincronizacion(suple);
                if (!suple.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }

    public int asentarNotaCualitativaEnServidor(Integer idEscenario, Integer idEscenarioDiscrecion) {
        List<Object> notas = new ArrayList();
        if (idEscenario > 0) {
            this.asentarCalificacioneAuxNotasEnServidor(idEscenario, idEscenarioDiscrecion);
            try {
                notas = this.notaCualitativaDao.obtenerPorParalelo(idEscenario, idEscenarioDiscrecion);
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            notas = this.notaCualitativaDao.buscarTodo();
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<NotaCualitativa>>(){}.getType();
            String jsonEnvio = gson.toJson(notas, type);
            System.out.println("jsonEnvio:" + jsonEnvio);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/NotaCualitativaServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List notaSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (NotaCualitativa nota : notaSincronizada) {
                this.notaCualitativaDao.actualizarNotaSincronizacion(nota);
                if (!nota.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }

    public int asentarRecomendacionesEnServidor(Integer idEscenario, Integer idEscenarioDiscrecion) {
        List<Object> recomendaciones = new ArrayList();
        if (idEscenario > 0) {
            this.asentarCalificacioneAuxNotasEnServidor(idEscenario, idEscenarioDiscrecion);
            try {
                recomendaciones = this.recomendacionDao.obtenerPorParalelo(idEscenario, idEscenarioDiscrecion);
            }
            catch (Exception ex) {
                Logger.getLogger(SincronizarNotas.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            recomendaciones = this.recomendacionDao.buscarTodo();
        }
        int correctaMigracion = 0;
        int contadorErroneos = 0;
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<List<Recomendacion>>(){}.getType();
            String jsonEnvio = gson.toJson(recomendaciones, type);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/RecomendacionServicioJdc", jsonEnvio);
            if (jsonRespuesta != null && jsonRespuesta.contains("Connection refused: connect")) {
                return -1;
            }
            List notaSincronizada = (List)gson.fromJson(jsonRespuesta, type);
            for (Recomendacion recomendacion : notaSincronizada) {
                this.recomendacionDao.actualizarRecomendacionSincronizacion(recomendacion);
                if (!recomendacion.getCodigoError().equals(1)) continue;
                ++contadorErroneos;
            }
            correctaMigracion = contadorErroneos == 0 ? 1 : 0;
        }
        catch (JsonSyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return correctaMigracion;
    }
}

