/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Servicios.MD5;
import Util.FileUtil;
import Util.ObtenerPropiedad;
import Util.Util;
import ec.gob.educacion.encripta.UtilEncripta;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class GestionArchivo {
    JFileChooser fileChooser;
    String rutaArchivo;
    String texto;
    JTextArea areaDeTexto;
    String rutaBDD;
    private final String urlDirectorioBase = "/config/";

    private String abrirArchivo(JFrame jfrPrincipal) {
        String aux = "";
        this.texto = "";
        try {
            this.fileChooser.showOpenDialog(jfrPrincipal);
            File abre = this.fileChooser.getSelectedFile();
            if (abre != null) {
                FileReader archivos = new FileReader(abre);
                BufferedReader lee = new BufferedReader(archivos);
                while ((aux = lee.readLine()) != null) {
                    this.texto = this.texto + aux + "\n";
                }
                lee.close();
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex + "\nNo se ha encontrado el archivo", "ADVERTENCIA!!!", 2);
        }
        return this.texto;
    }

    private void crearArchivo(JFrame jfrPrincipal) {
        try {
            String nombre = "";
            JFileChooser file = new JFileChooser();
            file.showSaveDialog(jfrPrincipal);
            File guarda = file.getSelectedFile();
            if (guarda != null) {
                nombre = file.getSelectedFile().getName();
                FileWriter save = new FileWriter(guarda + ".txt");
                save.write(this.areaDeTexto.getText());
                save.close();
                JOptionPane.showMessageDialog(null, "El archivo se a guardado Exitosamente", "Informaci\u00f3n", 1);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Su archivo no se ha guardado " + ex.getMessage(), "Advertencia", 2);
        }
    }

    private boolean copiarArchivo(File archivo, String dirDestino) {
        String nombre = archivo.getName();
        File archDestino = new File(dirDestino + nombre);
        boolean blnCopiado = false;
        try {
            int len;
            archDestino.createNewFile();
            FileInputStream in = new FileInputStream(archivo);
            FileOutputStream out = new FileOutputStream(archDestino);
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            buffer = null;
            blnCopiado = true;
            return blnCopiado;
        }
        catch (IOException e) {
            e.printStackTrace();
            return blnCopiado;
        }
    }

    public boolean FileCopy(String sourceFile, String destinationFile) throws URISyntaxException {
        boolean blnCopiado = false;
        String path = "";
        try {
            File inFile = new File(sourceFile);
            File outFile = new File(destinationFile);
            if (inFile.exists() && inFile.canRead()) {
                int c;
                FileInputStream in = new FileInputStream(inFile);
                FileOutputStream out = new FileOutputStream(outFile);
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                in.close();
                out.close();
                blnCopiado = true;
            }
            return blnCopiado;
        }
        catch (IOException e) {
            e.printStackTrace();
            return blnCopiado;
        }
    }

    public void exportarArchivo(JFrame jfrPrincipal) {
        try {
            JFileChooser file = new JFileChooser();
            if (file.showSaveDialog(jfrPrincipal) == 0) {
                this.rutaArchivo = file.getSelectedFile().getAbsolutePath() + ".med";
                String origen = ObtenerPropiedad.obtenerPropiedad("bdd");
                String rutaAplicacion = FileUtil.rutaApp();
                this.rutaBDD = rutaAplicacion + File.separator + "/config/" + origen;
                if (this.FileCopy(this.rutaBDD, this.rutaArchivo)) {
                    UtilEncripta.encriptaArchivoBB((String)this.rutaArchivo);
                    JOptionPane.showMessageDialog(null, "El archivo se export\u00f3 exitosamente", "Informaci\u00f3n", 1);
                }
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Su archivo no se ha guardado", "Advertencia", 2);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Su archivo no se ha Exportado", "Advertencia", 2);
        }
    }

    public void importarArchivo(JFrame jfrPrincipal) {
        try {
            JFileChooser file = new JFileChooser();
            file.showSaveDialog(jfrPrincipal);
            this.rutaArchivo = file.getSelectedFile().getAbsolutePath();
            String origen = ObtenerPropiedad.obtenerPropiedad("bdd");
            String rutaAplicacion = FileUtil.rutaApp();
            this.rutaBDD = rutaAplicacion + File.separator + "/config/" + origen;
            if (this.FileCopy(this.rutaArchivo, this.rutaBDD)) {
                JOptionPane.showMessageDialog(null, "El archivo se Importo Exitosamente", "Informaci\u00f3n", 1);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Su archivo no se ha Importado " + ex.getMessage(), "Advertencia", 2);
        }
    }

    public boolean importarArchivo(String origen, String nombreArchivo) {
        boolean importar = false;
        try {
            String rutaAplicacion = FileUtil.rutaApp();
            this.rutaBDD = rutaAplicacion + File.separator + "/config/" + nombreArchivo;
            if (this.FileCopy(origen, this.rutaBDD)) {
                importar = true;
            }
            return importar;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return importar;
        }
    }

    public boolean validarExistenciaBDD(String usuario) {
        String rutaAplicacion = FileUtil.rutaApp();
        this.rutaArchivo = rutaAplicacion + File.separator + "/config/" + usuario + ".med";
        boolean existencia = false;
        File fichero = new File(this.rutaArchivo);
        if (fichero.isFile()) {
            existencia = true;
            usuario = usuario.concat(".med");
            try {
                if (!ObtenerPropiedad.obtenerPropiedad("bdd").equals(usuario)) {
                    ObtenerPropiedad.ModificarPropiedad("bdd", usuario);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(GestionArchivo.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(GestionArchivo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return existencia;
    }

    public boolean crearBDD(String destino, String origen, boolean existencia) {
        boolean creacion = false;
        try {
            String rutaArchivoOrigen;
            String rutaAplicacion = FileUtil.rutaApp();
            if (origen.equals("")) {
                origen = ObtenerPropiedad.obtenerPropiedad("plantilla");
                rutaArchivoOrigen = rutaAplicacion + File.separator + "/config/" + origen;
                Util.desencriptaArchivoBB(rutaArchivoOrigen);
            } else {
                rutaArchivoOrigen = origen;
            }
            String rutaArchivoDestino = rutaAplicacion + File.separator + "/config/" + destino + ".med";
            if (existencia) {
                GregorianCalendar fecha = new GregorianCalendar();
                int anio = fecha.get(1);
                int mes = fecha.get(2) + 1;
                int dia = fecha.get(5);
                int hora = fecha.get(11);
                int minuto = fecha.get(12);
                int segundo = fecha.get(13);
                File archivo1 = new File(rutaArchivoDestino);
                File archivo2 = new File(rutaAplicacion + File.separator + "/config/" + destino + "_" + dia + mes + anio + "_" + hora + minuto + ".med");
                archivo1.renameTo(archivo2);
                Util.desencriptaArchivoBB(rutaAplicacion + File.separator + "/config/" + destino + "_" + dia + mes + anio + "_" + hora + minuto + ".med");
                Util.encriptaArchivoBB(rutaAplicacion + File.separator + "/config/" + destino + "_" + dia + mes + anio + "_" + hora + minuto + ".med");
            }
            if (this.FileCopy(rutaArchivoOrigen, rutaArchivoDestino)) {
                ObtenerPropiedad.ModificarPropiedad("bdd", destino + ".med");
                File archivoBB = new File(rutaArchivoDestino);
                ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                Util.encriptaArchivoBB(rutaArchivoOrigen);
                creacion = true;
            }
            return creacion;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return creacion;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return creacion;
        }
    }

    public boolean eliminarArchivo(String nombreArchivo) {
        boolean eliminar = false;
        File fichero = new File(nombreArchivo);
        try {
            if (fichero.delete()) {
                eliminar = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return eliminar;
    }
}

