/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Formatos.FormatoTablaFija;
import Formatos.FormatoTablaInicial;
import Modelos.Dao.HoraAsistenciaDaoImpl;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Util.DiasSemanaHora;
import Util.Grado;
import Util.HoraAsistencia;
import Util.Util;
import Vistas.model.EditaCeldaTablaFaltaJustificada;
import Vistas.model.JBroTableDataJustificarAsistencia;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import org.quinto.swing.table.model.IModelFieldGroup;
import org.quinto.swing.table.model.ModelData;
import org.quinto.swing.table.model.ModelField;
import org.quinto.swing.table.model.ModelFieldGroup;
import org.quinto.swing.table.model.ModelRow;
import org.quinto.swing.table.view.JBroTable;

public class JusticarAsistenciaTableJbroModel
extends JFrame {
    int nombreMasLargo;
    JBroTable tablaFija;
    JBroTable tablaNotas;
    JScrollPane scroll;
    private HoraAsistenciaDaoImpl horaAsistenciaDaoImpl = new HoraAsistenciaDaoImpl();

    public JusticarAsistenciaTableJbroModel(Integer codigoParalelo, List<Asignacion> asistenciaEstudiantes, String fechaInicial, String fechaFinal, Instructor instructor, Grado grado) {
        IModelFieldGroup[] cabeceraNombres = new IModelFieldGroup[]{new ModelFieldGroup("estudiantes", "LISTADO").withChild((IModelFieldGroup)new ModelField("nombres", "ESTUDIANTES").withRowspan(3))};
        ModelField[] fieldsNombres = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraNombres);
        ModelRow[] rowsNombres = new ModelRow[asistenciaEstudiantes.size()];
        for (int i = 0; i < asistenciaEstudiantes.size(); ++i) {
            int inicialNombreMasLargo;
            rowsNombres[i] = new ModelRow(fieldsNombres.length);
            Asignacion estudiante = asistenciaEstudiantes.get(i);
            int n = inicialNombreMasLargo = estudiante.getNombreApellidoEstudiante() != null ? estudiante.getNombreApellidoEstudiante().length() : 0;
            if (inicialNombreMasLargo > this.nombreMasLargo) {
                this.nombreMasLargo = inicialNombreMasLargo;
            }
            for (int j = 0; j < fieldsNombres.length; ++j) {
                rowsNombres[i].setValue(j, (Object)estudiante.getNombreApellidoEstudiante());
            }
        }
        ModelData dataNombres = new ModelData(cabeceraNombres);
        dataNombres.setRows(rowsNombres);
        this.tablaFija = new JBroTable(dataNombres){

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                JusticarAsistenciaTableJbroModel.this.checkSelection(true);
            }
        };
        this.tablaFija.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaFija(this.tablaFija, this.nombreMasLargo));
        List<DiasSemanaHora> diasSemana = Util.getDiasRangoFechas(fechaInicial, fechaFinal);
        ArrayList<DiasSemanaHora> diasAux = new ArrayList<DiasSemanaHora>();
        for (DiasSemanaHora dia : diasSemana) {
            List<HoraAsistencia> horasAsistencia = this.horaAsistenciaDaoImpl.listarHorasClaseTutor(grado.getCodigo(), dia.getNemonico());
            if (horasAsistencia.size() <= 0) continue;
            for (HoraAsistencia hora : horasAsistencia) {
                HoraAsistencia item = new HoraAsistencia();
                item.setNemonicoDia(hora.getNemonicoDia());
                item.setHoraInicio(hora.getHoraInicio());
                item.setHoraFin(hora.getHoraFin());
                item.setIdHorario(hora.getIdHorario());
                item.setDia(dia.getDia());
                dia.getHoraAsistencia().add(item);
            }
            diasAux.add(dia);
        }
        SimpleDateFormat formatoFecha = new SimpleDateFormat("dd/MM/yyyy");
        ModelFieldGroup agrupacionDias = new ModelFieldGroup("_head", "ASISTENCIA DE " + fechaInicial + " HASTA " + fechaFinal);
        for (DiasSemanaHora dia : diasAux) {
            ModelFieldGroup agrupacionDiaHora = new ModelFieldGroup(formatoFecha.format(dia.getDia()), "<html><div align='center'>" + dia.getDescripcion().toUpperCase() + "<br/>" + formatoFecha.format(dia.getDia()) + "</div></html>");
            for (HoraAsistencia hora : dia.getHoraAsistencia()) {
                agrupacionDiaHora.withChild((IModelFieldGroup)new ModelField(formatoFecha.format(hora.getDia()) + "-" + hora.getIdHorario(), "<html><div align='center'>" + hora.getHoraInicio().substring(0, 5) + " - " + hora.getHoraFin().substring(0, 5) + "</div></html>").withDefaultWidth(Integer.valueOf(90)).withVisible(!dia.isFinDeSemana()));
            }
            agrupacionDias.withChild((IModelFieldGroup)agrupacionDiaHora);
        }
        IModelFieldGroup[] cabeceraAsistencia = new IModelFieldGroup[]{agrupacionDias};
        ModelField[] fields = ModelFieldGroup.getBottomFields((IModelFieldGroup[])cabeceraAsistencia);
        ModelRow[] rowsNotas = new ModelRow[asistenciaEstudiantes.size()];
        ModelData dataNotas = new ModelData(cabeceraAsistencia);
        dataNotas.setRows(rowsNotas);
        this.tablaNotas = new JBroTableDataJustificarAsistencia(dataNotas, asistenciaEstudiantes, fields, instructor);
        for (int i = 0; i < this.tablaNotas.getColumnCount(); ++i) {
            this.tablaNotas.getColumnModel().getColumn(i).setCellEditor(new EditaCeldaTablaFaltaJustificada(asistenciaEstudiantes, fields, instructor));
        }
        this.tablaNotas.getTableHeader().setReorderingAllowed(false);
        this.tablaNotas.setDefaultRenderer(Object.class, (TableCellRenderer)new FormatoTablaInicial(this.tablaNotas));
        this.tablaFija.setAutoResizeMode(0);
        this.tablaNotas.setAutoResizeMode(0);
        this.tablaFija.setSelectionMode(0);
        this.tablaNotas.setSelectionMode(0);
        this.scroll = new JScrollPane((Component)this.tablaNotas);
        JViewport viewport = new JViewport();
        viewport.setView((Component)this.tablaFija);
        viewport.setPreferredSize(this.tablaFija.getPreferredSize());
        this.scroll.setRowHeaderView(viewport);
        this.scroll.setCorner("UPPER_LEFT_CORNER", (Component)this.tablaFija.getTableHeader());
    }

    private void checkSelection(boolean isFixedTable) {
        int selectedIndex;
        int fixedSelectedIndex = this.tablaFija.getSelectedRow();
        if (fixedSelectedIndex != (selectedIndex = this.tablaNotas.getSelectedRow())) {
            if (isFixedTable) {
                this.tablaNotas.setRowSelectionInterval(fixedSelectedIndex, fixedSelectedIndex);
            } else {
                this.tablaFija.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    public int getNombreMasLargo() {
        return this.nombreMasLargo;
    }

    public void setNombreMasLargo(int nombreMasLargo) {
        this.nombreMasLargo = nombreMasLargo;
    }

    public JBroTable getTablaFija() {
        return this.tablaFija;
    }

    public void setTablaFija(JBroTable tablaFija) {
        this.tablaFija = tablaFija;
    }

    public JBroTable getTablaNotas() {
        return this.tablaNotas;
    }

    public void setTablaNotas(JBroTable tablaNotas) {
        this.tablaNotas = tablaNotas;
    }

    public JScrollPane getScroll() {
        return this.scroll;
    }

    public void setScroll(JScrollPane scroll) {
        this.scroll = scroll;
    }
}

