/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.HorarioDao;
import Modelos.Entidades.Horario;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang.exception.ExceptionUtils;

public class HorarioDaoImpl
extends ConexionSQLite
implements HorarioDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaHorario(List<Horario> listaHorario) throws Exception {
        StringBuilder query = new StringBuilder();
        if (null != listaHorario && !listaHorario.isEmpty()) {
            try {
                String sql = " INSERT INTO horario(id, id_dia, id_hora_jornada, id_instructor, numero_horas) values(?,?,?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Horario horario : listaHorario) {
                    if (null == horario) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT * FROM horario WHERE id =? ");
                    psc.setInt(1, horario.getId());
                    ResultSet rsc = psc.executeQuery();
                    if (rsc.next()) continue;
                    ps.setInt(1, horario.getId());
                    ps.setInt(2, horario.getIdDia());
                    ps.setInt(3, horario.getIdHoraJornada());
                    ps.setInt(4, horario.getIdInstructor());
                    ps.setObject(5, (Object)horario.getNumeroHoras(), 4);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarHorario(Horario horario) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO horario(id, id_dia, id_hora_jornada, id_instructor, numero_horas) values(?,?,?,?,?)";
        try {
            run.update(conn, sql, new Object[]{horario.getId(), horario.getIdDia(), horario.getIdHoraJornada(), horario.getIdInstructor(), horario.getNumeroHoras()});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }
}

