/*
 * Decompiled with CFR 0.152.
 */
package Servicios.Sincronizacion;

import Json.ClienteServicioWeb;
import Modelos.Dao.CriterioPcaDao;
import Modelos.Dao.CriterioPcaDaoImpl;
import Modelos.Dao.DestrezaPcaDao;
import Modelos.Dao.DestrezaPcaDaoImpl;
import Modelos.Dao.DetalleUnidadPcaDao;
import Modelos.Dao.DetalleUnidadPcaDaoImpl;
import Modelos.Dao.IndicadorPcaDao;
import Modelos.Dao.IndicadorPcaDaoImpl;
import Modelos.Dao.ObjetivoPcaDao;
import Modelos.Dao.ObjetivoPcaDaoImpl;
import Modelos.Dao.PcaDao;
import Modelos.Dao.PcaDaoImpl;
import Modelos.Dao.UnidadPcaDao;
import Modelos.Dao.UnidadPcaDaoImpl;
import Modelos.Entidades.DetalleUnidadPca;
import Modelos.Entidades.EntidadesPcaDTO;
import Modelos.Entidades.Pca;
import Modelos.Entidades.SolicitudPcaDTO;
import Modelos.Entidades.UnidadPca;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class SincronizarPca {
    private final PcaDao pcaDao = new PcaDaoImpl();
    private final DestrezaPcaDao destrezaPcaDao = new DestrezaPcaDaoImpl();
    private final CriterioPcaDao criterioPcaDao = new CriterioPcaDaoImpl();
    private final IndicadorPcaDao indicadorPcaDao = new IndicadorPcaDaoImpl();
    private final ObjetivoPcaDao objetivoPcaDao = new ObjetivoPcaDaoImpl();
    private final UnidadPcaDao unidadPcaDao = new UnidadPcaDaoImpl();
    private final DetalleUnidadPcaDao detalleUnidadPcaDao = new DetalleUnidadPcaDaoImpl();

    public Boolean descargarInformacion(String cedulaDocente) {
        boolean correctaMigracion = false;
        try {
            EntidadesPcaDTO recibidoObjeto;
            Gson gson = new Gson();
            Type type = new TypeToken<SolicitudPcaDTO>(){}.getType();
            Type typeRecibido = new TypeToken<EntidadesPcaDTO>(){}.getType();
            SolicitudPcaDTO solicitud = new SolicitudPcaDTO();
            solicitud.setIdentificacionDocenteJson(cedulaDocente);
            solicitud.setListIdsPcaExistentes(this.pcaDao.obtenerIdsPcaExistentes());
            String jsonEnvio = gson.toJson((Object)solicitud, type);
            System.out.println("jsonEnvio: " + jsonEnvio);
            String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/InformacionPca", jsonEnvio);
            System.out.println("jsonRespuesta: " + jsonRespuesta);
            if (null != jsonRespuesta && !jsonRespuesta.isEmpty() && null != (recibidoObjeto = (EntidadesPcaDTO)gson.fromJson(jsonRespuesta, typeRecibido))) {
                if (null != recibidoObjeto.getListaPcaJefeArea() && !recibidoObjeto.getListaPcaJefeArea().isEmpty()) {
                    this.pcaDao.guardarListaPca(recibidoObjeto.getListaPcaJefeArea(), Boolean.TRUE);
                    this.destrezaPcaDao.guardarListaDestrezaPcaDao(recibidoObjeto.getListaPcaDestrezas());
                    this.criterioPcaDao.guardarListaCriterioPca(recibidoObjeto.getListaPcaCriterios());
                    this.indicadorPcaDao.guardarListaIndicadorPca(recibidoObjeto.getListaPcaIndicadores());
                    this.objetivoPcaDao.guardarListaObjetivoPcaDao(recibidoObjeto.getListaPcaObjetivos());
                }
                if (null != recibidoObjeto.getListaPcaDocente() && !recibidoObjeto.getListaPcaDocente().isEmpty()) {
                    this.pcaDao.guardarListaPca(recibidoObjeto.getListaPcaDocente(), Boolean.FALSE);
                    this.destrezaPcaDao.guardarListaDestrezaPcaDao(recibidoObjeto.getListaPcaDocenteDestreza());
                    this.criterioPcaDao.guardarListaCriterioPca(recibidoObjeto.getListaPcaDocenteCriterio());
                    this.indicadorPcaDao.guardarListaIndicadorPca(recibidoObjeto.getListaPcaDocenteIndicador());
                    this.objetivoPcaDao.guardarListaObjetivoPcaDao(recibidoObjeto.getListaPcaDocenteObjetivo());
                }
                this.unidadPcaDao.guardarListaUnidadPcaSinc(recibidoObjeto.getListaPcaUnidades());
                this.detalleUnidadPcaDao.guardarListaSincDetalleUnidadPca(recibidoObjeto.getListaPcaDetalleUnidad());
                this.pcaDao.actualizarPcaDocente(recibidoObjeto.getListaPcaDocente());
                correctaMigracion = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return correctaMigracion;
    }

    public Boolean tieneInformacionParaEnviar() {
        List<Pca> listaPca = this.pcaDao.obtenerListaPcaEnviar(null);
        return null != listaPca && !listaPca.isEmpty();
    }

    public void limipiarPca() {
        this.pcaDao.limipiarPca();
    }

    public Boolean enviarInformacion(Pca pca) {
        return this.enviarInformacion(pca, Boolean.FALSE);
    }

    public Boolean enviarInformacion(Pca pca, Boolean finalizar) {
        boolean correctaMigracion = false;
        try {
            Gson gson = new Gson();
            Type typePca = new TypeToken<List<Pca>>(){}.getType();
            List<Pca> listaPca = null != pca ? (finalizar.booleanValue() ? this.pcaDao.obtenerListaPcaEnviarYFinalizar(pca.getIdAplicacion()) : this.pcaDao.obtenerListaPcaEnviar(pca.getIdAplicacion())) : this.pcaDao.obtenerListaPcaEnviar(null);
            if (null != listaPca && !listaPca.isEmpty()) {
                List listaPcaRecibido;
                String jsonEnvio = gson.toJson(listaPca, typePca);
                String jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/PcaServicioJdc/pca", jsonEnvio);
                if (null != jsonRespuesta && !jsonRespuesta.isEmpty() && null != (listaPcaRecibido = (List)gson.fromJson(jsonRespuesta, typePca))) {
                    List<UnidadPca> listaUnidades;
                    this.pcaDao.actualizarPcaSinc(listaPcaRecibido);
                    if (null != pca && null == pca.getId()) {
                        pca.setId(((Pca)listaPcaRecibido.get(0)).getId());
                    }
                    if (null != (listaUnidades = this.unidadPcaDao.obtenerListaUnidadesPcaEnviar(listaPcaRecibido)) && !listaUnidades.isEmpty()) {
                        Type typeUnidades = new TypeToken<List<UnidadPca>>(){}.getType();
                        jsonEnvio = gson.toJson(listaUnidades, typeUnidades);
                        jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/PcaServicioJdc/unidad", jsonEnvio);
                        if (null != jsonRespuesta && !jsonRespuesta.isEmpty()) {
                            List listaUnidadesRecibidas = (List)gson.fromJson(jsonRespuesta, typeUnidades);
                            this.unidadPcaDao.actualizarUnidadPcaSinc(listaUnidadesRecibidas);
                            List<DetalleUnidadPca> listaDetalleUnidad = this.detalleUnidadPcaDao.obtenerListaDetalleUnidadEnviar(listaUnidadesRecibidas);
                            if (null != listaDetalleUnidad && !listaDetalleUnidad.isEmpty()) {
                                Type typeDetalleUnidades = new TypeToken<List<DetalleUnidadPca>>(){}.getType();
                                jsonEnvio = gson.toJson(listaDetalleUnidad, typeDetalleUnidades);
                                jsonRespuesta = ClienteServicioWeb.servicioWebPost("https://academico.educarecuador.gob.ec/serviciosEducacion-web/resources/PcaServicioJdc/detalleUnidad", jsonEnvio);
                                if (null != jsonRespuesta && !jsonRespuesta.isEmpty()) {
                                    List listaDetalleUnidadRecibida = (List)gson.fromJson(jsonRespuesta, typeDetalleUnidades);
                                    this.detalleUnidadPcaDao.actualizarDetalleUnidadSinc(listaDetalleUnidadRecibida);
                                    correctaMigracion = true;
                                }
                            } else {
                                correctaMigracion = true;
                            }
                        }
                    } else {
                        correctaMigracion = true;
                    }
                }
            } else {
                correctaMigracion = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return correctaMigracion;
    }
}

