/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.ObjetivoPcaDao;
import Modelos.Entidades.ObjetivoPca;
import Servicios.ConexionSQLite;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class ObjetivoPcaDaoImpl
extends ConexionSQLite
implements ObjetivoPcaDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarListaObjetivoPcaDao(List<ObjetivoPca> listaObjetivosPca) {
        if (null != listaObjetivosPca && !listaObjetivosPca.isEmpty()) {
            try {
                StringBuilder sql = new StringBuilder();
                sql.append(" INSERT INTO objetivo_pca(");
                sql.append("id, ");
                sql.append("nombre, ");
                sql.append("descripcion, ");
                sql.append("id_usuario_creacion, ");
                sql.append("fecha_creacion, ");
                sql.append("reg_anio_inicio, ");
                sql.append("id_destreza) ");
                sql.append(" values(?,?,?,?,?,?,?) ");
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql.toString());
                for (ObjetivoPca objetivo : listaObjetivosPca) {
                    if (null == objetivo) continue;
                    ps.setObject(1, (Object)objetivo.getId(), 4);
                    ps.setString(2, objetivo.getNombre());
                    ps.setString(3, objetivo.getDescripcion());
                    ps.setInt(4, objetivo.getIdUsuarioCreacion());
                    ps.setObject(5, (Object)objetivo.getFechaCreacion(), 91);
                    ps.setString(6, objetivo.getRegAnioInicio());
                    ps.setInt(7, objetivo.getIdDestreza());
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(ObjetivoPcaDaoImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    this.cerrar();
                }
                catch (SQLException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjetivoPca> obtenerListaObjetivoPcaPorIdDestreza(Integer idDestreza) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ObjetivoPca.class);
        List<ObjetivoPca> listaObjetivoPca = new ArrayList<ObjetivoPca>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append("o.id, ");
        sql.append("o.nombre,");
        sql.append("o.descripcion,");
        sql.append("o.id_destreza as idDestreza,");
        sql.append("o.id_usuario_creacion as idUsuarioCreacion ");
        sql.append(" FROM objetivo_pca o where id_destreza = ? ");
        try {
            listaObjetivoPca = (List)run.query(conn, sql.toString(), (ResultSetHandler)handler, new Object[]{idDestreza});
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return listaObjetivoPca;
    }
}

