/*
 * Decompiled with CFR 0.152.
 */
package Modelos.Dao;

import Modelos.Dao.SupletorioDao;
import Modelos.Entidades.Supletorio;
import Servicios.ConexionSQLite;
import Util.MsgLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.lang.exception.ExceptionUtils;

public class SupletorioDaoImpl
extends ConexionSQLite
implements SupletorioDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardarLista(List<Supletorio> listaSupletorio) throws Exception {
        if (null != listaSupletorio && !listaSupletorio.isEmpty()) {
            try {
                String sql = " INSERT INTO supletorio(id, id_calificacion, nota_supletorio,nota_remedial,tipo_examen,reg_anio_inicio,id_usuario_creacion,nota_gracia )  values(?,?,?,?,?,?,?,?) ";
                this.Conectar();
                this.getConexion().setAutoCommit(false);
                PreparedStatement ps = this.getConexion().prepareStatement(sql);
                for (Supletorio supletorio : listaSupletorio) {
                    if (null == supletorio) continue;
                    PreparedStatement psc = this.getConexion().prepareStatement("SELECT * FROM calificacion WHERE id =? ");
                    psc.setInt(1, supletorio.getIdCalificacion());
                    ResultSet rsc = psc.executeQuery();
                    ps.setInt(1, supletorio.getId());
                    ps.setInt(2, rsc.getInt("id_aplicacion"));
                    ps.setObject(3, (Object)supletorio.getNotaSupletorio(), 8);
                    ps.setObject(4, (Object)supletorio.getNotaRemedial(), 8);
                    ps.setString(5, supletorio.getTipoExamen());
                    ps.setString(6, supletorio.getRegAnioInicio());
                    ps.setInt(7, supletorio.getIdUsuarioCreacion());
                    ps.setObject(8, (Object)supletorio.getNotaGracia(), 8);
                    ps.addBatch();
                }
                ps.executeBatch();
                this.getConexion().commit();
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.cerrar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void guardar(Supletorio supletorio) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " INSERT INTO supletorio(id_calificacion, nota_supletorio,nota_remedial,tipo_examen,reg_anio_inicio,id_usuario_creacion,nota_gracia )  values(?,?,?,?,?,?,? )";
        try {
            run.update(conn, sql, new Object[]{supletorio.getCalificacion().getIdAplicacion(), supletorio.getNotaSupletorio(), supletorio.getNotaRemedial(), supletorio.getTipoExamen(), supletorio.getRegAnioInicio(), supletorio.getIdUsuarioCreacion(), supletorio.getNotaGracia()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Supletorio obtenerPorId(Integer id) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(Supletorio.class);
        Supletorio supletorio = null;
        try {
            supletorio = (Supletorio)run.query(conn, "SELECT r.id_aplicacion as idAplicacion, r.id_calificacion as idCalificacion, r.nota_supletorio as notaSupletorio, r.nota_remedial as notaRemedial, r.nota_gracia as notaGracia  FROM supletorio r  WHERE  r.id_aplicacion = ? ", (ResultSetHandler)handler, new Object[]{id});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
        return supletorio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizar(Supletorio supletorio) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE supletorio set id_calificacion = ?, nota_supletorio = ?, nota_remedial = ?, nota_gracia = ?, id_usuario_creacion = ?, reg_anio_inicio = ?  where id_aplicacion= ? ";
        try {
            run.update(conn, sql, new Object[]{supletorio.getCalificacion().getIdAplicacion(), supletorio.getNotaSupletorio(), supletorio.getNotaRemedial(), supletorio.getNotaGracia(), supletorio.getIdUsuarioCreacion(), supletorio.getRegAnioInicio(), supletorio.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public Supletorio buscarPorIdCalificacion(Integer id) throws Exception {
        Supletorio supletorio = new Supletorio();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion, ");
            query.append(" r.id_calificacion as idCalificacion, ");
            query.append(" r.nota_supletorio as notaSupletorio, ");
            query.append(" r.nota_remedial as notaRemedial, ");
            query.append(" r.nota_gracia as notaGracia ");
            query.append(" FROM supletorio r ");
            query.append(" WHERE ");
            query.append(" r.id_calificacion = ? ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                supletorio = new Supletorio();
                supletorio.setIdAplicacion(rs.getInt("idAplicacion"));
                supletorio.setIdCalificacion(rs.getInt("idCalificacion"));
                supletorio.setNotaSupletorio(rs.getBigDecimal("notaSupletorio"));
                supletorio.setNotaRemedial(rs.getBigDecimal("notaRemedial"));
                supletorio.setNotaGracia(rs.getBigDecimal("notaGracia"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return supletorio;
    }

    @Override
    public List<Supletorio> obtenerPorParalelo(Integer idEscenario, Integer idEscenarioDiscrecion) throws Exception {
        ArrayList<Supletorio> supletorio = new ArrayList<Supletorio>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion, ");
            query.append(" c.id as idCalificacion, ");
            query.append(" r.nota_supletorio as notaSupletorio, ");
            query.append(" r.nota_remedial as notaRemedial, ");
            query.append(" r.nota_gracia as notaGracia, ");
            query.append(" r.tipo_examen as tipoExamen,");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion,");
            query.append(" r.reg_anio_inicio as regAnioInicio,");
            query.append(" r.id as id");
            query.append(" FROM supletorio r ");
            query.append(" join calificacion c on c.id_aplicacion=r.id_calificacion ");
            query.append(" where  c.id_escenario=? ");
            if (idEscenarioDiscrecion == null || idEscenarioDiscrecion == 0) {
                query.append("and c.id_escenario_discrecion is null ");
            } else {
                query.append("and c.id_escenario_discrecion=? ");
            }
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ps.setInt(1, idEscenario);
            if (idEscenarioDiscrecion != null && idEscenarioDiscrecion != 0) {
                ps.setInt(2, idEscenarioDiscrecion);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Supletorio nota = new Supletorio();
                nota.setIdAplicacion(rs.getInt("idAplicacion"));
                nota.setIdCalificacion(rs.getInt("idCalificacion"));
                nota.setNotaSupletorio(rs.getBigDecimal("notaSupletorio"));
                nota.setNotaRemedial(rs.getBigDecimal("notaRemedial"));
                nota.setNotaGracia(rs.getBigDecimal("notaGracia"));
                nota.setTipoExamen(rs.getString("tipoExamen"));
                nota.setId(rs.getInt("id"));
                nota.setRegAnioInicio(rs.getString("regAnioInicio"));
                nota.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                supletorio.add(nota);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return supletorio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actualizarNotaSincronizacion(Supletorio suple) {
        Connection conn = this.getConnection();
        QueryRunner run = new QueryRunner();
        String sql = " UPDATE supletorio set id = ?,codigo_error = ? where id_aplicacion =? ";
        try {
            run.update(conn, sql, new Object[]{suple.getId(), suple.getCodigoError(), suple.getIdAplicacion()});
        }
        catch (SQLException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            try {
                this.cerrarExterno(conn);
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public List<Supletorio> buscarTodo() throws Exception {
        ArrayList<Supletorio> supletorio = new ArrayList<Supletorio>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(" SELECT r.id_aplicacion as idAplicacion, ");
            query.append(" c.id as idCalificacion, ");
            query.append(" r.nota_supletorio as notaSupletorio, ");
            query.append(" r.nota_remedial as notaRemedial, ");
            query.append(" r.nota_gracia as notaGracia, ");
            query.append(" r.tipo_examen as tipoExamen,");
            query.append(" r.id_usuario_creacion as idUsuarioCreacion,");
            query.append(" r.reg_anio_inicio as regAnioInicio,");
            query.append(" r.id as id");
            query.append(" FROM supletorio r ");
            query.append(" join calificacion c on c.id_aplicacion=r.id_calificacion ");
            query.append(" join instructor i on i.id=c.id_instructor ");
            this.Conectar();
            PreparedStatement ps = this.getConexion().prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Supletorio nota = new Supletorio();
                nota.setIdAplicacion(rs.getInt("idAplicacion"));
                nota.setIdCalificacion(rs.getInt("idCalificacion"));
                nota.setNotaSupletorio(rs.getBigDecimal("notaSupletorio"));
                nota.setNotaRemedial(rs.getBigDecimal("notaRemedial"));
                nota.setNotaGracia(rs.getBigDecimal("notaGracia"));
                nota.setTipoExamen(rs.getString("tipoExamen"));
                nota.setId(rs.getInt("id"));
                nota.setRegAnioInicio(rs.getString("regAnioInicio"));
                nota.setIdUsuarioCreacion(rs.getInt("idUsuarioCreacion"));
                supletorio.add(nota);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.cerrar();
        }
        return supletorio;
    }
}

