/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Modelos.Dao.AsistenciaEducacionBasicaDao;
import Modelos.Dao.AsistenciaEducacionBasicaDaoImpl;
import Modelos.Dao.MesDao;
import Modelos.Dao.MesDaoImpl;
import Modelos.Entidades.AsistenciaEducacionBasica;
import Modelos.Entidades.DestrezaPca;
import Modelos.Entidades.Mes;
import Servicios.MD5;
import Util.Constantes;
import Util.DestrezaPcaUtil;
import Util.DiasSemana;
import Util.DiasSemanaHora;
import Util.DocumentSizeFilter;
import Util.MsgLog;
import Util.ObtenerPropiedad;
import ec.gob.educacion.encripta.UtilEncripta;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import org.apache.commons.lang.exception.ExceptionUtils;

public class Util {
    private final MesDao mesDao = new MesDaoImpl();
    private final AsistenciaEducacionBasicaDao asistenciaEGBDao = new AsistenciaEducacionBasicaDaoImpl();

    public static int getNumeroDiasMes(int mes) {
        int diasMes = 0;
        try {
            Calendar fecha = Calendar.getInstance();
            fecha.set(fecha.get(1), mes, 0);
            diasMes = fecha.getActualMaximum(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return diasMes;
    }

    public static List<DiasSemana> getDiasMes(int mes) {
        ArrayList<DiasSemana> dias = new ArrayList<DiasSemana>();
        try {
            Calendar cal = Calendar.getInstance();
            int anio = cal.get(1);
            String diaInicio = anio + "/" + mes + "/01";
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd");
            Date diaComparar = dateFormatter.parse(diaInicio);
            cal.setTime(diaComparar);
            cal.set(5, 1);
            int myMonth = cal.get(2);
            while (myMonth == cal.get(2)) {
                dateFormatter = new SimpleDateFormat("EEEE");
                String diaLetras = dateFormatter.format(cal.getTime());
                DiasSemana dia = new DiasSemana(diaLetras);
                dateFormatter = new SimpleDateFormat("d");
                String diaNumero = dateFormatter.format(cal.getTime());
                dia.setDiaNumero(Integer.valueOf(diaNumero));
                dias.add(dia);
                cal.add(5, 1);
            }
        }
        catch (NumberFormatException | ParseException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return dias;
    }

    public static List<DiasSemana> getDiasMesConAnio(int mes, int anio, String diaInicioParametro, String diaFinParametro) {
        ArrayList<DiasSemana> dias = new ArrayList<DiasSemana>();
        try {
            Calendar cal = Calendar.getInstance();
            String diaInicio = anio + "-" + mes + "-01";
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            Date diaComparar = dateFormatter.parse(diaInicio);
            Date inicioClases = dateFormatter.parse(diaInicioParametro);
            Date finClases = dateFormatter.parse(diaFinParametro);
            Date diaActualComparacion = new Date();
            Date diaActual = null;
            diaActual = diaActualComparacion.before(finClases) ? diaActualComparacion : finClases;
            cal.setTime(diaComparar);
            cal.set(5, 1);
            int myMonth = cal.get(2);
            while (myMonth == cal.get(2)) {
                if ((cal.getTime().after(inicioClases) || cal.getTime().equals(inicioClases)) && (cal.getTime().before(diaActual) || cal.getTime().equals(diaActual))) {
                    dateFormatter = new SimpleDateFormat("EEEE");
                    String diaLetras = dateFormatter.format(cal.getTime());
                    DiasSemana dia = new DiasSemana(diaLetras);
                    dateFormatter = new SimpleDateFormat("d");
                    String diaNumero = dateFormatter.format(cal.getTime());
                    dia.setDiaNumero(Integer.valueOf(diaNumero));
                    dias.add(dia);
                }
                cal.add(5, 1);
            }
        }
        catch (NumberFormatException | ParseException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return dias;
    }

    public static List<DiasSemanaHora> getDiasRangoFechas(String fechaInicial, String fechaFinal) {
        ArrayList<DiasSemanaHora> dias = new ArrayList<DiasSemanaHora>();
        try {
            SimpleDateFormat formatoFecha = new SimpleDateFormat("dd/MM/yyyy");
            Calendar fecIni = Calendar.getInstance();
            fecIni.setTime(formatoFecha.parse(fechaInicial));
            Calendar fecFin = Calendar.getInstance();
            fecFin.setTime(formatoFecha.parse(fechaFinal));
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(fecFin.getTime().getTime() - fecIni.getTime().getTime());
            Date dateFin = fecFin.getTime();
            Date dateIni = fecIni.getTime();
            long numDias = (dateFin.getTime() - dateIni.getTime()) / 86400000L;
            int numAux = 0;
            while ((long)numAux <= numDias) {
                formatoFecha = new SimpleDateFormat("EEEE");
                String diaLetras = formatoFecha.format(fecIni.getTime());
                DiasSemanaHora dia = new DiasSemanaHora(diaLetras);
                formatoFecha = new SimpleDateFormat("d");
                String diaNumero = formatoFecha.format(fecIni.getTime());
                dia.setDiaNumero(Integer.valueOf(diaNumero));
                dia.setDia(fecIni.getTime());
                dias.add(dia);
                fecIni.add(5, 1);
                ++numAux;
            }
        }
        catch (NumberFormatException | ParseException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return dias;
    }

    public List<Mes> listaMesesAnioEntreDosFechas(String fechaInicio, String fechaFinal) {
        ArrayList<Mes> mesesPresentar = new ArrayList<Mes>();
        SimpleDateFormat formaterMes = new SimpleDateFormat("M");
        SimpleDateFormat formaterAnio = new SimpleDateFormat("yyyy");
        SimpleDateFormat formatoFechas = new SimpleDateFormat("yyyy-MM-dd");
        Calendar beginCalendar = Calendar.getInstance();
        Calendar finishCalendar = Calendar.getInstance();
        try {
            beginCalendar.setTime(formatoFechas.parse(formaterAnio.format(formatoFechas.parse(fechaInicio)) + "-" + formaterMes.format(formatoFechas.parse(fechaInicio)) + "-01"));
            finishCalendar.setTime(formatoFechas.parse(fechaFinal));
        }
        catch (ParseException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
            try {
                String mes = formaterMes.format(beginCalendar.getTime());
                String anio = formaterAnio.format(beginCalendar.getTime());
                Mes nuevoMes = this.mesDao.buscarPorId(Integer.valueOf(mes));
                nuevoMes.setAnio(Integer.valueOf(anio));
                mesesPresentar.add(nuevoMes);
            }
            catch (NumberFormatException e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
            beginCalendar.add(2, 1);
        }
        return mesesPresentar;
    }

    public static void setearValoresInicialesAsistenciaEGB(AsistenciaEducacionBasica nuevaAsistencia, List<DiasSemana> diasSemana) {
        for (DiasSemana dia : diasSemana) {
            if (dia.isFinDeSemana()) continue;
            switch (dia.getDiaNumero()) {
                case 1: {
                    nuevaAsistencia.setDia1(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 2: {
                    nuevaAsistencia.setDia2(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 3: {
                    nuevaAsistencia.setDia3(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 4: {
                    nuevaAsistencia.setDia4(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 5: {
                    nuevaAsistencia.setDia5(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 6: {
                    nuevaAsistencia.setDia6(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 7: {
                    nuevaAsistencia.setDia7(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 8: {
                    nuevaAsistencia.setDia8(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 9: {
                    nuevaAsistencia.setDia9(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 10: {
                    nuevaAsistencia.setDia10(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 11: {
                    nuevaAsistencia.setDia11(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 12: {
                    nuevaAsistencia.setDia12(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 13: {
                    nuevaAsistencia.setDia13(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 14: {
                    nuevaAsistencia.setDia14(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 15: {
                    nuevaAsistencia.setDia15(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 16: {
                    nuevaAsistencia.setDia16(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 17: {
                    nuevaAsistencia.setDia17(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 18: {
                    nuevaAsistencia.setDia18(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 19: {
                    nuevaAsistencia.setDia19(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 20: {
                    nuevaAsistencia.setDia20(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 21: {
                    nuevaAsistencia.setDia21(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 22: {
                    nuevaAsistencia.setDia22(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 23: {
                    nuevaAsistencia.setDia23(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 24: {
                    nuevaAsistencia.setDia24(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 25: {
                    nuevaAsistencia.setDia25(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 26: {
                    nuevaAsistencia.setDia26(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 27: {
                    nuevaAsistencia.setDia27(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 28: {
                    nuevaAsistencia.setDia28(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 29: {
                    nuevaAsistencia.setDia29(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 30: {
                    nuevaAsistencia.setDia30(Constantes.ASISTIO_BOOLEANO);
                    break;
                }
                case 31: {
                    nuevaAsistencia.setDia31(Constantes.ASISTIO_BOOLEANO);
                }
            }
        }
    }

    public static void setearValoresInicialesRetiroEGB(AsistenciaEducacionBasica nuevaAsistencia, List<DiasSemana> diasSemana) {
        for (DiasSemana dia : diasSemana) {
            if (dia.isFinDeSemana()) continue;
            switch (dia.getDiaNumero()) {
                case 1: {
                    nuevaAsistencia.setDia1(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 2: {
                    nuevaAsistencia.setDia2(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 3: {
                    nuevaAsistencia.setDia3(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 4: {
                    nuevaAsistencia.setDia4(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 5: {
                    nuevaAsistencia.setDia5(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 6: {
                    nuevaAsistencia.setDia6(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 7: {
                    nuevaAsistencia.setDia7(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 8: {
                    nuevaAsistencia.setDia8(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 9: {
                    nuevaAsistencia.setDia9(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 10: {
                    nuevaAsistencia.setDia10(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 11: {
                    nuevaAsistencia.setDia11(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 12: {
                    nuevaAsistencia.setDia12(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 13: {
                    nuevaAsistencia.setDia13(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 14: {
                    nuevaAsistencia.setDia14(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 15: {
                    nuevaAsistencia.setDia15(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 16: {
                    nuevaAsistencia.setDia16(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 17: {
                    nuevaAsistencia.setDia17(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 18: {
                    nuevaAsistencia.setDia18(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 19: {
                    nuevaAsistencia.setDia19(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 20: {
                    nuevaAsistencia.setDia20(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 21: {
                    nuevaAsistencia.setDia21(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 22: {
                    nuevaAsistencia.setDia22(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 23: {
                    nuevaAsistencia.setDia23(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 24: {
                    nuevaAsistencia.setDia24(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 25: {
                    nuevaAsistencia.setDia25(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 26: {
                    nuevaAsistencia.setDia26(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 27: {
                    nuevaAsistencia.setDia27(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 28: {
                    nuevaAsistencia.setDia28(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 29: {
                    nuevaAsistencia.setDia29(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 30: {
                    nuevaAsistencia.setDia30(Constantes.ASISTIO_BOOLEANO == false);
                    break;
                }
                case 31: {
                    nuevaAsistencia.setDia31(Constantes.ASISTIO_BOOLEANO == false);
                }
            }
        }
    }

    public void validarFechaActualAsistenciaEGB(AsistenciaEducacionBasica asistenciaGuardada, List<DiasSemana> diasSemana, int mesConsultado) {
        Date fechaActual = new Date();
        SimpleDateFormat formatoFecha = new SimpleDateFormat("M");
        String mesNumero = formatoFecha.format(fechaActual.getTime());
        int mesActual = Integer.valueOf(mesNumero);
        formatoFecha = new SimpleDateFormat("d");
        String diaNumero = formatoFecha.format(fechaActual.getTime());
        int diaActual = Integer.valueOf(diaNumero);
        if (asistenciaGuardada.getAsisteClases() != null) {
            for (DiasSemana diasSemana1 : diasSemana) {
                if (mesConsultado == mesActual && diasSemana1.getDiaNumero() <= diaActual && !diasSemana1.isFinDeSemana()) {
                    this.setearValoresRetiroEGB(diasSemana1, asistenciaGuardada);
                    continue;
                }
                if (diasSemana1.isFinDeSemana()) continue;
                this.setearValoresRetiroEGB(diasSemana1, asistenciaGuardada);
            }
        } else {
            for (DiasSemana diasSemana1 : diasSemana) {
                if (mesConsultado == mesActual && diasSemana1.getDiaNumero() <= diaActual && !diasSemana1.isFinDeSemana()) {
                    this.setearValoresAsistenciaEGB(diasSemana1, asistenciaGuardada);
                    continue;
                }
                if (diasSemana1.isFinDeSemana()) continue;
                this.setearValoresAsistenciaEGB(diasSemana1, asistenciaGuardada);
            }
        }
    }

    private void setearValoresAsistenciaEGB(DiasSemana diaSemana, AsistenciaEducacionBasica asistenciaGuardada) {
        switch (diaSemana.getDiaNumero()) {
            case 1: {
                if (asistenciaGuardada.getDia1() != null) break;
                asistenciaGuardada.setDia1(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 2: {
                if (asistenciaGuardada.getDia2() != null) break;
                asistenciaGuardada.setDia2(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 3: {
                if (asistenciaGuardada.getDia3() != null) break;
                asistenciaGuardada.setDia3(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 4: {
                if (asistenciaGuardada.getDia4() != null) break;
                asistenciaGuardada.setDia4(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 5: {
                if (asistenciaGuardada.getDia5() != null) break;
                asistenciaGuardada.setDia5(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 6: {
                if (asistenciaGuardada.getDia6() != null) break;
                asistenciaGuardada.setDia6(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 7: {
                if (asistenciaGuardada.getDia7() != null) break;
                asistenciaGuardada.setDia7(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 8: {
                if (asistenciaGuardada.getDia8() != null) break;
                asistenciaGuardada.setDia8(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 9: {
                if (asistenciaGuardada.getDia9() != null) break;
                asistenciaGuardada.setDia9(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 10: {
                if (asistenciaGuardada.getDia10() != null) break;
                asistenciaGuardada.setDia10(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 11: {
                if (asistenciaGuardada.getDia11() != null) break;
                asistenciaGuardada.setDia11(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 12: {
                if (asistenciaGuardada.getDia12() != null) break;
                asistenciaGuardada.setDia12(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 13: {
                if (asistenciaGuardada.getDia13() != null) break;
                asistenciaGuardada.setDia13(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 14: {
                if (asistenciaGuardada.getDia14() != null) break;
                asistenciaGuardada.setDia14(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 15: {
                if (asistenciaGuardada.getDia15() != null) break;
                asistenciaGuardada.setDia15(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 16: {
                if (asistenciaGuardada.getDia16() != null) break;
                asistenciaGuardada.setDia16(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 17: {
                if (asistenciaGuardada.getDia17() != null) break;
                asistenciaGuardada.setDia17(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 18: {
                if (asistenciaGuardada.getDia18() != null) break;
                asistenciaGuardada.setDia18(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 19: {
                if (asistenciaGuardada.getDia19() != null) break;
                asistenciaGuardada.setDia19(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 20: {
                if (asistenciaGuardada.getDia20() != null) break;
                asistenciaGuardada.setDia20(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 21: {
                if (asistenciaGuardada.getDia21() != null) break;
                asistenciaGuardada.setDia21(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 22: {
                if (asistenciaGuardada.getDia22() != null) break;
                asistenciaGuardada.setDia22(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 23: {
                if (asistenciaGuardada.getDia23() != null) break;
                asistenciaGuardada.setDia23(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 24: {
                if (asistenciaGuardada.getDia24() != null) break;
                asistenciaGuardada.setDia24(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 25: {
                if (asistenciaGuardada.getDia25() != null) break;
                asistenciaGuardada.setDia25(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 26: {
                if (asistenciaGuardada.getDia26() != null) break;
                asistenciaGuardada.setDia26(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 27: {
                if (asistenciaGuardada.getDia27() != null) break;
                asistenciaGuardada.setDia27(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 28: {
                if (asistenciaGuardada.getDia28() != null) break;
                asistenciaGuardada.setDia28(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 29: {
                if (asistenciaGuardada.getDia29() != null) break;
                asistenciaGuardada.setDia29(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 30: {
                if (asistenciaGuardada.getDia30() != null) break;
                asistenciaGuardada.setDia30(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 31: {
                if (asistenciaGuardada.getDia31() != null) break;
                asistenciaGuardada.setDia31(Constantes.ASISTIO_BOOLEANO);
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
            }
        }
    }

    private void setearValoresRetiroEGB(DiasSemana diaSemana, AsistenciaEducacionBasica asistenciaGuardada) {
        switch (diaSemana.getDiaNumero()) {
            case 1: {
                asistenciaGuardada.setDia1(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 2: {
                asistenciaGuardada.setDia2(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 3: {
                asistenciaGuardada.setDia3(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 4: {
                asistenciaGuardada.setDia4(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 5: {
                asistenciaGuardada.setDia5(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 6: {
                asistenciaGuardada.setDia6(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 7: {
                asistenciaGuardada.setDia7(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 8: {
                asistenciaGuardada.setDia8(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 9: {
                asistenciaGuardada.setDia9(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 10: {
                asistenciaGuardada.setDia10(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 11: {
                asistenciaGuardada.setDia11(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 12: {
                asistenciaGuardada.setDia12(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 13: {
                asistenciaGuardada.setDia13(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 14: {
                asistenciaGuardada.setDia14(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 15: {
                asistenciaGuardada.setDia15(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 16: {
                asistenciaGuardada.setDia16(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 17: {
                asistenciaGuardada.setDia17(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 18: {
                asistenciaGuardada.setDia18(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 19: {
                asistenciaGuardada.setDia19(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 20: {
                asistenciaGuardada.setDia20(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 21: {
                asistenciaGuardada.setDia21(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 22: {
                asistenciaGuardada.setDia22(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 23: {
                asistenciaGuardada.setDia23(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 24: {
                asistenciaGuardada.setDia24(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 25: {
                asistenciaGuardada.setDia25(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 26: {
                asistenciaGuardada.setDia26(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 27: {
                asistenciaGuardada.setDia27(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 28: {
                asistenciaGuardada.setDia28(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 29: {
                asistenciaGuardada.setDia29(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 30: {
                asistenciaGuardada.setDia30(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
                break;
            }
            case 31: {
                asistenciaGuardada.setDia31(asistenciaGuardada.getAsisteClases());
                this.asistenciaEGBDao.actualizarAsistencia(asistenciaGuardada);
            }
        }
    }

    public static Boolean encriptaArchivoBB(String url) {
        Boolean exito = false;
        try {
            if (UtilEncripta.encriptaArchivoBB((String)url).booleanValue()) {
                File archivoBB = new File(url);
                ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                exito = true;
            }
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return exito;
    }

    public static Boolean desencriptaArchivoBB(String url) {
        Boolean exito = false;
        try {
            File archivoBB = new File(url);
            String ultimaModificacion = String.valueOf(archivoBB.lastModified());
            if (!UtilEncripta.desencriptaArchivoBB((String)url).booleanValue()) {
                exito = MD5.getMD5(ultimaModificacion).equals(ObtenerPropiedad.obtenerPropiedad("ortografia"));
            } else {
                ObtenerPropiedad.ModificarPropiedad("ortografia", MD5.getMD5(String.valueOf(archivoBB.lastModified())));
                exito = true;
            }
        }
        catch (IOException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return exito;
    }

    public static boolean openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return false;
    }

    public static boolean openWebpage(URL url) {
        try {
            return Util.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            MsgLog.write(ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    public static void setMaxCaracteres(JTextArea t, int maxChars) {
        AbstractDocument pDoc = (AbstractDocument)t.getDocument();
        pDoc.setDocumentFilter(new DocumentSizeFilter(maxChars));
    }

    public static void setMaxCaracteres(JEditorPane t, int maxChars) {
        AbstractDocument pDoc = (AbstractDocument)t.getDocument();
        pDoc.setDocumentFilter(new DocumentSizeFilter(maxChars));
    }

    public static void setMaxCaracteres(JTextField t, int maxChars) {
        AbstractDocument pDoc = (AbstractDocument)t.getDocument();
        pDoc.setDocumentFilter(new DocumentSizeFilter(maxChars));
    }

    public static void ejecutarGC() {
        Runtime r = Runtime.getRuntime();
        r.gc();
    }

    public static List<DestrezaPcaUtil> obtenerDestrezaPcaUtil(List<DestrezaPca> listaDestrezaPca) {
        ArrayList<DestrezaPcaUtil> listaDestrezaPcaUtil = null;
        if (null != listaDestrezaPca && !listaDestrezaPca.isEmpty()) {
            listaDestrezaPcaUtil = new ArrayList<DestrezaPcaUtil>();
            int size = listaDestrezaPca.size();
            for (int i = 0; i < size; ++i) {
                DestrezaPca d = listaDestrezaPca.get(i);
                listaDestrezaPcaUtil.add(new DestrezaPcaUtil(d.getId(), d.getColor(), d.getNombre(), d.getDescripcion(), d.getTipo()));
            }
        }
        return listaDestrezaPcaUtil;
    }

    public static JScrollPane obtenerScrollPaneTextos(Component c, Dimension d) {
        return Util.obtenerScrollPaneTextos(c, d, 20, 30);
    }

    public static JScrollPane obtenerScrollPaneTextos(Component c, Dimension d, int sVertival, int sHorizontal) {
        JScrollPane scroll = new JScrollPane(c);
        scroll.setViewportBorder(null);
        scroll.getViewport().setBorder(null);
        scroll.setBorder(null);
        scroll.getViewport().setPreferredSize(d);
        scroll.setVerticalScrollBarPolicy(sVertival);
        scroll.setHorizontalScrollBarPolicy(sHorizontal);
        return scroll;
    }

    public static String concatena(String ... values) {
        StringBuilder sb = new StringBuilder();
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            sb.append(values[i]);
        }
        return sb.toString();
    }

    public static Boolean htmlIsEmpty(String html) {
        return html.replaceAll("<.*?>", "").trim().isEmpty();
    }
}

