/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Modelos.Dao.AsistenciaBachilleratoDaoImpl;
import Modelos.Dao.PeriodoAnioLectivoDao;
import Modelos.Dao.PeriodoAnioLectivoDaoImpl;
import Modelos.Dao.RegistroAnioLectivoDaoImpl;
import Modelos.Dao.ResgistroAnioLectivoDao;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.PeriodoAnioLectivo;
import Modelos.Entidades.RegistroAnioLectivo;
import Vistas.FuncionesAuxiliar;
import Vistas.model.AsistenciaBGUTableJbroModel;
import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VistaAsistenciaBachillerato
extends JPanel {
    private Integer codigoParaleloSeleccionado;
    private List<Asignacion> asignacion = new ArrayList<Asignacion>();
    private final JDateChooser dateChooserMesInicio = new JDateChooser();
    private final JDateChooser dateChooserMesFin = new JDateChooser();
    private final AsistenciaBachilleratoDaoImpl asistenciaBachilleratoDaoImpl = new AsistenciaBachilleratoDaoImpl();
    private final ResgistroAnioLectivoDao registroAnioLectivoDao = new RegistroAnioLectivoDaoImpl();
    private final PeriodoAnioLectivoDao periodoAnioLectivoDao = new PeriodoAnioLectivoDaoImpl();
    private RegistroAnioLectivo regAniLec;
    private PeriodoAnioLectivo periodoAnioLectivoQ1;
    private PeriodoAnioLectivo periodoAnioLectivoQ2;
    private Instructor instructor;
    private Panel panel1;
    private JPanel panelCombo;
    private JPanel panelTablaAsistencia;

    public VistaAsistenciaBachillerato() {
        this.initComponents();
        Calendar maxDate = Calendar.getInstance();
        maxDate.setTime(new Date());
        JPanel panelAgrupadoComboLabel = new JPanel();
        this.dateChooserMesInicio.setPreferredSize(new Dimension(150, 25));
        this.dateChooserMesInicio.setDateFormatString("dd/MM/yyyy");
        this.dateChooserMesInicio.setMaxSelectableDate(maxDate.getTime());
        JLabel etiquetaMesInicial = new JLabel("* Fecha Inicio:");
        panelAgrupadoComboLabel.add(etiquetaMesInicial);
        panelAgrupadoComboLabel.add((Component)this.dateChooserMesInicio);
        panelAgrupadoComboLabel.setBorder(new EmptyBorder(25, 25, 25, 25));
        this.dateChooserMesFin.setPreferredSize(new Dimension(150, 25));
        this.dateChooserMesFin.setDateFormatString("dd/MM/yyyy");
        this.dateChooserMesFin.setMaxSelectableDate(maxDate.getTime());
        JLabel etiquetaMesFinal = new JLabel("* Fecha Fin:");
        panelAgrupadoComboLabel.add(etiquetaMesFinal);
        panelAgrupadoComboLabel.add((Component)this.dateChooserMesFin);
        panelAgrupadoComboLabel.setBorder(new EmptyBorder(25, 25, 25, 25));
        panelAgrupadoComboLabel.setBackground(new Color(245, 245, 245));
        this.panelCombo.setLayout(new BorderLayout());
        this.panelCombo.setBackground(new Color(245, 245, 245));
        this.panelCombo.add((Component)panelAgrupadoComboLabel, "Before");
        this.cargarEventoInicial();
        this.cargarEvento();
        this.panelTablaAsistencia.setLayout(new BorderLayout());
        JPanel panelInformacion = new JPanel();
        JPanel panelAuxiliar = new JPanel();
        JLabel informacionInicial = new JLabel("Estimado docente, seleccione un rango de fechas. ");
        informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
        panelInformacion.add((Component)informacionInicial, "Center");
        panelInformacion.setBackground(new Color(252, 248, 227));
        panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
        panelAuxiliar.add(panelInformacion);
        panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCombo, "First");
        this.add((Component)this.panelTablaAsistencia, "Center");
    }

    private void initComponents() {
        this.panel1 = new Panel();
        this.panelTablaAsistencia = new JPanel();
        this.panelCombo = new JPanel();
        this.setPreferredSize(new Dimension(452, 402));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTablaAsistencia, "Center");
        this.add((Component)this.panelCombo, "First");
    }

    private void cargarEvento() {
        this.dateChooserMesFin.getDateEditor().addPropertyChangeListener(e -> {
            if ("date".equals(e.getPropertyName())) {
                this.getRangoSeleccionado();
                this.panelTablaAsistencia.updateUI();
                this.updateUI();
            }
        });
    }

    private void cargarEventoInicial() {
        this.dateChooserMesInicio.getDateEditor().addPropertyChangeListener(e -> {
            if ("date".equals(e.getPropertyName()) && this.dateChooserMesFin.getDate() != null) {
                this.getRangoSeleccionado();
                this.panelTablaAsistencia.updateUI();
                this.updateUI();
            }
        });
    }

    public void iniciarCarga(Integer codigoParalelo, Integer idRegistrAnioLectivo, Instructor instructor) {
        this.codigoParaleloSeleccionado = codigoParalelo;
        this.instructor = instructor;
        try {
            this.regAniLec = this.registroAnioLectivoDao.buscarPorId(idRegistrAnioLectivo);
            this.periodoAnioLectivoQ1 = this.periodoAnioLectivoDao.buscarPorAniLecModelo(idRegistrAnioLectivo, 2);
            this.periodoAnioLectivoQ2 = this.periodoAnioLectivoDao.buscarPorAniLecModelo(idRegistrAnioLectivo, 3);
            SimpleDateFormat formatoFecha = new SimpleDateFormat("yyy-MM-dd");
            Calendar minDate = Calendar.getInstance();
            minDate.setTime(formatoFecha.parse(this.periodoAnioLectivoQ1.getFechaInicio()));
            Calendar maxDate = Calendar.getInstance();
            maxDate.setTime(formatoFecha.parse(this.periodoAnioLectivoQ2.getFechaFin()));
            Calendar nowDate = Calendar.getInstance();
            nowDate.setTime(formatoFecha.parse(formatoFecha.format(new Date())));
            this.dateChooserMesInicio.setMinSelectableDate(minDate.getTime());
            if (maxDate.compareTo(nowDate) == 0 || maxDate.compareTo(nowDate) == -1) {
                this.dateChooserMesInicio.setMaxSelectableDate(maxDate.getTime());
            } else {
                this.dateChooserMesInicio.setMaxSelectableDate(nowDate.getTime());
            }
            this.dateChooserMesFin.setMinSelectableDate(minDate.getTime());
            if (maxDate.compareTo(nowDate) == 0 || maxDate.compareTo(nowDate) == -1) {
                this.dateChooserMesFin.setMaxSelectableDate(maxDate.getTime());
            } else {
                this.dateChooserMesFin.setMaxSelectableDate(nowDate.getTime());
            }
            this.asignacion = this.asistenciaBachilleratoDaoImpl.buscarAsistenciaPorParalelo(this.codigoParaleloSeleccionado);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.asignacion = new ArrayList<Asignacion>();
        }
        if (this.asignacion.isEmpty()) {
            this.panelCombo.removeAll();
            this.panelTablaAsistencia.removeAll();
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("El paralelo no presenta estudiantes. Por favor comun\u00edquese con el rector de la instituci\u00f3n a la que pertenece el paralelo.");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelCombo.add((Component)panelAuxiliar, "First");
        }
    }

    public void getRangoSeleccionado() {
        this.panelTablaAsistencia.removeAll();
        if (this.dateChooserMesInicio.getDate().before(this.dateChooserMesFin.getDate())) {
            SimpleDateFormat formatoFecha = new SimpleDateFormat("dd/MM/yyyy");
            this.panelTablaAsistencia.add((Component)new AsistenciaBGUTableJbroModel(this.codigoParaleloSeleccionado, this.asignacion, formatoFecha.format(this.dateChooserMesInicio.getDate()), formatoFecha.format(this.dateChooserMesFin.getDate()), this.instructor, this.regAniLec, this.periodoAnioLectivoQ1, this.periodoAnioLectivoQ2).getScroll(), "Center");
        } else {
            JPanel panelInformacion = new JPanel();
            JPanel panelAuxiliar = new JPanel();
            JLabel informacionInicial = new JLabel("Rango incorrecto. La fecha inicial debe ser menor que la fecha final");
            informacionInicial.setFont(new FuncionesAuxiliar().establecerFont(4));
            panelInformacion.add((Component)informacionInicial, "Center");
            panelInformacion.setBackground(new Color(252, 248, 227));
            panelInformacion.setBorder(new EmptyBorder(10, 10, 10, 10));
            panelAuxiliar.add(panelInformacion);
            panelAuxiliar.setBorder(new EmptyBorder(15, 15, 15, 15));
            this.panelTablaAsistencia.add((Component)panelAuxiliar, "First");
        }
    }

    public Integer getCodigoParaleloSeleccionado() {
        return this.codigoParaleloSeleccionado;
    }

    public void setCodigoParaleloSeleccionado(Integer codigoParaleloSeleccionado) {
        this.codigoParaleloSeleccionado = codigoParaleloSeleccionado;
    }
}

