/*
 * Decompiled with CFR 0.152.
 */
package Vistas;

import Enumeradores.MaximoCaracteres;
import Modelos.Entidades.CriterioPca;
import Modelos.Entidades.DestrezaPca;
import Modelos.Entidades.OrientacionPca;
import Util.DestrezaPcaUtil;
import Util.Util;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class VistaSeleccionarDestrezaPCA
extends JDialog {
    private Map<JCheckBox, DestrezaPcaUtil> mapDestrezas;
    private Map<JCheckBox, OrientacionPca> mapOrientaciones;
    private JEditorPane jepTexto;
    protected JPanel jpnListaDestrezas;
    protected JPanel jpnListaCriterios;
    protected JPanel jpnListaOrientaciones;
    public JButton jbtAceptar;
    private JButton jbtCancelar;
    public JLabel jlbTitulo;
    private JScrollPane jspDestrezas;

    public VistaSeleccionarDestrezaPCA(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public void addDestrezas(List<DestrezaPcaUtil> listaDestrezas) {
        if (null != listaDestrezas && !listaDestrezas.isEmpty()) {
            this.jpnListaDestrezas = new JPanel();
            this.jpnListaDestrezas.setLayout(new BoxLayout(this.jpnListaDestrezas, 1));
            this.jpnListaDestrezas.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.mapDestrezas = new LinkedHashMap<JCheckBox, DestrezaPcaUtil>();
            Dimension dPanel = new Dimension(600, 80);
            FlowLayout lPanel = new FlowLayout(0);
            int size = listaDestrezas.size();
            for (int i = 0; i < size; ++i) {
                DestrezaPcaUtil d = listaDestrezas.get(i);
                JCheckBox ch = new JCheckBox();
                ch.setVerticalAlignment(1);
                JPanel jpnDestrezas = new JPanel(lPanel);
                jpnDestrezas.setPreferredSize(dPanel);
                jpnDestrezas.setAlignmentX(0.0f);
                d.getJepDetalle().setPreferredSize(jpnDestrezas.getPreferredSize());
                jpnDestrezas.add(ch);
                jpnDestrezas.add(d.getJepDetalle());
                switch (d.getTipo()) {
                    case IMPRESCINDIBLE: {
                        jpnDestrezas.setBackground(Color.LIGHT_GRAY);
                        ch.setBackground(Color.LIGHT_GRAY);
                        d.getJepDetalle().setBackground(Color.LIGHT_GRAY);
                        break;
                    }
                    default: {
                        jpnDestrezas.setBackground(Color.WHITE);
                        ch.setBackground(Color.WHITE);
                        d.getJepDetalle().setBackground(Color.WHITE);
                    }
                }
                this.jpnListaDestrezas.add(jpnDestrezas);
                this.mapDestrezas.put(ch, d);
            }
            this.jspDestrezas.setVerticalScrollBarPolicy(20);
            this.jspDestrezas.setHorizontalScrollBarPolicy(31);
        }
    }

    public void asignarDestrezasSeleccionadas(List<DestrezaPcaUtil> listaDestrezasSeleccionadas) {
        this.jspDestrezas.setViewportView(this.jpnListaDestrezas);
        if (null != listaDestrezasSeleccionadas && !listaDestrezasSeleccionadas.isEmpty()) {
            int i = 0;
            for (JCheckBox key : this.mapDestrezas.keySet()) {
                if (!listaDestrezasSeleccionadas.contains(this.mapDestrezas.get(key))) continue;
                key.setSelected(true);
                if (++i != listaDestrezasSeleccionadas.size()) continue;
                break;
            }
        }
    }

    public void addCriterios(List<CriterioPca> listaCriterios) {
        if (null != listaCriterios && !listaCriterios.isEmpty()) {
            this.jpnListaCriterios = new JPanel();
            this.jpnListaCriterios.setLayout(new BoxLayout(this.jpnListaCriterios, 1));
            for (CriterioPca c : listaCriterios) {
                JPanel jpnCriterios = new JPanel(new FlowLayout(0));
                jpnCriterios.setPreferredSize(new Dimension(650, 100));
                JEditorPane cri = new JEditorPane();
                cri.setContentType("text/html");
                cri.setText(c.getNombre() + " " + c.getDescripcion());
                cri.setPreferredSize(new Dimension(600, 100));
                jpnCriterios.add(cri);
                this.jpnListaCriterios.add(jpnCriterios);
            }
        }
    }

    public void addOrientaciones(Map<DestrezaPca, List<OrientacionPca>> mapOrientacionesAll, List<DestrezaPca> listaDestrezas, Map<DestrezaPca, List<OrientacionPca>> mapOrientacionesSeleccionadas) {
        this.jpnListaOrientaciones = new JPanel();
        this.jpnListaOrientaciones.setLayout(new BoxLayout(this.jpnListaOrientaciones, 1));
        this.jpnListaOrientaciones.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.mapOrientaciones = new LinkedHashMap<JCheckBox, OrientacionPca>();
        for (DestrezaPca d : listaDestrezas) {
            if (!mapOrientacionesAll.containsKey(d)) continue;
            for (OrientacionPca o : mapOrientacionesAll.get(d)) {
                if (this.mapOrientaciones.containsKey(d)) continue;
                JCheckBox ch = new JCheckBox();
                ch.setVerticalAlignment(1);
                ch.setSelected(mapOrientacionesSeleccionadas.get(d).contains(o));
                o.getJepDescripcion().setPreferredSize(new Dimension(580, 80));
                o.setDestreza(d);
                this.mapOrientaciones.put(ch, o);
            }
        }
        DestrezaPca daux = new DestrezaPca();
        for (JCheckBox key : this.mapOrientaciones.keySet()) {
            JPanel jpnOrientacion = new JPanel(new FlowLayout(0));
            jpnOrientacion.setPreferredSize(new Dimension(600, 80));
            jpnOrientacion.setAlignmentX(0.0f);
            jpnOrientacion.add(key);
            jpnOrientacion.add(this.mapOrientaciones.get(key).getJepDescripcion());
            if (!daux.equals(this.mapOrientaciones.get(key).getDestreza())) {
                String txtDestreza = this.mapOrientaciones.get(key).getDestreza().getNombre() + " " + this.mapOrientaciones.get(key).getDestreza().getDescripcion();
                this.jpnListaOrientaciones.add(new JLabel(txtDestreza));
                daux = this.mapOrientaciones.get(key).getDestreza();
            }
            this.jpnListaOrientaciones.add(jpnOrientacion);
        }
    }

    public void asignarOrientacionesSeleccionados() {
        this.jspDestrezas.setViewportView(this.jpnListaOrientaciones);
    }

    public void asignarCriteriosSeleccionados() {
        this.jspDestrezas.setViewportView(this.jpnListaCriterios);
    }

    public void addTexto() {
        this.jepTexto = new JEditorPane();
        this.jepTexto.setContentType("text/html");
        Util.setMaxCaracteres(this.jepTexto, MaximoCaracteres.MAX_5000.getValor());
        this.jspDestrezas.setViewportView(this.jepTexto);
        this.jspDestrezas.setVerticalScrollBarPolicy(20);
        this.jspDestrezas.setHorizontalScrollBarPolicy(30);
    }

    public void asignarTexto(JEditorPane jepTextoInicial) {
        this.jepTexto.setText(jepTextoInicial.getText());
    }

    private void initComponents() {
        this.jlbTitulo = new JLabel();
        this.jspDestrezas = new JScrollPane();
        this.jbtAceptar = new JButton();
        this.jbtCancelar = new JButton();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(700, 393));
        this.setResizable(false);
        this.jlbTitulo.setFont(new Font("Tahoma", 1, 12));
        this.jlbTitulo.setText("DESTREZAS ASIGNADAS A LA UNIDAD");
        this.jlbTitulo.setName("jlbTitulo");
        this.jbtAceptar.setText("Aceptar");
        this.jbtAceptar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaSeleccionarDestrezaPCA.this.jbtAceptarActionPerformed(evt);
            }
        });
        this.jbtCancelar.setText("Cancelar");
        this.jbtCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaSeleccionarDestrezaPCA.this.jbtCancelarActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jspDestrezas)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(164, 164, 164).addComponent(this.jbtAceptar).addGap(18, 18, 18).addComponent(this.jbtCancelar)).addGroup(layout.createSequentialGroup().addGap(132, 132, 132).addComponent(this.jlbTitulo))).addGap(0, 124, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jlbTitulo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jspDestrezas, -1, 320, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbtAceptar).addComponent(this.jbtCancelar)).addContainerGap()));
        this.pack();
    }

    private void jbtAceptarActionPerformed(ActionEvent evt) {
    }

    private void jbtCancelarActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(VistaSeleccionarDestrezaPCA.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(VistaSeleccionarDestrezaPCA.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(VistaSeleccionarDestrezaPCA.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(VistaSeleccionarDestrezaPCA.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VistaSeleccionarDestrezaPCA dialog = new VistaSeleccionarDestrezaPCA((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public Map<JCheckBox, DestrezaPcaUtil> getMapDestrezas() {
        return this.mapDestrezas;
    }

    public void setMapDestrezas(Map<JCheckBox, DestrezaPcaUtil> mapDestrezas) {
        this.mapDestrezas = mapDestrezas;
    }

    public JEditorPane getJepTexto() {
        return this.jepTexto;
    }

    public void setJepTexto(JEditorPane jepTexto) {
        this.jepTexto = jepTexto;
    }

    public Map<JCheckBox, OrientacionPca> getMapOrientaciones() {
        return this.mapOrientaciones;
    }

    public void setMapOrientaciones(Map<JCheckBox, OrientacionPca> mapOrientaciones) {
        this.mapOrientaciones = mapOrientaciones;
    }
}

