/*
 * Decompiled with CFR 0.152.
 */
package Vistas.model;

import Modelos.Dao.JustificacionEducacionBasicaDao;
import Modelos.Dao.JustificacionEducacionBasicaDaoImpl;
import Modelos.Entidades.Asignacion;
import Modelos.Entidades.Instructor;
import Modelos.Entidades.JusticacionEducacionBasica;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import org.quinto.swing.table.model.ModelField;

public class EditaCeldaTablaFaltaJustificadaEGB
extends AbstractCellEditor
implements TableCellEditor {
    private JComponent componente = new JTextField();
    private final List<Asignacion> asistenciaEstudiantes;
    private final ModelField[] fields;
    private final Instructor instructor;
    private final JustificacionEducacionBasicaDao justificacionEducacionBasicaDao = new JustificacionEducacionBasicaDaoImpl();

    public EditaCeldaTablaFaltaJustificadaEGB(List<Asignacion> asistenciaEstudiantes, ModelField[] fields, Instructor instructor) {
        this.asistenciaEstudiantes = asistenciaEstudiantes;
        this.fields = fields;
        this.instructor = instructor;
    }

    @Override
    public Object getCellEditorValue() {
        Object o = null;
        return o;
    }

    @Override
    public Component getTableCellEditorComponent(JTable tabla, Object valorObjeto, boolean esSeleccionado, int fila, int columna) {
        boolean update = true;
        Asignacion asignacion = this.asistenciaEstudiantes.get(fila);
        String[] codigo = this.fields[columna].getIdentifier().split("-");
        String[] codigoFecha = codigo[0].split("/");
        JusticacionEducacionBasica asistencia = this.justificacionEducacionBasicaDao.buscarAsistenciaEstudiantePorDiaAsignacion(asignacion.getId(), codigo[0]);
        if (asistencia == null) {
            update = false;
            asistencia = new JusticacionEducacionBasica();
        }
        JPanel panelAgrupadoComboLabel = new JPanel();
        panelAgrupadoComboLabel.setLayout(new BoxLayout(panelAgrupadoComboLabel, 3));
        JPanel panelJustificar = new JPanel();
        JLabel etiquetaGrado = new JLabel("* Justificar: ");
        JCheckBox justificada = new JCheckBox();
        justificada.setPreferredSize(new Dimension(150, 25));
        justificada.setSelected(asistencia.getJustificada() == null ? false : asistencia.getJustificada());
        panelJustificar.add(etiquetaGrado);
        panelJustificar.add(justificada);
        panelJustificar.setBorder(new EmptyBorder(20, 54, 20, 0));
        panelAgrupadoComboLabel.add(panelJustificar);
        JTextArea display = new JTextArea(16, 58);
        display.setText(asistencia.getObservacionJustificacion());
        panelAgrupadoComboLabel.add(display);
        int resp = JOptionPane.showConfirmDialog(null, new JScrollPane(panelAgrupadoComboLabel), "Justificar Falta", 0);
        if (0 == resp) {
            asistencia.setIdAsignacion(asignacion.getId());
            asistencia.setFecha(codigo[0]);
            asistencia.setIdMes(Integer.valueOf(codigoFecha[1]));
            asistencia.setJustificada(justificada.isSelected());
            if (justificada.isSelected()) {
                asistencia.setObservacionJustificacion(display.getText());
            } else {
                asistencia.setObservacionJustificacion("");
            }
            asistencia.setEstado("1");
            asistencia.setRegAnioInicio(this.instructor.getAnioLectivoInicio() + "-" + this.instructor.getIdRegimen());
            asistencia.setIdUsuarioCreacion(this.instructor.getIdUsuario());
            if (update) {
                this.justificacionEducacionBasicaDao.actualizarAsistencia(asistencia);
            } else {
                this.justificacionEducacionBasicaDao.guardarAsistencia(asistencia);
            }
        }
        try {
            ((JTextField)this.componente).setText(display.getText());
        }
        catch (Exception e) {
            this.componente = new JTextField();
        }
        return this.componente;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }
}

